%{

/*
 * program: psfilt
 * file: lex-ppd.l
 *
 * Copyright  1992 1993 Robert Joop
 *
 * This file implements the lexical analysis for input of PPD-Files.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: lex-ppd.l,v $
 * Revision 1.3  1994/07/09  16:43:51  rj
 * a lot of const's removed and added
 *
 * Revision 1.2  1994/01/09  23:45:50  rj
 * PPD parser fr version 4 PPD files total umgeschrieben.
 * partieller support fr perl.
 *
 * Revision 1.1.1.1  1993/12/31  20:56:38  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: lex-ppd.l,v 1.3 1994/07/09 16:43:51 rj Exp $";

#ifdef FLEX_SCANNER	/* flex declares free() as function returning int!	*/
#  define DONT_INCLUDE_MALLOC_H
#endif

#include "psfilt.h"
#include "ppd.h"
#include "lex-ppd.h"
#include "parse-ppd.h"	/* generated by bison	*/
#include "str.h"
#include "error.h"

/* parse-ppd.y defines a %pure_parser, so...	*/
#undef YY_DECL
#ifdef __STDC__
#  define DECL		int lex_ppd (YYSTYPE *lvalp)
#  define YY_DECL	DECL; DECL /* first one is a prototype */
#else
#  define YY_DECL	int lex_ppd (lvalp) YYSTYPE *lvalp;
#endif

/* flex normally read(2)s from (fileno (yyin)), but we also want to read from strings... (like sscanf(3))	*/
#undef YY_INPUT
#define YY_INPUT(buf, result, max_size)	\
			result = fread (buf, 1, max_size, yyin)

typedef struct
{
  t_ppdjobtype		type;
  t_fnbuf		fnbuf;
  t_fileinfo		fileinfo;
  YY_BUFFER_STATE	buffer;
  int			lineno;
  int			state,
			around_val,
			around_qv,
			around_hex,
			around_translation;
} t_lexjob;

#define begin(newstate)	BEGIN (job->state = (newstate))

static t_list	*jobstack;
static t_lexjob	*job;

static void freeppdjob (t_lexjob *job)
{
  yy_delete_buffer (job->buffer);
  pfclose (&job->fileinfo);
}

void ppdsay (t_verblevel importance, cstring fmt, ...)
{
  va_list	va;

  say (importance, "ppd scanner: file %s, line %d: ", job->fnbuf, job->lineno);
  va_start (va, fmt);
  vsay (importance, fmt, va);
  va_end (va);
  say (importance, "\n");
}

static t_filter	ppdsuffices[] =
{
  { ".PPD", NULL },
  { ".ppd", NULL },
  { NULL }
};

int push_ppdlexer (t_ppdjobtype jobtype, string s)
{
  FILE		*fp;

  if (!jobstack)
    jobstack = licreate (sizeof (t_lexjob), NULL, freeppdjob);
  assert (jobstack);
  job = lipush (jobstack, NULL);

  if (!(fp = pfopenpath (ppddirs, s, (job->type=jobtype)==JT_printer ? ppdsuffices : nofilter, O_rdonly, job->fnbuf, &job->fileinfo)))
    return fault;

  job->buffer = yy_create_buffer (fp, YY_BUF_SIZE);
  yy_switch_to_buffer (job->buffer);
  job->lineno = 1;
  begin (Key);

  return ok;
}

int pop_ppdlexer()
{
  if (!jobstack || !lilength (jobstack))
    ierror ("ppd lexer: empty job stack");
  lidelete (jobstack, 1);
  if (job = lifirst (jobstack))
  {
    yy_switch_to_buffer (job->buffer);
    return ok;
  }
  else
    return fault;
}

#define c2x(c)	((c)<='9'?(c)-'0':((c)&0x0f)+9)

static char	hex;
static t_binstr	binstr;

static void start_buf()
{
  binstr.used = 0;
}

#define APPEND	binstrcat (&binstr, yytext, yyleng)

static inline void buf_append1 (char c)
{
  binstrcat (&binstr, &c, 1);
}

static void end_buf()
{
  buf_append1 ('\0');
}

#if BINARY_STRINGS
static t_binstr save_buf()
{
  return binstrsave (&binstr);
}
#else
static string save_buf()
{
  return strsave (binstr.buf);
}
#endif

%}

wsp	[ \t]
digit	[0-9]
xdig	[0-9A-Fa-f]
alnum	[0-9A-Za-z]
NL	(\r\n?|\r?\n)

%x Include Key Default Query afterKey OptionSymbol OptionString OptionTranslation afterNoOption afterOption InvocationValue QuotedValue HexHighNibble HexLowNibble SymbolValue StringValue Translation

%pointer

%%

<Key>{NL}				job->lineno++; /* empty line */
<Key>\*%.*				begin (afterKey); /* comment */

<afterKey>{NL}				{
					  job->lineno++;
					  begin (Key); /* NoValue */
					}
<afterKey>{wsp}+\^			begin (OptionSymbol);
<afterKey>{wsp}+			begin (OptionString);
<afterKey>:				begin (job->around_val = afterNoOption);

<OptionSymbol>[^/:\r\n]+		{
					  lvalp->option.type = PPD_SymbolOption;
					  lvalp->option.value = strunique (yytext);
					  return Option;
					}
<OptionString>[^/:\r\n]+		{
					  begin (OptionTranslation);
					  lvalp->option.type = PPD_StringOption;
					  lvalp->option.value = strunique (yytext);
					  return Option;
					}
<OptionSymbol,OptionString>\/		begin (OptionTranslation);
<OptionSymbol,OptionString>:		begin (job->around_val = afterOption);

<Key>\*Include:{wsp}*\"			{
					  start_buf();
					  job->around_qv = Include;
					  begin (QuotedValue);
					}
<Include>{NL}				{
					  end_buf();
					  job->lineno++;
					  begin (Key); /* for the including file */
					  ppdsay (IMP_entertain, "including `%s'", binstr.buf);
					  if (push_ppdlexer (JT_file, binstr.buf))
					  {
					    ppdsay (IMP_error, "can't open `%s'", binstr.buf);
					    exit (1);
					  }
					  begin (Key); /* for the included file */
					}
<<EOF>>					{
					  if (pop_ppdlexer())
					    yyterminate();
					  else
					    begin (job->state);
					}

<afterOption>{wsp}*\"			{
					  start_buf();
					  begin (InvocationValue);
					}
<afterNoOption>{wsp}*\"			{
					  start_buf();
					  job->around_qv = job->state;
					  begin (QuotedValue);
					}
<afterNoOption,afterOption>{wsp}*^	{
					  job->around_val = job->state;
					  begin (SymbolValue);
					}
<afterNoOption,afterOption>{wsp}*	{
					  job->around_val = job->state;
					  begin (StringValue);
					}
<afterNoOption,afterOption>{NL}		{
					  job->lineno++;
					  begin (Key);
					}

<InvocationValue>[^"\r\n]*		APPEND;
<InvocationValue>{NL}			{
					  job->lineno++;
					  buf_append1 ('\n');
					}
<InvocationValue>\"			{
					  end_buf();
					  begin (afterOption);
					  lvalp->value.type = PPD_InvocationValue;
#if BINARY_STRINGS
					  lvalp->value.value.str = strsave (binstr.buf);
#else
					  lvalp->value.value = strsave (binstr.buf);
#endif
					  return InvocationVal;
					}

<QuotedValue>[^<"\r\n]*			APPEND;
<QuotedValue>{NL}			{
					  job->lineno++;
					  buf_append1 ('\n');
					}
<QuotedValue>"<"			{
					  job->around_hex = QuotedValue;
					  begin (HexHighNibble);
					}
<QuotedValue>\"				{
					  begin (job->around_qv);
					  end_buf();
					  lvalp->value.type = PPD_QuotedValue;
#if BINARY_STRINGS
					  lvalp->value.value.bin = save_buf();
#else
					  lvalp->value.value = save_buf();
#endif
					  return QuotedVal;
					}

<SymbolValue>[^\t\r\n\f ]*		{
					  lvalp->value.type = PPD_SymbolValue;
#if BINARY_STRINGS
					  lvalp->value.value.str = strunique (yytext);
#else
					  lvalp->value.value = strunique (yytext);
#endif
					  return SymbolVal;
					}

<StringValue>[^ \r\n/]*			{
					  lvalp->value.type = PPD_StringValue;
#if BINARY_STRINGS
					  lvalp->value.value.str = strunique (yytext);
#else
					  lvalp->value.value = strunique (yytext);
#endif
					  return StringVal;
					}
<StringValue>\/				{
					  job->around_translation = Key;
					  begin (Translation);
					}

<SymbolValue,StringValue>{wsp}		{
					  begin (job->around_val);
					  unput (' '); /* we need another {wsp} */
					}
<SymbolValue,StringValue>{NL}		{
					  job->lineno++;
					  begin (Key);
					}

<OptionTranslation>[^<:\r\n]*		;
<Translation>[^<\r\n]*			;
<OptionTranslation,Translation>"<"	{
					  job->around_hex = job->state;
					  begin (HexHighNibble);
					}
<OptionTranslation>:			begin (job->around_val = afterOption);
<Translation>{NL}			{
					  job->lineno++;
					  begin (job->around_translation);
					}

<HexHighNibble,HexLowNibble>{wsp}+	;
<HexHighNibble,HexLowNibble>{NL}	job->lineno++;
<HexHighNibble>{xdig}			{
					  hex = c2x (*yytext) << 4;
					  begin (HexLowNibble);
					}
<HexLowNibble>{xdig}			{
					  buf_append1 (hex | c2x (*yytext));
					  begin (HexHighNibble);
					}
<HexHighNibble>">"			begin (job->around_hex);

<Key>\*Default				begin (Default);
<Default>[^ :\r\n]*			{
					  (void)memcpy (lvalp->key, yytext, yyleng+1);
					  begin (afterKey);
					  return DefaultKeyword;
					}
<Key>\*\?				begin (Query);
<Query>[^ :\r\n]*			{
					  (void)memcpy (lvalp->key, yytext, yyleng+1);
					  begin (afterKey);
					  return QueryKeyword;
					}
<Key>\*[^ :\r\n]*			{
					  (void)memcpy (lvalp->key, yytext+1, yyleng);
					  begin (afterKey);
					  return Keyword;
					}

<*>.|\n					{
					  ppdsay (IMP_error, "illegal input character %#o/%d/%#x", *yytext, *yytext, *yytext);
					  return *yytext;
					}

%%

static int prelistppd (string dir, va_list va)
{
  string	*currentppddir = va_arg (va, string *);

  say (IMP_error, "directory %s:\n", *currentppddir = dir);
  return ok;
}

static int listppdfile (FILE *fp, t_fileinfo *fileinfo, va_list va)
{
  string	*currentppddir = va_arg (va, string *);
  int		dirnmlen, sufflen;
  string	basenm;

  dirnmlen = strlen (*currentppddir);
  basenm = fileinfo->fullname+dirnmlen+1;
  sufflen = (fileinfo->clientfilter->suffix ? strlen (fileinfo->clientfilter->suffix) : 0) + (fileinfo->stdfilter->suffix ? strlen (fileinfo->stdfilter->suffix) : 0);

  say (IMP_error, "\t%.*s\n", strlen (basenm)-sufflen, basenm);
  return ok;
}

void listppdfiles()
{
  t_fnbuf	fnbuf;
  string	currentppddir;

  findfiles (ppddirs, ppdsuffices, O_rdonly, fnbuf, prelistppd, listppdfile, NULL, &currentppddir);
}

t_list	*ppddirs = NULL;
