#undef YY_NULL
#define YY_NULL	-1

/*
 * program: psfilt
 * file: lex-input.h
 *
 * Copyright  1992 1993 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: lex-input.h,v 1.5 1994/07/09 17:34:35 rj Exp $
 * $Log: lex-input.h,v $
 * Revision 1.5  1994/07/09  17:34:35  rj
 * input token buffers (especially in mail mode) are no longer in danger of overflowing
 *
 * Revision 1.4  1994/07/09  17:21:45  rj
 * stopping to read at NUL characters stopped
 *
 * Revision 1.3  1994/07/09  16:43:46  rj
 * a lot of const's removed and added
 *
 * Revision 1.2  1994/01/09  23:45:46  rj
 * PPD parser fr version 4 PPD files total umgeschrieben.
 * partieller support fr perl.
 *
 * Revision 1.1.1.1  1993/12/31  20:56:39  rj
 * erster cvs import.
 *
 */

#include "ucs2.h"
#include "input.h"

typedef union
{
  string	option;
  t_ucs2	ucs2;
  bool		boolean;
  double	factor;
  int		number;
  t_point	size;
#ifdef COLORED
  t_color	color;
#endif
  char		text[32];
  struct
  {
    int		len;
    char	*buf;
  }		ltext;
} t_inputtoken;	/* for lex-input.l	*/

/* from lex-input.l:	*/
extern int	lex_input (t_inputtoken *lvalp);
extern void	pushlexjob (cstring fn, FILE *fp, const t_input *, const t_inout *, int *lineno, int *colno);
extern void	poplexjob (void);

enum
{
  OPT_NAME = 1024,	/* a number big enough to avoid conflict with bison's token values (parse-input.y) */
  OPT_ARG,
  END_OPT,

/* 1027 */
  TAB,
  INDENT,
  escapedNEWLINE,
  NEWLINE,
  NEWPAGE,

/* 1032 */
  ENTER_TRANSLATION,
  LEAVE_TRANSLATION,
  LEAVE_TRANSLATION__NEWLINE,
  STRING,
  lSTRING,

/* 1037 */
  ITALIC_CHAR,
  BOLD_CHAR,

/* 1039 */
  TROFF_HYPHENATION,
  TROFF_SPACE,
  /* TROFF_CHAR1, (directly translated into UCS2 by lex) */
  TROFF_CHAR2,
  TROFF_FONTn,
  TROFF_FONT1,
  TROFF_FONT2,
  TROFF_FONT,
  TROFF_SIZE,
  TROFF_half_line_up,
  TROFF_half_line_down,
  TROFF_STRING1,
  TROFF_STRING2,
  TROFF_DIACRITIC,

/* 1052 */
  BEGIN_COMMAND,
  COMMAND_SYMBOL,
  COMMAND_NAME,
  COMMAND_PLUSMINUS,
  COMMAND_FACTOR,
  COMMAND_NUMBER,
  COMMAND_SIZE,
  COMMAND_COLOR,
  COMMAND_MNEMO,
  END_COMMAND,

/* 1062 */
  TEX_DIACRITIC,

  GLYPH,

  MailHeaderBeginField,
  MailHeaderContField,
  MailEndHeader,
  MailBody,
  MailEndBody,
#if 0
  SENDMAIL_DIACRITIC,
#endif
};
