%{

/*
 * program: psfilt
 * file: lex-afm.l
 *
 * Copyright  1992 1993 Robert Joop
 *
 * Lexer for .afm-files.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: lex-afm.l,v $
 * Revision 1.1.1.1  1993/12/31  20:56:38  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: lex-afm.l,v 1.1.1.1 1993/12/31 20:56:38 rj Exp $";

#include <ctype.h>
#include <math.h>	/* atof() */

#include "psfilt.h"
#include "afm.h"
#include "lex-afm.h"
#include "parse-afm.h"	/* generated by bison	*/
#include "error.h"

/* parse-afm.y defines a %pure_parser, so...	*/
#undef YY_DECL
#define DECL		int lex_afm (YYSTYPE *lvalp)
#define YY_DECL		DECL; DECL /* first is a prototype */

int		yylineno_afm;

static int	nnames;

static int	stack[10];
static int	sp;

static void push (int state);
static void pop (void);

%}

L [A-Za-z]
D [0-9]

%s _string _name _char_metrics _kern _track_kern _pair_kern _composites

%%

<INITIAL>StartFontMetrics	{ push (_string); return STARTFONTMETRICS; }
<INITIAL>EndFontMetrics		return ENDFONTMETRICS;
<INITIAL>FontName		{ push (_string); return FONTNAME; }
<INITIAL>FullName		{ push (_string); return FULLNAME; }
<INITIAL>FamilyName		{ push (_string); return FAMILYNAME; }
<INITIAL>Weight			{ push (_string); return WEIGHT; }
<INITIAL>ItalicAngle		return ITALICANGLE;
<INITIAL>IsFixedPitch		return ISFIXEDPITCH;
<INITIAL>FontBBox		return FONTBBOX;
<INITIAL>Underline\ *Position	return UNDERLINEPOSITION;
<INITIAL>Underline\ *Thickness	return UNDERLINETHICKNESS;
<INITIAL>Version		{ push (_string); return VERSION_; }
<INITIAL>Notice			{ push (_string); return NOTICE; }
<INITIAL>EncodingScheme 	{ push (_string); return ENCODINGSCHEME; }
<INITIAL>CapHeight		return CAPHEIGHT;
<INITIAL>XHeight		return XHEIGHT;
<INITIAL>Ascender		return ASCENDER;
<INITIAL>Descender		return DESCENDER;

<INITIAL>StartCharMetrics	{ push (_char_metrics); return STARTCHARMETRICS; }
<_char_metrics>C		return C;
<_char_metrics>WX		return WX;
<_char_metrics>W		return W;
<_char_metrics>N		{ push (_name); nnames = 1; return N; }
<_char_metrics>B		return B;
<_char_metrics>L		{ push (_name); nnames = 2; return L; }
<_char_metrics>EndCharMetrics	{ pop(); return ENDCHARMETRICS; }

<INITIAL>StartKernData		{ push (_kern); return STARTKERNDATA; }
<_kern>EndKernData		{ pop(); return ENDKERNDATA; }
<_kern>StartTrackKern		{ push (_track_kern); return STARTTRACKKERN; }
<_track_kern>TrackKern		return TRACKKERN;
<_track_kern>EndTrackKern	{ pop(); return ENDTRACKKERN; }
<_kern>StartKernPairs		{ push (_pair_kern); return STARTKERNPAIRS; }
<_pair_kern>KP			{ push (_name); nnames = 2; return KP; }
<_pair_kern>KPX			{ push (_name); nnames = 2; return KPX; }
<_pair_kern>EndKernPairs	{ pop(); return ENDKERNPAIRS; }

<INITIAL>StartComposites	{ push (_composites); return STARTCOMPOSITES; }
<_composites>CC			{ push (_name); nnames = 1; return CC; }
<_composites>PCC		{ push (_name); nnames = 1; return PCC; }
<_composites>EndComposites	{ pop(); return ENDCOMPOSITES; }

Comment[ \t][^\r\n]*		;
true				return TRUE;
false				return FALSE;
[+-]?{D}+			{
				  lvalp->number = atoi ((char *)yytext);
				  return INTEGER;
				}
[+-]?{D}+\.{D}+			{
				  lvalp->real = atof ((char *)yytext);
				  return REAL;
				}
[ \t]				;
(\r\n?|\r?\n)			{
				  yylineno_afm++;
				}
<_name>{L}({L}|{D}|[-./_])*	{
				  lvalp->str = strsave ((char *)yytext);
				  if (!--nnames)
				    pop();
				  return NAME;
				}
<_string>[^\r\n]*		{
				  int l, r;

				  for (l=0; l<yyleng && isspace (yytext[l]); l++)
				    ;
				  for (r=yyleng; r-->l && isspace (yytext[r]); )
				    yytext[r] = '\0';
				  lvalp->str = strsave ((char *)yytext+l);
				  pop();
				  return STRING;
				}
.				return *yytext;

%%

static void clear (void)
{
  sp = ARRAYDIM (stack);
  push (INITIAL);
}

static void push (int state)
{
  if (!sp)
    ierror ("afm lexer: state stack overflow");
  stack[--sp] = state;
  BEGIN (state);
}

static void pop (void)
{
  if (sp++ == ARRAYDIM (stack))
    ierror ("afm lexer: state stack underflow");
  BEGIN (stack[sp]);
}

void init_afmlexer (FILE *fp)
{
  if (yyin)
    yyrestart (fp);
  else
    yyin = fp;
  yylineno_afm = 1;
  clear();
}
