/*
 * program: psfilt
 * file: job.h
 *
 * Copyright  1992 1993 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: job.h,v 1.2 1994/07/09 16:43:45 rj Exp $
 * $Log: job.h,v $
 * Revision 1.2  1994/07/09  16:43:45  rj
 * a lot of const's removed and added
 *
 * Revision 1.1.1.1  1993/12/31  20:56:39  rj
 * erster cvs import.
 *
 */

#ifndef JOB_H
#define JOB_H

#include "input.h"
#include "output.h"

typedef enum
{
  JOB_void,
  JOB_STRING,
  JOB_STDIN,
  JOB_FILE,
} t_jobsource;

typedef struct
{
  t_jobsource	srctype;
  union
  {
    string	str;
    string	fn;
  } source;

  t_input	input;
  t_inout	inout;
  t_foutput	output;
} t_job;

extern t_job	defaultjob (t_encoding encoding, t_translation, string fontfamily, t_point fontsize);
extern cstring	jobname (const t_job *job);

/* defined in parse-input.y: */
extern t_list	*parse_input (t_job *job, bool link);
extern t_list	*parse_string (string str, t_encoding encoding, t_translation, string fontfamily, t_point fontsize, bool link);

#endif JOB_H
