/*
 * program: psfilt
 * file: job.c
 *
 * Copyright  1992 1993 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: job.c,v $
 * Revision 1.4  1994/08/19  09:36:36  rj
 * IT_TEXTline mode for mail and news
 *
 * Revision 1.3  1994/07/09  16:43:43  rj
 * a lot of const's removed and added
 *
 * Revision 1.2  1994/03/18  12:07:30  rj
 * support for duplex mode added
 * lots of missing `#ifdef COLORED' inserted
 *
 * Revision 1.1.1.1  1993/12/31  20:56:42  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: job.c,v 1.4 1994/08/19 09:36:36 rj Exp $";

#include "psfilt.h"
#include "job.h"

t_job defaultjob (t_encoding encoding, t_translation translation, string fontfamily, t_point fontsize)
{
  t_job	job;

  job.srctype = JOB_void;

  job.input.type = IT_TEXTline;
  job.input.encoding = encoding;
  job.input.translation = translation;
  job.input.verbmode = VERB_MIXED;
  job.input.tabcolumns = 8;

  job.inout.mode = IOM_trlt;		/* IT_TEXT(line) is always translated */
  job.inout.tabmode = TMsimple;

#ifdef COLORED
  clearcolor (&job.output.color[IOM_lit]);
  clearcolor (&job.output.color[IOM_trlt]);
#endif
  job.output.font[IOM_lit].family = NULL;
  job.output.font[IOM_trlt].family = fontfamily;
  job.output.font[IOM_trlt].rendition.weight = FONTWEIGHT_normal;
  job.output.font[IOM_trlt].rendition.italic = false;
  job.output.font[IOM_trlt].size = fontsize;
  job.output.linespacing.automatic = true;
  job.output.linespacing.relative = true;
  job.output.linespacing.height.factor = 1.2;
  job.output.linespacing.minheight = 1.2 * fontsize;
  job.output.tabs.relative = true;
  job.output.tabs.width.factor = job.input.tabcolumns * (streq (fontfamily, "Courier") ? 0.6 : 0.5);

  return job;
}

cstring jobname (const t_job *job)
{
  switch (job->srctype)
  {
    case JOB_void:	return "<void>";
    case JOB_STRING:	return "<string>";
    case JOB_STDIN:	return "<stdin>";
    case JOB_FILE:	return job->source.fn;
    default:		abort();
  }
}
