/*
 * program: psfilt
 * file: iso8859.c
 *
 * Copyright  1992 1993 Robert Joop
 *
 *	convert ISO-8859-1-codes (ISO Latin 1) into UCS2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: iso8859.c,v $
 * Revision 1.1.1.1  1993/12/31  20:56:44  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: iso8859.c,v 1.1.1.1 1993/12/31 20:56:44 rj Exp $";

#include "psfilt.h"
#include "ucs2list.h"
#include "iso8859.h"

/* ATTENTION: codes 0 - 127 are omitted! (they identical to ISO 646 IRV, so see iso646.c) */
static t_ucs2 ISOlatin1_to_UCS2_table[] =
{
  /* 0x80 */
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,

  /* 0x90 */
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,

  /* 0xa0 */
  UCS2_non_breaking_space,
  UCS2_inverted_exclamation_mark,
  UCS2_cent_sign,
  UCS2_pound_sign,
  UCS2_currency_sign,
  UCS2_yen_sign,
  UCS2_broken_bar,
  UCS2_section_sign,
  UCS2_spacing_diaeresis,
  UCS2_copyright_sign,
  UCS2_feminine_ordinal_indicator,
  UCS2_left_pointing_guillemet,
  UCS2_not_sign,
  UCS2_soft_hyphen,
  UCS2_registered_trade_mark_sign,
  UCS2_spacing_macron,

  /* 0xb0 */
  UCS2_degree_sign,
  UCS2_plus_or_minus_sign,
  UCS2_superscript_digit_two,
  UCS2_superscript_digit_three,
  UCS2_spacing_acute,
  UCS2_micro_sign,
  UCS2_paragraph_sign,
  UCS2_middle_dot,
  UCS2_spacing_cedilla,
  UCS2_superscript_digit_one,
  UCS2_masculine_ordinal_indicator,
  UCS2_right_pointing_guillemet,
  UCS2_fraction_one_quarter,
  UCS2_fraction_one_half,
  UCS2_fraction_three_quarters,
  UCS2_inverted_question_mark,

  /* 0xc0 */
  UCS2_latin_capital_letter_a_grave,
  UCS2_latin_capital_letter_a_acute,
  UCS2_latin_capital_letter_a_circumflex,
  UCS2_latin_capital_letter_a_tilde,
  UCS2_latin_capital_letter_a_diaeresis,
  UCS2_latin_capital_letter_a_ring,
  UCS2_latin_capital_letter_a_e,
  UCS2_latin_capital_letter_c_cedilla,
  UCS2_latin_capital_letter_e_grave,
  UCS2_latin_capital_letter_e_acute,
  UCS2_latin_capital_letter_e_circumflex,
  UCS2_latin_capital_letter_e_diaeresis,
  UCS2_latin_capital_letter_i_grave,
  UCS2_latin_capital_letter_i_acute,
  UCS2_latin_capital_letter_i_circumflex,
  UCS2_latin_capital_letter_i_diaeresis,

  /* 0xd0 */
  UCS2_latin_capital_letter_eth,
  UCS2_latin_capital_letter_n_tilde,
  UCS2_latin_capital_letter_o_grave,
  UCS2_latin_capital_letter_o_acute,
  UCS2_latin_capital_letter_o_circumflex,
  UCS2_latin_capital_letter_o_tilde,
  UCS2_latin_capital_letter_o_diaeresis,
  UCS2_multiplication_sign,
  UCS2_latin_capital_letter_o_slash,
  UCS2_latin_capital_letter_u_grave,
  UCS2_latin_capital_letter_u_acute,
  UCS2_latin_capital_letter_u_circumflex,
  UCS2_latin_capital_letter_u_diaeresis,
  UCS2_latin_capital_letter_y_acute,
  UCS2_latin_capital_letter_thorn,
  UCS2_latin_small_letter_sharp_s,

  /* 0xe0 */
  UCS2_latin_small_letter_a_grave,
  UCS2_latin_small_letter_a_acute,
  UCS2_latin_small_letter_a_circumflex,
  UCS2_latin_small_letter_a_tilde,
  UCS2_latin_small_letter_a_diaeresis,
  UCS2_latin_small_letter_a_ring,
  UCS2_latin_small_letter_a_e,
  UCS2_latin_small_letter_c_cedilla,
  UCS2_latin_small_letter_e_grave,
  UCS2_latin_small_letter_e_acute,
  UCS2_latin_small_letter_e_circumflex,
  UCS2_latin_small_letter_e_diaeresis,
  UCS2_latin_small_letter_i_grave,
  UCS2_latin_small_letter_i_acute,
  UCS2_latin_small_letter_i_circumflex,
  UCS2_latin_small_letter_i_diaeresis,

  /* 0xf0 */
  UCS2_latin_small_letter_eth,
  UCS2_latin_small_letter_n_tilde,
  UCS2_latin_small_letter_o_grave,
  UCS2_latin_small_letter_o_acute,
  UCS2_latin_small_letter_o_circumflex,
  UCS2_latin_small_letter_o_tilde,
  UCS2_latin_small_letter_o_diaeresis,
  UCS2_division_sign,
  UCS2_latin_small_letter_o_slash,
  UCS2_latin_small_letter_u_grave,
  UCS2_latin_small_letter_u_acute,
  UCS2_latin_small_letter_u_circumflex,
  UCS2_latin_small_letter_u_diaeresis,
  UCS2_latin_small_letter_y_acute,
  UCS2_latin_small_letter_thorn,
  UCS2_latin_small_letter_y_diaeresis,
};

t_ucs2 ISOlatin1toUCS2 (uchar c)
{
#if 0
  return c & 0x80 ? ISOlatin1_to_UCS2_table[c&0x7f] : ISO646toUCS2 (c);
#else /* we wan't a dollar sign! */
  return c & 0x80 ? ISOlatin1_to_UCS2_table[c&0x7f] : ASCIItoUCS2 (c);
#endif
}
