/*
 * program: psfilt
 * file: iso646.h
 *
 * Copyright  1992 1993 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: iso646.h,v 1.1.1.1 1993/12/31 20:56:44 rj Exp $
 * $Log: iso646.h,v $
 * Revision 1.1.1.1  1993/12/31  20:56:44  rj
 * erster cvs import.
 *
 */

#ifndef ISO646_H
#define ISO646_H

#include "ucs2.h"

enum
{
  ISO646_NUL,
  ISO646_SOH,
  ISO646_STX,
  ISO646_ETX,
  ISO646_EOT,
  ISO646_ENQ,
  ISO646_ACK,
  ISO646_BEL,

  ISO646_BS,
  ISO646_HT,
  ISO646_LF,
  ISO646_VT,
  ISO646_FF,
  ISO646_CR,
  ISO646_SO,
  ISO646_SI,

  ISO646_DLE,
  ISO646_DC1,
  ISO646_DC2,
  ISO646_DC3,
  ISO646_DC4,
  ISO646_NAK,
  ISO646_SYN,
  ISO646_ETB,

  ISO646_CAN,
  ISO646_EM,
  ISO646_SUB,
  ISO646_ESC,
  ISO646_FS,
  ISO646_GS,
  ISO646_RS,
  ISO646_US,

  ISO646_SPACE,

  ISO646_DEL = 127,
};

extern t_ucs2	ISO646toUCS2 (uchar c),
		ASCIItoUCS2 (uchar c),
		DIN66003toUCS2 (uchar c);

#endif
