/*
 * program: psfilt
 * file: iso646.c
 *
 * Copyright  1992 1993 Robert Joop
 *
 *	convert ISO 646 codes into UCS2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: iso646.c,v $
 * Revision 1.2  1994/07/09  17:21:44  rj
 * stopping to read at NUL characters stopped
 *
 * Revision 1.1.1.1  1993/12/31  20:56:44  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: iso646.c,v 1.2 1994/07/09 17:21:44 rj Exp $";

#include "psfilt.h"
#include "ucs2list.h"
#include "iso646.h"

static t_ucs2 ISO646_to_UCS2_table[] =
{
#if 0 /* es gibt keine ...symbol_for_... in der adobemap */
  UCS2_symbol_for_null,				/* ISO646_NUL	*/
  UCS2_symbol_for_start_of_heading,		/* ISO646_SOH	*/
  UCS2_symbol_for_start_of_text,		/* ISO646_STX	*/
  UCS2_symbol_for_end_of_text,			/* ISO646_ETX	*/
  UCS2_symbol_for_end_of_transmission,		/* ISO646_EOT	*/
  UCS2_symbol_for_enquiry,			/* ISO646_ENQ	*/
  UCS2_symbol_for_acknowledge,			/* ISO646_ACK	*/
  UCS2_symbol_for_bell,				/* ISO646_BEL	*/
  UCS2_symbol_for_backspace,			/* ISO646_BS	*/

  UCS2_symbol_for_horizontal_tabulation,	/* ISO646_HT	*/
  UCS2_symbol_for_line_feed,			/* ISO646_LF	*/
  UCS2_symbol_for_vertical_tabulation,		/* ISO646_VT	*/
  UCS2_symbol_for_form_feed,			/* ISO646_FF	*/
  UCS2_symbol_for_carriage_return,		/* ISO646_CR	*/
  UCS2_symbol_for_shift_out,			/* ISO646_SO	*/
  UCS2_symbol_for_shift_in,			/* ISO646_SI	*/

  UCS2_symbol_for_data_link_escape,		/* ISO646_DLE	*/
  UCS2_symbol_for_device_control_one,		/* ISO646_DC1	*/
  UCS2_symbol_for_device_control_two,		/* ISO646_DC2	*/
  UCS2_symbol_for_device_control_three,		/* ISO646_DC3	*/
  UCS2_symbol_for_device_control_four,		/* ISO646_DC4	*/
  UCS2_symbol_for_negative_acknowledge,		/* ISO646_NAK	*/
  UCS2_symbol_for_synchronous_idle,		/* ISO646_SYN	*/
  UCS2_symbol_for_end_of_transmission_block,	/* ISO646_ETB	*/

  UCS2_symbol_for_cancel,			/* ISO646_CAN	*/
  UCS2_symbol_for_end_of_medium,		/* ISO646_EM	*/
  UCS2_symbol_for_substitute,			/* ISO646_SUB	*/
  UCS2_symbol_for_escape,			/* ISO646_ESC	*/
  UCS2_symbol_for_file_separator,		/* ISO646_FS	*/
  UCS2_symbol_for_group_separator,		/* ISO646_GS	*/
  UCS2_symbol_for_record_separator,		/* ISO646_RS	*/
  UCS2_symbol_for_unit_separator,		/* ISO646_US	*/
#else
  UCS2_VOID, UCS2_VOID, UCS2_VOID, UCS2_VOID,
  UCS2_VOID, UCS2_VOID, UCS2_VOID, UCS2_VOID,

  UCS2_VOID, UCS2_VOID, UCS2_VOID, UCS2_VOID,
  UCS2_VOID, UCS2_VOID, UCS2_VOID, UCS2_VOID,

  UCS2_VOID, UCS2_VOID, UCS2_VOID, UCS2_VOID,
  UCS2_VOID, UCS2_VOID, UCS2_VOID, UCS2_VOID,

  UCS2_VOID, UCS2_VOID, UCS2_VOID, UCS2_VOID,
  UCS2_VOID, UCS2_VOID, UCS2_VOID, UCS2_VOID,
#endif

  UCS2_space,
  UCS2_exclamation_mark,
  UCS2_quotation_mark,
  UCS2_number_sign,
  UCS2_currency_sign,
  UCS2_percent_sign,
  UCS2_ampersand,
  UCS2_apostrophe_quote,
  UCS2_opening_parenthesis,
  UCS2_closing_parenthesis,
  UCS2_asterisk,
  UCS2_plus_sign,
  UCS2_comma,
  UCS2_hyphen_minus,
  UCS2_period,
  UCS2_slash,

  UCS2_digit_zero,
  UCS2_digit_one,
  UCS2_digit_two,
  UCS2_digit_three,
  UCS2_digit_four,
  UCS2_digit_five,
  UCS2_digit_six,
  UCS2_digit_seven,
  UCS2_digit_eight,
  UCS2_digit_nine,
  UCS2_colon,
  UCS2_semicolon,
  UCS2_less_than_sign,
  UCS2_equals_sign,
  UCS2_greater_than_sign,
  UCS2_question_mark,

  UCS2_commercial_at,
  UCS2_latin_capital_letter_a,
  UCS2_latin_capital_letter_b,
  UCS2_latin_capital_letter_c,
  UCS2_latin_capital_letter_d,
  UCS2_latin_capital_letter_e,
  UCS2_latin_capital_letter_f,
  UCS2_latin_capital_letter_g,
  UCS2_latin_capital_letter_h,
  UCS2_latin_capital_letter_i,
  UCS2_latin_capital_letter_j,
  UCS2_latin_capital_letter_k,
  UCS2_latin_capital_letter_l,
  UCS2_latin_capital_letter_m,
  UCS2_latin_capital_letter_n,
  UCS2_latin_capital_letter_o,

  UCS2_latin_capital_letter_p,
  UCS2_latin_capital_letter_q,
  UCS2_latin_capital_letter_r,
  UCS2_latin_capital_letter_s,
  UCS2_latin_capital_letter_t,
  UCS2_latin_capital_letter_u,
  UCS2_latin_capital_letter_v,
  UCS2_latin_capital_letter_w,
  UCS2_latin_capital_letter_x,
  UCS2_latin_capital_letter_y,
  UCS2_latin_capital_letter_z,
  UCS2_opening_square_bracket,
  UCS2_backslash,
  UCS2_closing_square_bracket,
  UCS2_spacing_circumflex,
  UCS2_spacing_underscore,

  UCS2_spacing_grave,
  UCS2_latin_small_letter_a,
  UCS2_latin_small_letter_b,
  UCS2_latin_small_letter_c,
  UCS2_latin_small_letter_d,
  UCS2_latin_small_letter_e,
  UCS2_latin_small_letter_f,
  UCS2_latin_small_letter_g,
  UCS2_latin_small_letter_h,
  UCS2_latin_small_letter_i,
  UCS2_latin_small_letter_j,
  UCS2_latin_small_letter_k,
  UCS2_latin_small_letter_l,
  UCS2_latin_small_letter_m,
  UCS2_latin_small_letter_n,
  UCS2_latin_small_letter_o,

  UCS2_latin_small_letter_p,
  UCS2_latin_small_letter_q,
  UCS2_latin_small_letter_r,
  UCS2_latin_small_letter_s,
  UCS2_latin_small_letter_t,
  UCS2_latin_small_letter_u,
  UCS2_latin_small_letter_v,
  UCS2_latin_small_letter_w,
  UCS2_latin_small_letter_x,
  UCS2_latin_small_letter_y,
  UCS2_latin_small_letter_z,
  UCS2_opening_curly_bracket,
  UCS2_vertical_bar,
  UCS2_closing_curly_bracket,
  UCS2_tilde,
  UCS2_VOID,		/* ISO646_DEL */
};

t_ucs2 ISO646toUCS2 (uchar c)
{
  return c & 0x80 ? UCS2_VOID : ISO646_to_UCS2_table[c];
}

/* Exceptions to unique definitions:
 *	2/3 may be  or #
 *	2/4 may be $ or 
 *	4/0, 5/11-5/14, 6/0 and 7/11-7/14 are ,,national allocations``
 * zero: use ISO 646 IRV; non-zero: index into non-ISO-646-table */
static char map[] =
{         /*  0   1   2   3    4   5   6   7    8   9  10  11   12  13  14  15 */
   /*  0: */  0,  0,  0,  0,   0,  0,  0,  0,   0,  0,  0,  0,   0,  0,  0,  0,
   /*  1: */  0,  0,  0,  0,   0,  0,  0,  0,   0,  0,  0,  0,   0,  0,  0,  0,
   /*  2: */  0,  0,  0,  1,   2,  0,  0,  0,   0,  0,  0,  0,   0,  0,  0,  0,
   /*  3: */  0,  0,  0,  0,   0,  0,  0,  0,   0,  0,  0,  0,   0,  0,  0,  0,
   /*  4: */  3,  0,  0,  0,   0,  0,  0,  0,   0,  0,  0,  0,   0,  0,  0,  0,
   /*  5: */  0,  0,  0,  0,   0,  0,  0,  0,   0,  0,  0,  4,   5,  6,  7,  0,
   /*  6: */  8,  0,  0,  0,   0,  0,  0,  0,   0,  0,  0,  0,   0,  0,  0,  0,
   /*  7: */  0,  0,  0,  0,   0,  0,  0,  0,   0,  0,  0,  9,  10, 11, 12,  0,
};

static t_ucs2 ASCII_to_UCS2_table[] =
{
  /*  1: 2/3  */ UCS2_number_sign,
  /*  2: 2/4  */ UCS2_dollar_sign,		/* ASCII's only difference to the IRV */
  /*  3: 4/0  */ UCS2_commercial_at,
  /*  4: 5/11 */ UCS2_opening_square_bracket,
  /*  5: 5/12 */ UCS2_backslash,
  /*  6: 5/13 */ UCS2_closing_square_bracket,
  /*  7: 5/14 */ UCS2_spacing_circumflex,
  /*  8: 6/0  */ UCS2_spacing_grave,
  /*  9: 7/11 */ UCS2_opening_curly_bracket,
  /* 10: 7/12 */ UCS2_vertical_bar,
  /* 11: 7/13 */ UCS2_closing_curly_bracket,
  /* 12: 7/14 */ UCS2_tilde,
};

t_ucs2 ASCIItoUCS2 (uchar c)
{
  int	m;

  return c & 0x80 ? UCS2_VOID : (m = map[c]) ? ASCII_to_UCS2_table[m-1] : ISO646_to_UCS2_table[c];
}

static t_ucs2 DIN66003_to_UCS2_table[] =
{
  /*  1: 2/3  */ UCS2_number_sign,
  /*  2: 2/4  */ UCS2_dollar_sign,
  /*  3: 4/0  */ UCS2_commercial_at,
  /*  4: 5/11 */ UCS2_latin_capital_letter_a_diaeresis,
  /*  5: 5/12 */ UCS2_latin_capital_letter_o_diaeresis,
  /*  6: 5/13 */ UCS2_latin_capital_letter_u_diaeresis,
  /*  7: 5/14 */ UCS2_spacing_circumflex,
  /*  8: 6/0  */ UCS2_spacing_grave,
  /*  9: 7/11 */ UCS2_latin_small_letter_a_diaeresis,
  /* 10: 7/12 */ UCS2_latin_small_letter_o_diaeresis,
  /* 11: 7/13 */ UCS2_latin_small_letter_u_diaeresis,
  /* 12: 7/14 */ UCS2_latin_small_letter_sharp_s,
};

t_ucs2 DIN66003toUCS2 (uchar c)
{
  int	m;

  return c & 0x80 ? UCS2_VOID : (m = map[c]) ? DIN66003_to_UCS2_table[m-1] : ISO646_to_UCS2_table[c];
}
