/*
 * program: psfilt
 * file: input.h
 *
 * Copyright  1992 1993 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: input.h,v 1.4 1994/08/19 09:36:34 rj Exp $
 * $Log: input.h,v $
 * Revision 1.4  1994/08/19  09:36:34  rj
 * IT_TEXTline mode for mail and news
 *
 * Revision 1.3  1994/08/18  12:13:16  rj
 * new input mode for Tcl scripts.
 *
 * Revision 1.2  1994/01/09  23:45:45  rj
 * PPD parser fr version 4 PPD files total umgeschrieben.
 * partieller support fr perl.
 *
 * Revision 1.1.1.1  1993/12/31  20:56:39  rj
 * erster cvs import.
 *
 */

#ifndef INPUT_H
#define INPUT_H

#include "inout.h"
#include "verbmode.h"
#include "token.h"

typedef enum	/* ! -> inputtype_strings[] in input.c !	*/
{
  IT_options,		/* for internal use (meta options)	*/
  IT_guess,		/* examine file name and guess...	*/
  IT_TEXT,		/* text-file				*/
  IT_MAN,		/* processed manuals (nroff -man)	*/
  IT_MAKEFILE,		/* [Mm]akefile				*/
  IT_SHELL,		/* shell-script				*/
  IT_C,			/* C-source				*/
  IT_Cplusplus,		/* C++-source				*/
  IT_PERL,		/* perl script				*/
  IT_PS,		/* PostScript-source			*/
  IT_LISP,		/* Lisp-source				*/
  IT_TCL,		/* Tcl-source				*/
  IT_Mail,		/* mail (folder)			*/
  IT_News,		/* news (folder)			*/
  IT_TEXTline,		/* similar to IT_TEXT, but single line only (for JOB_STRING) */
} t_inputtype;

extern cstring	inputtypename (t_inputtype type);

typedef enum
{
  ENC_ISO646,		/* ISO 646 IRV encoding			*/
  ENC_ASCII,		/* ASCII encoding			*/
  ENC_DIN66003,		/* DIN 66003 encoding			*/
  ENC_ISOlatin1,	/* ISO Latin 1 encoding			*/
  ENC_CP437,		/* Codepage 437 a.k.a. "IBM ASCII" 	*/
} t_encoding;

typedef enum
{
  TRLT_none,		/* no translation			*/
  TRLT_guess,		/* examine input and try to guess...	*/
  TRLT_MAN,		/* processed manuals (nroff -man)	*/
  TRLT_TROFF,		/* troff				*/
  TRLT_MOS,		/* troff -mos				*/
  TRLT_MS,		/* troff -ms				*/
  TRLT_TEX,		/* TeX (oder LaTeX?)			*/
  TRLT_sendmail,	/* sendmail(1)'s mapping of diacritical marks	*/
} t_translation;

typedef struct
{
  t_inputtype	type;
  t_encoding	encoding;
  t_translation	translation;
  t_verbmode	verbmode;
  int		tabcolumns;
  bool		ignLFafterFF;
} t_input;

typedef struct
{
  bool		type;
  bool		encoding;
  bool		translation;
  bool		verbmode;
  bool		tabcolumns;
  bool		ignLFafterFF;
} t_inputbools;

extern void	input_handdown (t_input *child, const t_input *parent, const t_input *job);
extern void	input_handup (t_input *parent, const t_input *child);

#endif INPUT_H
