/*
 * program: psfilt
 * file: input.c
 *
 * Copyright  1992 1993 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: input.c,v $
 * Revision 1.2  1994/01/09  23:45:44  rj
 * PPD parser fr version 4 PPD files total umgeschrieben.
 * partieller support fr perl.
 *
 * Revision 1.1.1.1  1993/12/31  20:56:42  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: input.c,v 1.2 1994/01/09 23:45:44 rj Exp $";

#include "psfilt.h"
#include "input.h"

static cstring	inputtype_strings[] =
{
  "<meta options>",
  "<guess>",
  "text",
  "manual",
  "make file",
  "shell script",
  "C-source",
  "C++-source",
  "perl script",
  "PostScript",
  "Lisp source",
  "Mail",
  "News",
};

cstring inputtypename (t_inputtype type)
{
  assert (0 <= type && type < ARRAYDIM (inputtype_strings));
  return inputtype_strings[type];
}

void input_handdown (t_input *child, const t_input *parent, const t_input *job)
{
  child->type = job->type;
  if (parent->translation == TRLT_guess)
  {
    child->translation = job->translation;
    child->encoding = job->encoding;
  }
  else
  {
    child->translation = parent->translation;
    child->encoding = parent->encoding;
  }
  child->verbmode = parent->verbmode;
  child->tabcolumns = parent->tabcolumns;
  child->ignLFafterFF = parent->ignLFafterFF;
}

void input_handup (t_input *parent, const t_input *child)
{
  parent->verbmode = child->verbmode;
  parent->tabcolumns = child->tabcolumns;
  parent->ignLFafterFF = child->ignLFafterFF;
}
