/*
 * file: gdefs.h
 *
 * $Id: gdefs.h,v 1.1 1994/07/09 16:43:42 rj Exp $
 * $Log: gdefs.h,v $
 * Revision 1.1  1994/07/09  16:43:42  rj
 * a lot of const's removed and added
 *
 */

#ifndef GDEFS_H
#define GDEFS_H

#if STDC_HEADERS || HAVE_STRING_H
#ifndef _DEBUG_MALLOC_INC
#include <string.h>
#endif
/* An ANSI string.h and pre-ANSI memory.h might conflict.  */
#if !STDC_HEADERS && HAVE_MEMORY_H
#include <memory.h>
#endif /* not STDC_HEADERS and HAVE_MEMORY_H */
#else /* not STDC_HEADERS and not HAVE_STRING_H */
#ifndef _DEBUG_MALLOC_INC
#include <strings.h>
#endif
/* memory.h and strings.h conflict on some systems.  */
#endif /* not STDC_HEADERS and not HAVE_STRING_H */

#if HAVE_UNISTD_H
#include <sys/types.h>
#include <unistd.h>
#endif


#ifndef MAXPATHLEN
#  include <sys/param.h>
#endif

#include <stdio.h>
#include <assert.h>
#include <stdlib.h>

#ifndef NULL
#define NULL	0
#endif

#define elif		else if
#define forever		for (;;)

#if !defined (MIN) || !defined (MAX)
#  define MIN(a, b)	((a)<(b)?(a):(b))
#  define MAX(a, b)	((a)>(b)?(a):(b))
#endif

#define ARRAYDIM(a)	(sizeof (a)/sizeof (*(a)))

typedef void			*voidptr;
typedef enum { false, true }	bool;
enum { fault = -1, ok };

#ifdef NEED_UCHAR
  typedef unsigned char		uchar;
#endif
#ifdef NEED_USHORT
  typedef unsigned short	ushort;
#endif
#ifdef NEED_UINT
  typedef unsigned int		uint;
#endif
#ifdef NEED_ULONG
  typedef unsigned long		ulong;
#endif

typedef char		*string;
typedef const char	*cstring;

#define BUFLEN		256
typedef char		t_buf[BUFLEN];
typedef char		t_fnbuf[MAXPATHLEN];

#ifndef _DEBUG_MALLOC_INC
#  include "mem.h"
#endif

#endif GDEFS_H
