/*
 * program: psfilt
 * file: fonts.h
 *
 * Copyright  1992 1993 Robert Joop
 *
 * handling of external fonts and fontfamilies
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: fonts.h,v 1.2 1994/07/09 16:43:41 rj Exp $
 * $Log: fonts.h,v $
 * Revision 1.2  1994/07/09  16:43:41  rj
 * a lot of const's removed and added
 *
 * Revision 1.1.1.1  1993/12/31  20:56:45  rj
 * erster cvs import.
 *
 */

#ifndef FONTS_H
#define FONTS_H

#include "names.h"
#include "dirs.h"
#include "afm.h"

typedef struct
{
  string		fontname;
  t_avl			*afms;		/* (t_afmfile), nach version sortiert */
  t_avl			*fonts;		/* (t_fontfile), nach version sortiert */
} t_font;

typedef struct
{
  t_fileinfo		file;

  string		fontname;
  t_version		version;
} t_fontfile;

typedef struct
{
  t_fontweight		weight;
  bool			italic;
} t_fontrendition;

typedef struct
{
  string		familyname;
  t_avl			*fonts;	/* liste von (t_font), die pointer zeigen auf objekte in fonts */
} t_fontfamily;

extern t_list		*fontdirs;

extern int		fontpcmp (const t_font *l, const t_font *r);
extern int		fontppcmp (const t_font **l, const t_font **r);
extern void		freefont (t_font *font);

extern void		clearfontfile (t_fontfile *fontfile);
extern int		fontfilepcmpfilename (const t_fontfile *l, const t_fontfile *r);
extern int		fontfilepcmpversion (const t_fontfile *l, const t_fontfile *r);
extern int		fontfilepcmp (const t_fontfile *l, const t_fontfile *r);
extern int		printfontfile (const t_fontfile *fontfile, bool verbose);
extern void		freefontfile (t_fontfile *);

#endif FONTS_H
