/*
 * program: psfilt
 * file: fonts.c
 *
 * Copyright  1992 1993 Robert Joop
 *
 * handling of external fonts and fontfamilies
 * a fontfamily usually consists of a normal, italic, bold and bolditalic font
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: fonts.c,v $
 * Revision 1.3  1994/07/09  16:43:40  rj
 * a lot of const's removed and added
 *
 * Revision 1.2  1994/01/09  23:45:43  rj
 * PPD parser fr version 4 PPD files total umgeschrieben.
 * partieller support fr perl.
 *
 * Revision 1.1.1.1  1993/12/31  20:56:38  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: fonts.c,v 1.3 1994/07/09 16:43:40 rj Exp $";

#include "psfilt.h"
#if 0
  #include "afm.h"	/* for afmdirs	*/
#endif
#include "fonts.h"
#include "cache.h"
#include "mem.h"
#include "str.h"
#include "verbose.h"
#include "error.h"

/*\[sep]--------------------------------------------------------------------------------------------------------------------------*/
t_list	*fontdirs;

/*\[sep]--------------------------------------------------------------------------------------------------------------------------*/
int fontpcmp (const t_font *l, const t_font *r)
{
assert (l->fontname);
assert (r->fontname);
  return strcmp (l->fontname, r->fontname);
}

int fontppcmp (const t_font **l, const t_font **r)
{
  return strcmp ((*l)->fontname, (*r)->fontname);
}

void freefont (t_font *font)
{
  /* font->fontname points into one of font->afms fontnames */
  font->afms = avldestroy (font->afms);
  font->fonts = avldestroy (font->fonts);
}

/*\[sep]--------------------------------------------------------------------------------------------------------------------------*/
void clearfontfile (t_fontfile *fontfile)
{
  clearfileinfo (&fontfile->file);
  fontfile->fontname = NULL;
  fontfile->version = VERSION_unknown;
}

int fontfilepcmpfilename (const t_fontfile *l, const t_fontfile *r)
{
  return fileinfopcmpfilename (&l->file, &r->file);
}

int fontfilepcmpversion (const t_fontfile *l, const t_fontfile *r)
{
  return versioncmp (l->version, r->version);
}

int fontfilepcmp (const t_fontfile *l, const t_fontfile *r)
{
  int rc;

  if (rc = str0cmp (l->fontname, r->fontname))
    return rc;
  if (rc = versioncmp (l->version, r->version))
    return rc;
  if (rc = fileinfopcmpfilename (&l->file, &r->file))
    return rc;
  ierror ("fontfilecmp");
  abort();/* standard C doesn't recognize volatile for non-returning functions. but gcc knows that abort() and exit() don't return... */
}

int printfontfile (const t_fontfile *fontfile, bool verbose)
{
  t_buf	fontversion;

  fprintf (stderr, "FontName: %s ", fontfile->fontname);
  fprintf (stderr, "Version: %s\n", strversion (fontversion, fontfile->version));
  return feof (stderr) ? fault : ok;
}

void freefontfile (t_fontfile *fontfile)
{
  freefileinfo (&fontfile->file);
}

/*\[sep]--------------------------------------------------------------------------------------------------------------------------*/
#if 0 /* unused function: */
bool isfontavailable (cstring fontname)
{
  FILE	*fp;

  if (!(fp = fopenafm (fontname)))
    return false;
  fclose (fp);	/* perhaps it isn't even needed... */
  if (!(fp = fopenfont (fontname)))
    return false;
  fclose (fp);	/* ditto... */
  return true;
}
#endif

/*\[sep]-------------------------------------------------------------------------------------------------------------------------*/ 
#if 0
static int _fontabbrevs (cstring *dir, va_list va)
{
  cstring	fontname = va_arg (va, cstring);
  t_list	*abbrevs = va_arg (va, t_list *);
  t_fnbuf	mapfn;
  FILE		*map;

  if ((map = fopen (strcat (strcpy (mapfn, *dir), "/map"), "r")) || (map = fopen (strcat (strcpy (mapfn, *dir), "/font.map"), "r")))
  {
    char	line[MAX (MAXPATHLEN, BUFLEN)];
    cstring	longname, abbrev;

    while (fgets (line, sizeof line, map))
      if ((longname = strtok (line, " \t=")) && (abbrev = strtok (NULL, " \t\n")))
	if (streq (longname, fontname))
	{
	  liappend (abbrevs, abbrev, strlen (abbrev)+1);
	  say (IMP_entertain, "%s: font \"%s\" mapped to \"%s\"\n", mapfn, longname, abbrev);
	}
    fclose (map);
  }
  return ok;
}

static t_list *fontabbrevs (cstring fontname, ...)
{
  va_list	va;
  t_list	*dirs;
  t_list	*abbrevs = licreate (0, NULL, NULL);

  va_start (va, fontname);
  while (dirs=va_arg (va, t_list *))
    livamap (dirs, _fontabbrevs, fontname, abbrevs);
  va_end (va);
  return abbrevs;
}
#endif

/*\[sep]-------------------------------------------------------------------------------------------------------------------------*/ 
#if 0
enum
{
  void_MATCH,
  no_MATCH,
  dumb_MATCH,
  easy_MATCH,
  perfect_MATCH,
};

static int afmmatchvalue (t_fontversion fontversion, t_fontversion afmversion)
{
  if (fontversion == FONTVERSION_unknown)
    return easy_MATCH;	/* couldn't find out font's version */
  if (afmversion == FONTVERSION_unknown)
    return dumb_MATCH;	/* couldn't find out afm's version */
  if (fontversion == afmversion)
    return perfect_MATCH;
  return no_MATCH;
}

static int findafm (t_AFM *afm, va_list va)
{
  t_fontversion	fontversion;
  int		*matchvalue, newvalue;

  fontversion = va_arg (va, t_fontversion);
  matchvalue = va_arg (va, int *);

  if ((newvalue = afmmatchvalue (fontversion, afm->Version)) > *matchvalue)
  {
    t_AFM **afmp = va_arg (va, t_AFM **);

    *matchvalue = newvalue;
    *afmp = afm;
  }
  return ok;
}

const t_AFM *getafmforfont (cstring fontname, t_fontversion fontversion)
{
  t_fontfamily	ffsearch, *fontfamily;
  int		matchvalue;
  t_AFM		*afmp;

  if (!(ffsearch.familyname = getfamilyforfont (fontname)))
    return NULL;
  fontfamily = avlsearch (fontfamilies, &ffsearch);
  assert (fontfamily);
  matchvalue = void_MATCH;
  afmp = NULL;
  livamap (fontfamily->afms, findafm, fontversion, &matchvalue, &afmp);
  fprintf (stderr, "getafmforfont: matchvalue=%d\n", matchvalue);
  if (afmp && !afmp->complete)
    if (completeafm (afmp))
      return NULL;
  return afmp;
}
#endif
