/*
 * program: psfilt
 * file: files.h
 *
 * Copyright  1992 1993 Robert Joop
 *
 * functions to handle files
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: files.h,v 1.2 1994/07/09 16:43:39 rj Exp $
 * $Log: files.h,v $
 * Revision 1.2  1994/07/09  16:43:39  rj
 * a lot of const's removed and added
 *
 * Revision 1.1.1.1  1993/12/31  20:56:47  rj
 * erster cvs import.
 *
 */

#ifndef FILES_H
#define FILES_H

#include "dirs.h"

typedef struct
{
  string	suffix;
  string	filter;
} t_filter;

typedef struct
{
  string	suffix;
  string	read, write;	/* must both be ==NULL or both be !=NULL */
} t_stdfilter;

#if 0
typedef enum
{
  AFM_unavailable,	/* doesn't exist (information from cache has been falsified) */
  AFM_incache,		/* may exist or not (unchecked information from cache) */
  AFM_checked,		/* does exist (information from cache has been verified) */
  AFM_complete,		/* does exist and has been read in full length */
} t_afmstate;
#endif

#define O_rd		0x01
#define O_wr		0x02
#define O_rdonly	O_rd		/* read only */
#define O_rw		0x04
#define O_rw_rd		(O_rw|O_rd)	/* read now, possibly write later */
#define O_rw_wr		(O_rw|O_wr)	/* write now */
#define O_lock		0x08		/* file locking */

/* status of in-core information: */
typedef enum
{
  FS_fromcache,		/* may be valid or not (unchecked information) */
  FS_void,		/* invalid information (e.g. from cache) */
  FS_valid,		/* checked information */
  FS_incore,		/* does exist and is internalized */
} t_filestat;

#define FI_pipe		0x01	/* opened thru popen() */
#define FI_rwreq	0x02	/* rd/wr requested */
#define FI_nowr		0x04	/* cannot be written */
#define FI_lock		0x08	/* lock file */

/* information about the file: */
typedef struct
{
  string		fullname;
  int			flags;
  t_filestat		stat;
  time_t		mtime;
  bool			dynfilt;	/* have the two following members been dynamically allocated? */
  t_filter		*clientfilter;	/* e.g. pfbtops */
  t_stdfilter		*stdfilter;	/* e.g. compression */

  FILE			*fp;		/* for i/o */
  int			fd;		/* for locking purposes */
} t_fileinfo;

extern t_filter		nofilter[];

extern void		clearfileinfo (t_fileinfo *fileinfo);
extern int		fileinfopcmp (const t_fileinfo *l, const t_fileinfo *r);
extern int		fileinfopcmpfilename (const t_fileinfo *l, const t_fileinfo *r);
extern t_fileinfo	makefileinfo (string filename, time_t mtime, t_filestat, string clientfilter, string stdrdfilter, string stdwrfilter);
extern int		matchfileinfo (string dir, string fnbase, const t_filter *clientfilters, char *fullnamebuf, t_fileinfo *fileinfo);
extern void		savefileinfo (t_fileinfo *fileinfo);
extern int		freefileinfo (t_fileinfo *fileinfo);
extern string		fi_filename (char *buf, const t_fileinfo *fileinfo);

extern FILE		*pfopen (string dir, string fnstub, const t_filter *clientfilters, int omode, char *fullnamebuf, t_fileinfo *fileinfo);
extern bool		pfisreadonly (const t_fileinfo *fileinfo);
extern FILE		*pfreopen (t_fileinfo *fileinfo, int omode);
extern int		pfclose (t_fileinfo *fileinfo);

extern FILE		*pfopenpath (t_list *dirs, string fnbase, const t_filter *filters, int omode, string fn, t_fileinfo *fileinfo);

extern int		findnamedfiles (t_list *dirs, t_list *names, const t_filter *filters, int omode, string fn, int (*before)(string dir, va_list), int (*every)(FILE *, t_fileinfo *fileinfo, va_list), int (*after)(string dir, va_list), ...);
extern int		findfiles (t_list *dirs, const t_filter *filters, int omode, string fn, int (*before)(string dir, va_list), int (*every)(FILE *, t_fileinfo *fileinfo, va_list), int (*after)(string dir, va_list), ...);

#endif FILES_H
