/*
 * program: psfilt
 * file: error.c
 *
 * Copyright  1992 1993 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: error.c,v $
 * Revision 1.2  1994/07/09  15:34:10  rj
 * stuff for configuration via GNU autoconf added
 *
 * Revision 1.1.1.1  1993/12/31  20:56:46  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: error.c,v 1.2 1994/07/09 15:34:10 rj Exp $";

#include "psfilt.h"
#include "verbose.h"
#include "error.h"

volatile void error (cstring fmt, ...)
{
  va_list	va;

  va_start (va, fmt);
  vsay (IMP_error, fmt, va);
  va_end (va);
  say (IMP_error, "\n");
  exit (5);
}

volatile void ierror (cstring fmt, ...)
{
  va_list	va;

  say (IMP_error, "internal error: ");
  va_start (va, fmt);
  vsay (IMP_error, fmt, va);
  va_end (va);
  say (IMP_error, "\n");
abort();
  exit (7);
}

#ifdef DEBUG
void prompt (cstring fmt, ...)
{
  va_list	va;
  t_buf		buf;

  va_start (va, fmt);
  vprintf (fmt, va);
  va_end (va);
  gets (buf);
}
#endif
