/*
 * program: psfilt
 * file: dirs.c
 *
 * Copyright  1992 1993 Robert Joop
 *
 * functions to handle directory lists as known from $PATH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: dirs.c,v $
 * Revision 1.2  1994/07/09  16:43:35  rj
 * a lot of const's removed and added
 *
 * Revision 1.1.1.1  1993/12/31  20:56:41  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: dirs.c,v 1.2 1994/07/09 16:43:35 rj Exp $";

#include "psfilt.h"
#include "dirs.h"
#include "verbose.h"

static int testdup (string *old, string new)
{
  return streq (*old, new);
}

t_list *appenddir (t_list *dirs, string dir)
{
  if (!dirs)
    dirs = licreate (sizeof (string), NULL, NULL);
  if (liamap (dirs, testdup, dir))
    say (IMP_warning, "directory %s appearing more than once. ignored.\n", dir);
  else
    liappend (dirs, &dir);
  return dirs;
}

t_list *appendpath (t_list *dirs, string path)
{
  int	i;

  if (path)
  {
    for (; (i = chrind (path, ':')) != fault; path += i + 1)
      dirs = appenddir (dirs, i ? strnsave (path, i) : ".");
    dirs = appenddir (dirs, *path ? path : ".");
  }
  elif (!dirs)
    dirs = licreate (sizeof (string), NULL, NULL);
  return dirs;
}

#ifdef DEBUG
int printdir (string *dir)
{
  assert (*dir);
  say (IMP_entertain2, "dir \"%s\"\n", *dir);
  return ok;
}
#endif
