/*
 * program: psfilt
 * file: cp437.c
 *
 * Copyright  1992 1993 Robert Joop
 *
 *	convert codepage 437 (a.k.a. "IBM ASCII") into UCS2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: cp437.c,v $
 * Revision 1.1.1.1  1993/12/31  20:56:45  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: cp437.c,v 1.1.1.1 1993/12/31 20:56:45 rj Exp $";

#include "psfilt.h"
#include "ucs2list.h"
#include "cp437.h"

/* ATTENTION: codes 0 - 127 are omitted! (they identical to ISO 646 IRV, so see iso646.c) */
static t_ucs2 CP437_to_UCS2_table[] =
{
  UCS2_VOID,	/* ISO646_NUL	*/
  UCS2_white_smiling_face,	/* ISO646_SOH	*/
  UCS2_black_smiling_face,	/* ISO646_STX	*/
  UCS2_VOID,	/* ISO646_ETX	*/
  UCS2_VOID,	/* ISO646_EOT	*/
  UCS2_VOID,	/* ISO646_ENQ	*/
  UCS2_VOID,	/* ISO646_ACK	*/
  UCS2_VOID,	/* ISO646_BEL	*/

  UCS2_VOID,	/* ISO646_BS	*/
  UCS2_VOID,	/* ISO646_HT	*/
  UCS2_VOID,	/* ISO646_LF	*/
  UCS2_male_sign,	/* ISO646_VT	*/
  UCS2_female_sign,	/* ISO646_FF	*/
  UCS2_VOID,	/* ISO646_CR	*/
  UCS2_VOID,	/* ISO646_SO	*/
  UCS2_white_sun_with_rays,		/* ISO646_SI	*/

  UCS2_VOID,	/* ISO646_DLE	*/
  UCS2_VOID,	/* ISO646_DC1	*/
  UCS2_up_down_arrow,			/* ISO646_DC2	*/
  UCS2_double_exclamation_mark,		/* ISO646_DC3	*/
  UCS2_paragraph_sign,			/* ISO646_DC4	*/
  UCS2_section_sign,			/* ISO646_NAK	*/
  UCS2_VOID,	/* ISO646_SYN	*/
  UCS2_up_down_arrow,	/* ISO646_ETB	*/

  UCS2_VOID,	/* ISO646_CAN	*/
  UCS2_VOID,	/* ISO646_EM	*/
  UCS2_VOID,	/* ISO646_SUB	*/
  UCS2_VOID,	/* ISO646_ESC	*/
  UCS2_VOID,	/* ISO646_FS	*/
  UCS2_VOID,	/* ISO646_GS	*/
  UCS2_black_up_pointing_triangle,	/* ISO646_RS	*/
  UCS2_black_down_pointing_triangle,	/* ISO646_US	*/

  UCS2_space,
  UCS2_exclamation_mark,
  UCS2_quotation_mark,
  UCS2_number_sign,
  UCS2_dollar_sign,
  UCS2_percent_sign,
  UCS2_ampersand,
  UCS2_apostrophe_quote,
  UCS2_opening_parenthesis,
  UCS2_closing_parenthesis,
  UCS2_asterisk,
  UCS2_plus_sign,
  UCS2_comma,
  UCS2_hyphen_minus,
  UCS2_period,
  UCS2_slash,

  UCS2_digit_zero,
  UCS2_digit_one,
  UCS2_digit_two,
  UCS2_digit_three,
  UCS2_digit_four,
  UCS2_digit_five,
  UCS2_digit_six,
  UCS2_digit_seven,
  UCS2_digit_eight,
  UCS2_digit_nine,
  UCS2_colon,
  UCS2_semicolon,
  UCS2_less_than_sign,
  UCS2_equals_sign,
  UCS2_greater_than_sign,
  UCS2_question_mark,

  UCS2_commercial_at,
  UCS2_latin_capital_letter_a,
  UCS2_latin_capital_letter_b,
  UCS2_latin_capital_letter_c,
  UCS2_latin_capital_letter_d,
  UCS2_latin_capital_letter_e,
  UCS2_latin_capital_letter_f,
  UCS2_latin_capital_letter_g,
  UCS2_latin_capital_letter_h,
  UCS2_latin_capital_letter_i,
  UCS2_latin_capital_letter_j,
  UCS2_latin_capital_letter_k,
  UCS2_latin_capital_letter_l,
  UCS2_latin_capital_letter_m,
  UCS2_latin_capital_letter_n,
  UCS2_latin_capital_letter_o,

  UCS2_latin_capital_letter_p,
  UCS2_latin_capital_letter_q,
  UCS2_latin_capital_letter_r,
  UCS2_latin_capital_letter_s,
  UCS2_latin_capital_letter_t,
  UCS2_latin_capital_letter_u,
  UCS2_latin_capital_letter_v,
  UCS2_latin_capital_letter_w,
  UCS2_latin_capital_letter_x,
  UCS2_latin_capital_letter_y,
  UCS2_latin_capital_letter_z,
  UCS2_opening_square_bracket,
  UCS2_backslash,
  UCS2_closing_square_bracket,
  UCS2_spacing_circumflex,
  UCS2_spacing_underscore,

  UCS2_spacing_grave,
  UCS2_latin_small_letter_a,
  UCS2_latin_small_letter_b,
  UCS2_latin_small_letter_c,
  UCS2_latin_small_letter_d,
  UCS2_latin_small_letter_e,
  UCS2_latin_small_letter_f,
  UCS2_latin_small_letter_g,
  UCS2_latin_small_letter_h,
  UCS2_latin_small_letter_i,
  UCS2_latin_small_letter_j,
  UCS2_latin_small_letter_k,
  UCS2_latin_small_letter_l,
  UCS2_latin_small_letter_m,
  UCS2_latin_small_letter_n,
  UCS2_latin_small_letter_o,

  UCS2_latin_small_letter_p,
  UCS2_latin_small_letter_q,
  UCS2_latin_small_letter_r,
  UCS2_latin_small_letter_s,
  UCS2_latin_small_letter_t,
  UCS2_latin_small_letter_u,
  UCS2_latin_small_letter_v,
  UCS2_latin_small_letter_w,
  UCS2_latin_small_letter_x,
  UCS2_latin_small_letter_y,
  UCS2_latin_small_letter_z,
  UCS2_opening_curly_bracket,
  UCS2_vertical_bar,
  UCS2_closing_curly_bracket,
  UCS2_tilde,
  UCS2_VOID,		/* ISO646_DEL */

  UCS2_latin_capital_letter_c_cedilla,
  UCS2_latin_small_letter_u_diaeresis,
  UCS2_latin_small_letter_e_acute,
  UCS2_latin_small_letter_a_circumflex,
  UCS2_latin_small_letter_a_diaeresis,
  UCS2_latin_small_letter_a_grave,
  UCS2_latin_small_letter_a_ring,
  UCS2_latin_small_letter_c_cedilla,

  UCS2_latin_small_letter_e_circumflex,
  UCS2_latin_small_letter_e_diaeresis,
  UCS2_latin_small_letter_e_grave,
  UCS2_latin_small_letter_i_diaeresis,
  UCS2_latin_small_letter_i_circumflex,
  UCS2_latin_small_letter_i_grave,
  UCS2_latin_capital_letter_a_diaeresis,
  UCS2_latin_capital_letter_a_ring,

  UCS2_latin_capital_letter_e_acute,
  UCS2_latin_small_letter_a_e,
  UCS2_latin_capital_letter_a_e,
  UCS2_latin_small_letter_o_circumflex,
  UCS2_latin_small_letter_o_diaeresis,
  UCS2_latin_small_letter_o_grave,
  UCS2_latin_small_letter_u_circumflex,
  UCS2_latin_small_letter_u_grave,

  UCS2_latin_small_letter_y_diaeresis,
  UCS2_latin_capital_letter_o_diaeresis,
  UCS2_latin_capital_letter_u_diaeresis,
  UCS2_cent_sign,
  UCS2_pound_sign,
  UCS2_yen_sign,
  UCS2_peseta_sign,
  UCS2_latin_small_letter_script_f,

  UCS2_latin_small_letter_a_acute,
  UCS2_latin_small_letter_i_acute,
  UCS2_latin_small_letter_o_acute,
  UCS2_latin_small_letter_u_acute,
  UCS2_latin_small_letter_n_tilde,
  UCS2_latin_capital_letter_n_tilde,
  UCS2_feminine_ordinal_indicator,
  UCS2_masculine_ordinal_indicator,

  UCS2_inverted_question_mark,
  UCS2_reversed_not_sign,
  UCS2_not_sign,
  UCS2_fraction_one_half,
  UCS2_fraction_one_quarter,
  UCS2_inverted_exclamation_mark,
  UCS2_left_pointing_guillemet,
  UCS2_right_pointing_guillemet,

  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,

  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,

  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,

  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,

  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,

  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,
  UCS2_VOID,

  UCS2_greek_small_letter_alpha,
  UCS2_greek_small_letter_beta,
  UCS2_greek_capital_letter_gamma,
  UCS2_greek_small_letter_pi,
  UCS2_greek_capital_letter_sigma,
  UCS2_greek_small_letter_sigma,
  UCS2_greek_small_letter_mu,
  UCS2_greek_small_letter_tau,

  UCS2_greek_small_letter_phi,
  UCS2_greek_small_letter_theta,
  UCS2_greek_capital_letter_omega,
  UCS2_greek_small_letter_delta,
  UCS2_infinity,
  UCS2_empty_set,
  UCS2_element_of,
  UCS2_intersection,

  UCS2_equivalent_to,
  UCS2_plus_or_minus_sign,
  UCS2_greater_than_or_equal_to,
  UCS2_less_than_or_equal_to,
  UCS2_top_half_integral,
  UCS2_bottom_half_integral,
  UCS2_division_sign,
  UCS2_approximately_equal_to,

  UCS2_degree_sign,
  UCS2_bullet,
  UCS2_middle_dot,
  UCS2_square_root,
  UCS2_superscript_latin_small_letter_n,
  UCS2_superscript_digit_two,
  UCS2_VOID,				/* @@@ */
  UCS2_space,
};

t_ucs2 CP437toUCS2 (uchar c)
{
  return CP437_to_UCS2_table[c];
}
