/*
 * program: psfilt
 * file: cache.h
 *
 * Copyright  1992 1993 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: cache.h,v 1.2 1994/07/09 16:43:30 rj Exp $
 * $Log: cache.h,v $
 * Revision 1.2  1994/07/09  16:43:30  rj
 * a lot of const's removed and added
 *
 * Revision 1.1.1.1  1993/12/31  20:56:47  rj
 * erster cvs import.
 *
 */

#ifndef CACHE_H
#define CACHE_H

typedef struct
{
  int		flags;
  string	filename;
} t_cachespec;

typedef struct
{
  bool		flags;
  bool		filename;
} t_cachespecbools;

#define CACHE_use		0x01
#define CACHE_checkdir		0x02
#define CACHE_checkfiles	0x04
#define CACHE_check		(CACHE_checkdir|CACHE_checkfiles)
#define CACHE_update		0x08
#define CACHE_global		0x10

#define CACHE_rebuild(flags)	(!((flags)&CACHE_check) && (flags)&CACHE_update)

#if 0 /* shall be static: */
extern t_avl		*fonts,
			*fontfamilies;
#endif
extern int		init_fonts (t_cachespec *);

#if 0 /* unused function: */
extern bool		isfontavailable (cstring fontname);
#endif

extern t_font		*getfontbyname (cstring fontname);
#if 0
extern int		findfontfiles (t_font *);
extern const t_AFM	*getafmforfont (cstring fontname, t_version);
#endif
extern t_cnames		*getfontsfromfamily (string fontfamily, const t_fontrendition *);
extern t_cnames		*getfontsfromfamily2 (string fontfamily, t_fontweight, bool italic);

#endif CACHE_H
