/*
 * library: avl-tree
 * file: avlvarmap.c
 *
 * Copyright  1990, 1991, 1992, 1993 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: avlvarmap.c,v $
 * Revision 1.1.1.1  1993/12/31  20:28:47  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: avlvarmap.c,v 1.1.1.1 1993/12/31 20:28:47 rj Exp $";

#ifdef __STDC__
#  include <stdarg.h>
#else
#  include <varargs.h>
#endif

#define avl_internal
#include "avl.h"

#ifdef __STDC__
int avlvarmap (t_avl *avl, int (*f)(), ...)
#else
int avlvarmap (avl, f, va_alist)
  t_avl	*avl;
  int	(*f)();
  va_dcl
#endif
{
  va_list	va;
  t_avlnode	*node, *pred;
  int		rc = ok;

  if (!avl)
    return fault;
#ifdef __STDC__
  va_start (va, f);
#else !__STDC__
  va_start (va);
#endif __STDC__
  if (avl->fixsize)
    for (node=avl->last; node; node=pred)	/* mal nicht rekursiv, um den stack zu schonen	*/
    {
      pred = node->pred;
      if (rc = (*f)(node->elem.fix, va))
	break;
    }
  else
    for (node=avl->last; node; node=pred)	/* mal nicht rekursiv, um den stack zu schonen	*/
    {
      pred = node->pred;
      if (rc = (*f)(node->elem.var.buf, node->elem.var.size, va))
      break;
  }
  va_end (va);
  return rc;
}
