/*
 * library: avl-tree
 * file: avlresort.c
 *
 * Copyright  1990, 1991, 1992, 1993, 1994 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: avlresort.c,v $
 * Revision 1.3  1994/07/09  16:47:10  rj
 * superfluous alloca-section removed.
 *
 * Revision 1.2  1994/07/09  15:34:36  rj
 * stuff for configuration via GNU autoconf added
 *
 * Revision 1.1.1.1  1993/12/31  20:28:47  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: avlresort.c,v 1.3 1994/07/09 16:47:10 rj Exp $";

#define avl_internal
#include "avl.h"

#ifdef __STDC__
static int avlresort_fix (void *buf, t_avl *new)
#else
static int avlresort_fix (buf, new)
  char	*buf;
  t_avl	*new;
#endif
{
  return avlinsert (new, buf) ? ok : fault;
}

#ifdef __STDC__
static int avlresort_var (void *buf, size_t size, t_avl *new)
#else
static int avlresort_var (buf, size, new)
  char	*buf;
  long	size;
  t_avl	*new;
#endif
{
  return avlinsert (new, buf, size) ? ok : fault;
}

#ifdef __STDC__
t_avl *avlresort (t_avl *avl, int (*cmpfunc)())
#else
t_avl *avlresort (avl, cmpfunc)
  t_avl		*avl;
  int		(*cmpfunc)();
#endif
{
  t_avl		*new;

  if (!avl || !cmpfunc)
    return NULL;
  if (avl->cmpfunc == cmpfunc)
    return avl;

  if (!(new = avlcreate (avl->fixsize, cmpfunc, avl->freefunc)))
    return NULL;
  if (avlamap (avl, avl->fixsize ? (int (*)())avlresort_fix : (int (*)())avlresort_var, new))
  {
    new->freefunc = NULL;
    avldestroy (new);
    return NULL;
  }
  else
  {
    avl->freefunc = NULL;
    avldestroy (avl);
    return new;
  }
}
