/*
 * library: avl-tree
 * file: avlinsrch.c
 *
 * Copyright  1990, 1991, 1992, 1993, 1994 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: avlinsrch.c,v $
 * Revision 1.1.1.1  1993/12/31  20:28:46  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: avlinsrch.c,v 1.1.1.1 1993/12/31 20:28:46 rj Exp $";

#define avl_internal
#include "avl.h"
#ifdef __STDC__
#  include <stdarg.h>
#endif
#include "uti.h" /* malloc0() */

/* - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - */ 

#ifdef __STDC__
static void *makeavlnode (t_avlnode **tree, t_avlnode **pred, t_avlnode **succ, const void *elem, size_t fixsize, size_t varsize)
#else
static char *makeavlnode (tree, pred, succ, elem, fixsize, varsize)
  t_avlnode	**tree, **pred, **succ;
  char		*elem;
  long		fixsize, varsize;
#endif
{
#ifdef __STDC__
  size_t	size;
  void		*new;
#else
  long		size;
  char		*new;
#endif

#ifdef __STDC__
  size = sizeof (t_avlnode) + (fixsize ? fixsize-sizeof (size_t) : varsize);
#else
  size = sizeof (t_avlnode) + (fixsize ? fixsize-sizeof (long) : varsize);
#endif
  if (*tree)	/* change size */
  {
    if (fixsize)
      return (*tree)->elem.fix;
    if (!varsize || (*tree)->elem.var.size == varsize)
      return (*tree)->elem.var.buf;
    if (!(*tree = (t_avlnode *)realloc (*tree, size)))
      return NULL;
    new = (*tree)->elem.var.buf;
  }
  else
  {
    if (!(*tree = (t_avlnode *)malloc0 (size)))
      return NULL;
    if (fixsize)
      new = memcpy ((*tree)->elem.fix, elem, fixsize);
    else
      new = memcpy ((*tree)->elem.var.buf, elem, (*tree)->elem.var.size = varsize);
    (*tree)->succ = *pred;
    (*tree)->pred = *succ;
  }

  *pred = *succ = *tree;

  return new;
}

/* - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - */ 

#ifdef __STDC__
static void *_avlinsrch (t_avlnode **tree, t_avlnode **pred, t_avlnode **succ, bool *insert, size_t fixsize, int (*cmpf)(const void *, const void *), const void *elem, size_t varsize)
#else
/* VARARGS 5 */
static char *_avlinsrch (tree, pred, succ, insert, fixsize, cmpf, elem, varsize)
  t_avlnode	**tree, **pred, **succ;
  bool		*insert;
  long		fixsize, varsize;
  int		(*cmpf)();
  char		*elem;
#endif
{
#ifdef __STDC__
  void		*new;
#else
  char		*new;
#endif
  int		side, lh, rh;

  if (*tree)
  {
    if (side = (*cmpf)(elem, fixsize ? (*tree)->elem.fix : (*tree)->elem.var.buf))
    {
      side = side < 0 ? 0 : 1;
      if (!(new = _avlinsrch ((*tree)->n.a+side, side ? &(*tree)->succ : pred, side ? succ : &(*tree)->pred, insert, fixsize, cmpf, elem, varsize)))
	return NULL;
      if (*insert)
      {
	lh = HEIGHT ((*tree)->n.p.left);
	rh = HEIGHT ((*tree)->n.p.right);
	(*tree)->height = MAX (lh, rh) + 1;
	if (abs (lh - rh) >= 2)
	  avlbalance (tree);
      }
      return new;
    }
    else	/* element already exists	*/
    {
      *insert = false;
      return makeavlnode (tree, pred, succ, elem, fixsize, varsize);
    }
  }
  else	/* element doesn't exist	*/
    if (*insert)
      return makeavlnode (tree, pred, succ, elem, fixsize, varsize);
    else
    {
      errno = ESRCH;
      return NULL;
    }
}

/* - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - */ 

#ifdef __STDC__
void *avlinsrch (t_avl *avl, bool *insert, const void *elem, ...)
#else !__STDC__
/* VARARGS 3 */
char *avlinsrch (avl, insert, elem, varsize)
  t_avl		*avl;
  bool		*insert;
  char		*elem;
  long		varsize;
#endif __STDC__
{
#ifdef __STDC__
  va_list	va;
  size_t	varsize;

  va_start (va, elem);
  varsize = va_arg (va, size_t);
  va_end (va);
#endif __STDC__
  return _avlinsrch (&avl->root, &avl->first, &avl->last, insert, avl->fixsize, avl->cmpfunc, elem, varsize);
}

#ifdef __STDC__
void *avlinsert (t_avl *avl, const void *elem, ...)
#else !__STDC__
/* VARARGS 2 */
char *avlinsert (avl, elem, varsize)
  t_avl		*avl;
  char		*elem;
  long		varsize;
#endif __STDC__
{
  bool		insert = true;
#ifdef __STDC__
  void		*new;
  va_list	va;
  long		varsize;

  va_start (va, elem);
  varsize = va_arg (va, size_t);
  va_end (va);
#else !__STDC__
#endif __STDC__
  if (!(new = _avlinsrch (&avl->root, &avl->first, &avl->last, &insert, avl->fixsize, avl->cmpfunc, elem, varsize)))
    return NULL;
  if (insert)
    return new;
  else
  {
    errno = EEXIST;
    return NULL;
  }
}

#ifdef __STDC__
void *avlsearch (t_avl *avl, const void *elem)
#else
char *avlsearch (avl, elem)
  t_avl		*avl;
  char		*elem;
#endif
{
  bool		insert = false;

  return _avlinsrch (&avl->root, NULL, NULL, &insert, avl->fixsize, avl->cmpfunc, elem, 0);
}

#ifdef __STDC__
void *avlresize (t_avl *avl, const void *elem, size_t varsize)
#else
char *avlresize (avl, elem, varsize)
  t_avl		*avl;
  char		*elem;
  long		varsize;
#endif
{
  bool		insert = false;

  return _avlinsrch (&avl->root, &avl->first, &avl->last, &insert, avl->fixsize, avl->cmpfunc, elem, varsize);
}
