/*
 * library: avl-tree
 * file: avlrot.c
 *
 * Copyright  1990, 1991, 1992, 1993, 1994 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: avlbalance.c,v $
 * Revision 1.1.1.1  1993/12/31  20:28:46  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: avlbalance.c,v 1.1.1.1 1993/12/31 20:28:46 rj Exp $";

#define avl_internal
#include "avl.h"

/* - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - */ 

#ifdef __STDC__
static t_avlnode *srot (t_avlnode *n1, t_avlnode *n2, int side)
#else !__STDC__
static t_avlnode *srot (n1, n2, side)
  t_avlnode	*n1, *n2;
  int		side;
#endif __STDC__
{
  n1->n.a[side == 0 ? 1 : 0] = n2->n.a[side];
  n2->n.a[side] = n1;

  n1->height = MAX (HEIGHT (n1->n.p.left), HEIGHT (n1->n.p.right)) + 1;
  n2->height = MAX (HEIGHT (n2->n.p.left), HEIGHT (n2->n.p.right)) + 1;

  return n2;
}

/* - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - */ 

#ifdef __STDC__
static t_avlnode *drot (t_avlnode *n1, t_avlnode *n2, t_avlnode *n3, int side)
#else !__STDC__
static t_avlnode *drot (n1, n2, n3, side)
  t_avlnode	*n1, *n2, *n3;
  int		side;
#endif __STDC__
{
  int	oppside;

  n1->n.a[oppside = (side == 0 ? 1 : 0)] = n3->n.a[side];
  n2->n.a[side] = n3->n.a[oppside];
  n3->n.a[side] = n1;
  n3->n.a[oppside] = n2;

  n1->height = MAX (HEIGHT (n1->n.p.left), HEIGHT (n1->n.p.right)) + 1;
  n2->height = MAX (HEIGHT (n2->n.p.left), HEIGHT (n2->n.p.right)) + 1;
  n3->height = MAX (HEIGHT (n3->n.p.left), HEIGHT (n3->n.p.right)) + 1;

  return n3;
}

/* - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - */ 

extern void avlbalance (tree)
  t_avlnode	**tree;
{
  int	side, oppside;

  oppside = 1 - (side = HEIGHT ((*tree)->n.p.left) < HEIGHT ((*tree)->n.p.right) ? 0 : 1);

  if (HEIGHT ((*tree)->n.a[oppside]->n.a[oppside]) > HEIGHT ((*tree)->n.a[oppside]->n.a[side]))
    *tree = srot (*tree, (*tree)->n.a[oppside], side);
  else
    *tree = drot (*tree, (*tree)->n.a[oppside], (*tree)->n.a[oppside]->n.a[side], side);
}
