/*
 * library: avl-tree
 * file: avlamap.c
 *
 * Copyright  1990, 1991, 1992, 1993 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: avlamap.c,v $
 * Revision 1.1.1.1  1993/12/31  20:28:47  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: avlamap.c,v 1.1.1.1 1993/12/31 20:28:47 rj Exp $";

#define avl_internal
#include "avl.h"

#ifdef __STDC__
int avlamap (t_avl *avl, int (*f)(), void *a)
#else
int avlamap (avl, f, a)
  t_avl	*avl;
  int	(*f)();
  char	*a;
#endif
{
  t_avlnode	*node, *succ;
  int		rc = ok;

  if (!avl)
    return fault;
  if (avl->fixsize)
    for (node=avl->first; node; node=succ)	/* mal nicht rekursiv, um den stack zu schonen	*/
    {
      succ = node->succ;
      if (rc = (*f)(node->elem.fix, a))
	break;
    }
  else
    for (node=avl->first; node; node=succ)	/* mal nicht rekursiv, um den stack zu schonen	*/
    {
      succ = node->succ;
      if (rc = (*f)(node->elem.var.buf, node->elem.var.size, a))
	break;
  }
  return rc;
}
