/*
 * library: avl-tree
 * file: avl.h
 *
 * Copyright  1990, 1991, 1992, 1993, 1994 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: avl.h,v 1.1.1.1 1993/12/31 20:28:46 rj Exp $
 * $Log: avl.h,v $
 * Revision 1.1.1.1  1993/12/31  20:28:46  rj
 * erster cvs import.
 *
 */

#ifndef AVL_H
#define AVL_H

#include "gdefs.h"

/* - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - */ 

#define AVL_PREORDER	0x01
#define AVL_INORDER	0x02
#define AVL_POSTORDER	0x04
#define AVL_REVERSE	0x08

#ifdef avl_internal

#  include <errno.h>

  typedef struct t_avlnode
  {
    int		height;
    union
    {
      struct t_avlnode		*a[2];
      struct
      {
	struct t_avlnode	*left,
				*right;
      } p;
    } n;
    struct t_avlnode	*pred,
			*succ;
    union
    {
      struct
      {
#  ifdef __STDC__
	size_t	size;
#  else
	long	size;
#  endif
	double	dummy[0];	/* enforce double-alignment */
	char	buf[0];
      } var;
      double	dummy[0];	/* enforce double-alignment */
      char	fix[0];
    } elem;
  } t_avlnode;

  typedef struct
  {
#  ifdef __STDC__
    size_t	fixsize;
    int		(*cmpfunc)(const void *, const void *);
    void	(*freefunc)(const void *);
#  else
    long	fixsize;
    int		(*cmpfunc)();
    void	(*freefunc)();
#  endif
    t_avlnode	*root,
		*first,
		*last;
  } t_avl;

#  ifdef __STDC__
    extern void	avlbalance (t_avlnode **tree);
#  else !__STDC__
    extern void	avlbalance();
#  endif __STDC__

#  define HEIGHT(t)	((t)==NULL ? -1 : (t)->height)

#else !avl_internal

  typedef struct t_avl	t_avl;		/* opaque type	*/

#endif avl_internal

/* - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - */ 

#ifdef __STDC__

  extern t_avl	*avlcreate (size_t elemsize, int (*cmpfunc)(/* const void *, const void * */), void (*freefunc)(/* const void * */)),
		*avldestroy (t_avl *avl);

  extern void	*avlinsert (t_avl *avl, const void *newelem, ...),
		*avlinsrch (t_avl *avl, bool *insert, const void *elem, ...),
		*avlsearch (t_avl *avl, const void *elem),
		*avlresize (t_avl *avl, const void *elem, size_t varsize);
  extern int	avldelete (t_avl *avl, const void *elem);

  extern int	avltrav (t_avl *tree, int order, int (*f)()),
		avlmap (t_avl *tree, int (*f)()),
		avlrmap (t_avl *tree, int (*f)()),
		avlatrav (t_avl *tree, int order, int (*f)(), void *a),
		avlamap (t_avl *tree, int (*f)(), void *a),
		avlarmap (t_avl *tree, int (*f)(), void *a),
		avlvatrav (t_avl *tree, int order, int (*f)(), ...),
		avlvamap (t_avl *tree, int (*f)(), ...),
		avlvarmap (t_avl *tree, int (*f)(), ...);

  extern t_avl	*avlresort (t_avl *avl, int (*cmpfunc)());

#else /* ! __STDC__ */

  extern t_avl	*avlcreate(),
		*avldestroy();

  extern char	*avlinsert(),
		*avlinsrch(),
		*avlsearch(),
		*avlresize();
  extern int	avldelete();

  extern int	avltrav(),
		avlmap(),
		avlrmap();
		avlatrav(),
		avlamap(),
		avlarmap();
		avlvatrav(),
		avlvamap(),
		avlvarmap();

  extern t_avl	*avlresort();

#endif /* __STDC__ */

#endif /* AVL_H */
