/*
 * library: avl-tree
 * file: avl.c
 *
 * Copyright  1990, 1991, 1992, 1993, 1994 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: avl.c,v $
 * Revision 1.1.1.1  1993/12/31  20:28:46  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: avl.c,v 1.1.1.1 1993/12/31 20:28:46 rj Exp $";

#define avl_internal
#include "avl.h"

#ifdef __STDC__
t_avl *avlcreate (size_t elemsize, int (*cmpfunc)(), void (*freefunc)())
#else
t_avl *avlcreate (elemsize, cmpfunc, freefunc)
  long	elemsize;
  int	(*cmpfunc)();
  void	(*freefunc)();
#endif
{
  t_avl	*new;

  if (!(new = (t_avl *)malloc (sizeof (t_avl))))
    return NULL;
  new->fixsize = elemsize;
  new->cmpfunc = cmpfunc;
  new->freefunc = freefunc;
  new->root = new->first = new->last = NULL;
  return new;
}

/* - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - */

#ifdef __STDC__
static void avlfree (t_avlnode **tree, size_t fixsize, void (*freefunc)())
#else
static void avlfree (tree, fixsize, freefunc)
  t_avlnode	**tree;
  long		fixsize;
  void		(*freefunc)();
#endif
{
  if (*tree)
  {
    avlfree (&(*tree)->n.p.left, fixsize, freefunc);
    if (freefunc)
      if (fixsize)
	(*freefunc)((*tree)->elem.fix);
      else
	(*freefunc)((*tree)->elem.var.buf, (*tree)->elem.var.size);
    avlfree (&(*tree)->n.p.right, fixsize, freefunc);
    (*tree)->pred = (*tree)->succ = NULL;
    free (*tree);
  }
}

#ifdef __STDC__
t_avl *avldestroy (t_avl *avl)
#else
t_avl *avldestroy (avl)
  t_avl	*avl;
#endif
{
  if (avl)
  {
    avlfree (&avl->root, avl->fixsize, avl->freefunc);
    avl->first = avl->last = NULL;
    free (avl);
  }
  return NULL;
}
