/*
 * program: psfilt
 * file: afm.h
 *
 * Copyright  1992 1993 1994 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: afm.h,v 1.4 1994/07/09 16:43:28 rj Exp $
 * $Log: afm.h,v $
 * Revision 1.4  1994/07/09  16:43:28  rj
 * a lot of const's removed and added
 *
 * Revision 1.3  1994/01/09  23:45:34  rj
 * PPD parser fr version 4 PPD files total umgeschrieben.
 * partieller support fr perl.
 *
 * Revision 1.2  1994/01/04  11:56:18  rj
 * minor adjustments
 *
 * Revision 1.1.1.1  1993/12/31  20:56:38  rj
 * erster cvs import.
 *
 */

#ifndef AFM_H
#define AFM_H

#include "list.h"
#include "avl.h"
#include "types.h"
#include "files.h"

typedef enum
{
  FONTWEIGHT_unspecified = -2,
  FONTWEIGHT_unknown = -1,
  FONTWEIGHT_light,
  FONTWEIGHT_normal,
  FONTWEIGHT_bold,
  FONTWEIGHT_extrabold,
} t_fontweight;

extern int		fontweightcmp (t_fontweight, t_fontweight);
extern t_fontweight	fontweightbyname (cstring weightname);
extern string		strfontweight (string buf, t_fontweight fontweight);

/* non-italic fonts usually have an ItalicAngle of 0.0, italic fonts of around -10.0 */
#define ISITALIC(angle)	((angle) < -1.0)

typedef t_rectangle	t_bbox;

#if 0
extern void	clearbbox (t_bbox *);
extern void	printbbox (const t_bbox *);
#endif

typedef struct
{
  string		first,
			second;
} t_ligature;

#if 0
extern void	clearligature (t_ligature *);
extern void	printligature (const t_ligature *);
#endif

typedef struct
{
  string		name;
  int			code;
  t_width		width;
  t_bbox		bbox;
  t_list		*ligatures;
} t_charmetric;

extern void	clearcharmetric (t_charmetric *);
#if 0
extern void	printcharmetric (const t_charmetric *);
#endif

typedef struct
{
  string		left, right;
  t_width		width;
} t_kernpair;

/* all information of an .afm file: */
typedef struct t_afmfile
{
  t_fileinfo		file;

  /* global font information: */
  string		fontname;
  string		fullname;
  string		familyname;
  t_fontweight		weight;
  double		italicangle;
  bool			isfixedpitch;
  t_bbox		bbox;
  t_point		underlineposition;
  t_point		underlinethickness;
  t_version		version;
  string		notice;
  string		encodingscheme;
  t_point		capheight;
  t_point		Xheight;
  t_point		ascender;
  t_point		descender;

  /* individual character metrics: */
  t_avl			*metrics;	/* elems are of t_charmetric; wird in parse-afm.y gefllt	*/
  cstring		encoding[256];
 
  /* kernig data */
    /* track kerning */
	      /* in keinem .afm file enthalten, daher hier nicht vorhanden	*/
    /* pairwise kerning */
  t_avl			*kernpairs;	/* elems are of t_kernpair; wird in parse-afm.y gefllt	*/

} t_afmfile;

extern void			clearafmfile (t_afmfile *);
extern int			printafmfile (const t_afmfile *, bool verbose);
#if 0
extern int			afmfilepcmpfamilyname (const t_afmfile *l, const t_afmfile *r);
#endif
extern int			afmfilepdupcmpfamilyname (const t_afmfile *l, const t_afmfile *r);
extern int			afmfilepcmpfilename (const t_afmfile *l, const t_afmfile *r);
extern int			afmfilepcmpversion (t_afmfile *, t_afmfile *);
extern void			freeafmfile (t_afmfile *);

extern const t_charmetric	*getcharmetric (const t_afmfile *afm, cstring charname);
extern const t_kernpair		*getkernpair (const t_afmfile *this, string left, string right);

/* for parse-afm.y:	*/

extern t_list			*afmdirs;

extern int			scanafm (FILE *, t_afmfile *, bool);
extern int			rescanafm (FILE *, t_afmfile *, bool);
extern int			completeafm (t_afmfile *afm);

#endif
