/*
 * program: psfilt
 * file: adobe.c
 *
 * Copyright  1992 1993 Robert Joop
 *
 * Conversion of UCS2 into PostScript names and vice versa.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: adobe.c,v $
 * Revision 1.2  1994/07/09  16:43:24  rj
 * a lot of const's removed and added
 *
 * Revision 1.1.1.1  1993/12/31  20:56:48  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: adobe.c,v 1.2 1994/07/09 16:43:24 rj Exp $";

#include "psfilt.h"
#include "avl.h"
#include "ucs2list.h"
#include "adobe.h"
#include "verbose.h"
#include "error.h"

/* abbildung UCS2 / PostScript name (eine m:n beziehung) */
typedef struct
{
  cstring	psname;
  t_ucs2	ucs2;
} t_map;

#if 0 /* unused: */
static int mapucs2cmp (l, r)	/* zur sortierung nach UCS2	*/
t_map	**l, **r;
{
  return ucs2cmp ((*l)->ucs2, (*r)->ucs2);
}

static int mappscmp (l, r)	/* zur sortierung nach PostScript namen	*/
  t_map	**l, **r;
{
  return strcmp ((*l)->psname, (*r)->psname);
}
#endif /* unused */

static const t_map table[] =		/* abbildung UCS2 PostScript-Name	*/
{
#include "adobemap.c"

  { ".notdef", UCS2_VOID },

  { "telrec", UCS2_telephone_recorder },
/*
  { "handicapped", UCS2_ },
*/
  { "yinyang", UCS2_yin_yang },
  { "smile", UCS2_smile },
  { "frown", UCS2_frown },
  { "miss", UCS2_replacement_character },
};

typedef struct
{
  t_ucs2	code;
  t_cnames	pschars;
} t_charnames;

static int charnamespcmp (t_charnames *l, t_charnames *r)
{
  return ucs2cmp (l->code, r->code);
}

static t_avl	*ucs2_to_ps;

#ifdef DEBUG
static int printcharnames (const t_charnames *charnames)
{
  t_verblevel	level;
  t_buf		buf;
  int		i;

  level = charnames->pschars.count != 1 ? IMP_debug : IMP_debug2;
  say (level, "UCS2 %s", strucs2 (buf, charnames->code));
  for (i=0; i<charnames->pschars.count; i++)
    say (level, " /%s", charnames->pschars.names[i]);
  say (level, "\n");
  return ok;
}
#endif

static void init_ucs22ps()
{
  int		slot;
  const t_map	*p;

  ucs2_to_ps = avlcreate (0, charnamespcmp, NULL); assert (ucs2_to_ps);
  for (p=table, slot=ARRAYDIM (table); slot-->0; p++)
  {
    bool	insert = true;
    t_charnames	search, *found;

    search.code = p->ucs2;
    search.pschars.count = 1;
    search.pschars.names[0] = p->psname;
    found = avlinsrch (ucs2_to_ps, &insert, &search, sizeof (t_charnames)); assert (found);
    if (!insert)
    {
      found = avlresize (ucs2_to_ps, &search, sizeof (t_charnames)+found->pschars.count*sizeof (cstring)); assert (found);
      found->pschars.names[found->pschars.count++] = p->psname;
    }
  }
#ifdef DEBUG
  avlmap (ucs2_to_ps, printcharnames);
#endif
}

const t_cnames *ucs22ps (t_ucs2 ucs2)
{
  t_charnames		search;
  const t_charnames	*found;

  if (!ucs2_to_ps)
    init_ucs22ps();

  search.code = ucs2;
  return (found = avlsearch (ucs2_to_ps, &search)) ? &found->pschars : NULL;
}

typedef struct
{
  cstring	pschar;
  t_xucs2	codes;
} t_namecodes;

static int namecodespcmp (t_namecodes *l, t_namecodes *r)
{
  return strcmp (l->pschar, r->pschar);
}

static t_avl	*ps_to_ucs2;

#ifdef DEBUG
static int printnamecodes (const t_namecodes *namecodes)
{
  t_verblevel	level;
  t_buf		buf;
  int		i;

  level = namecodes->codes.count != 1 ? IMP_debug : IMP_debug2;
  say (level, "/%s", namecodes->pschar);
  for (i=0; i<namecodes->codes.count; i++)
    say (level, " UCS2 %s", strucs2 (buf, namecodes->codes.codes[i]));
  say (level, "\n");
  return ok;
}
#endif

static void init_ps2ucs2()
{
  int		slot;
  const t_map	*p;

  ps_to_ucs2 = avlcreate (0, namecodespcmp, NULL); assert (ps_to_ucs2);
  for (p=table, slot=ARRAYDIM (table); slot-->0; p++)
  {
    bool	insert = true;
    t_namecodes	search, *found;

    search.pschar = p->psname;
    search.codes.count = 1;
    search.codes.codes[0] = p->ucs2;
    found = avlinsrch (ps_to_ucs2, &insert, &search, sizeof (t_namecodes)); assert (found);
    if (!insert)
    {
      found = avlresize (ps_to_ucs2, &search, sizeof (t_namecodes)+found->codes.count*sizeof (t_ucs2)); assert (found);
      found->codes.codes[found->codes.count++] = p->ucs2;
    }
  }
#ifdef DEBUG
  avlmap (ps_to_ucs2, printnamecodes);
#endif
}

const t_xucs2 *ps2ucs2 (cstring name)
{
  t_namecodes	ps, *ucs2;

  if (!ps_to_ucs2)
    init_ps2ucs2();

  ps.pschar = name;
  if (ucs2 = (t_namecodes *)avlsearch (ps_to_ucs2, &ps))
    return &ucs2->codes;
  return NULL;
}
