/* According to the POSIX standard, most of the functions declared in this
   file should be declared in <unistd.h>, but on some older versions of UN*X,
   the native <unistd.h> file fails to declare any functions at all.

   This file may be used with the GNU C compiler and may be placed into the
   GNU_LIBDIR/gcc-include directory.  GCC will then use it instead of your
   system's own native <unistd.h> file.

   This file includes your system's own native <unistd.h> file (if your
   system has one) and then makes sure that all functions which POSIX
   requires to be declared within <unistd.h> are in fact declared (here).
*/

#ifndef _GNU_UNISTD_H
#define _GNU_UNISTD_H

#define execl ___execl
#define execlp ___execlp
#define execle ___execle
#define chdir ___chdir
#define chown ___chown
#define chmod ___chmod
#define access ___access
#define execve ___execve
#define execv ___execv
#define execvp ___execvp
#define getgroups ___getgroups
#define read ___read
#define rmdir ___rmdir
#define write ___write
#define brk ___brk
#define sbrk ___sbrk
#include </usr/include/unistd.h>
#undef brk
#undef sbrk
#undef write
#undef rmdir
#undef read
#undef getgroups
#undef execve
#undef execvp
#undef execv
#undef access
#undef chown
#undef chmod
#undef chdir
#undef execl
#undef execlp
#undef execle

#ifdef __STDC__
#define __(x) x
#else
#define __(x) ()
#endif

#define __Pid_t int
#define __Uid_t int
#define __Gid_t int
#define __Off_t long

struct stat;

extern int access __((const char *, int));
extern unsigned alarm __((unsigned));
#ifdef ns32532
extern void *brk __((void *));
#else
extern int brk __((void *));
#endif
extern int chdir __((const char *));
extern int chmod __((const char *, int));
extern int chown __((const char *, __Uid_t, __Gid_t));
extern int chroot __((const char *));
extern int close __((int));
extern char *ctermid __((char *));
extern char *cuserid __((char *));
extern int dup __((int));
extern int dup2 __((int, int));
#ifdef ns32532
extern int execl __((const char *, ...));
extern int execle __((const char *, ...));
extern int execlp __((const char *, ...));
#else
extern int execl __((const char *, const char *, ...));
extern int execle __((const char *, const char *, ...));
extern int execlp __((const char *, const char *, ...));
#endif
extern int execv __((const char *, char *const *));
extern int execve __((const char *, char *const *, char *const *));
extern int execvp __((const char *, char *const *));
extern void exit __((int));
extern void _exit __((int));
extern __Pid_t fork __((void));
extern long fpathconf __((int, int));
extern char *getcwd __((char *, int));
extern gid_t getegid __((void));
extern uid_t geteuid __((void));
extern gid_t getgid __((void));
extern int getgroups __((int, __Gid_t *));
extern char *getlogin __((void));
extern __Pid_t getpgid __((__Pid_t));
extern __Pid_t getpid __((void));
extern __Pid_t getppid __((void));
extern __Pid_t getpgrp __((void));
extern uid_t getuid __((void));
#ifdef sun
extern char *getwd  __((char *));
#endif
#ifndef ns32532
extern int ioctl __((int, int, ...));
#endif
extern int isatty __((int));
extern int kill __((__Pid_t, int));
extern int link __((const char *, const char *));
extern int lchown __((const char *, __Uid_t, __Gid_t));
extern off_t lseek __((int, __Off_t, int));
extern int nice __((int));
extern int open __((const char *, int, ...));
extern long int pathconf __((char *, int));
extern int pause __((void));
extern int pipe __((int *));
extern void profil __((unsigned short *, unsigned int, unsigned int, unsigned int));
extern int ptrace __((int, __Pid_t, int, int));
extern int read __((int, void *, unsigned));
extern int readlink __((const char *, void *, int));
extern int rename __((const char *, const char *));
extern int rmdir __((const char *));
extern void *sbrk __((int));
extern int setgid __((__Gid_t));
extern int setpgid __((__Pid_t, __Pid_t));
extern __Pid_t setpgrp __((void));
extern __Pid_t setsid __((void));
extern int setuid __((__Uid_t));
extern unsigned sleep __((unsigned));
extern int stat __((const char *, struct stat *));
extern int symlink __((const char *, const char *));
extern void sync __((void));
extern long sysconf __((int));
extern __Pid_t tcgetpgrp __((int));
extern int tcsetpgrp __((int, __Pid_t));
extern int truncate __((const char *, __Off_t));
extern char *ttyname __((int));
extern int unlink __((const char *));
extern __Pid_t vfork __((void));
extern int wait __((int *));
extern int write __((int, const void *, unsigned));

#undef __
#undef __Uid_t
#undef __Gid_t
#undef __Pid_t
#undef __Off_t

#endif /* !defined(_GNU_UNISTD_H) */
