/* This file is provided for the sake of older UN*X systems which do an
   unprotected typedef of size_t within their <sys/types.h> file (e.g.
   System V.3, SunOS 4.0, Ultrix 3.x, etc.

   There are two problems with the typedefs within the <sys/types.h> file
   in these older systems.

   First, they are not protected by #ifdef _SIZE_T as they should be.  This
   fact can lead to conflicts with other typedef's of size_t which must
   also be present in other "system" include files (e.g. <stdlib.h>).

   Second, for the GNU C compiler, the type size_t needs to be typedef'd
   as `unsigned long' so that prototypes of functions like __builtin_memcpy
   will match up correctly with GCC's own internal idea of the prototypes
   for these builtin functions.

   This file helps to overcome both problems.
*/

#ifndef _GNU_SYS_TYPES_H
#define _GNU_SYS_TYPES_H

#ifndef ns32532
#define size_t ___size_t
#endif
#define wchar_t ___wchar_t
#include </usr/include/sys/types.h>
#ifndef ns32532
#undef size_t
#endif
#undef wchar_t

#ifndef _SIZE_T
#ifndef _T_SIZE
#ifndef __SIZE_T
#ifndef _SIZE_T_
#ifndef ___int_size_t_h
#define _SIZE_T
#define _T_SIZE
#define __SIZE_T
#define _SIZE_T_
#define ___int_size_t_h
typedef unsigned long size_t;   /* GCC likes size_t to be unsigned long */
#endif /* ___int_size_t_h */
#endif /* _SIZE_T_ */
#endif /* __SIZE_T */
#endif /* _T_SIZE */
#endif /* _SIZE_T */
#ifdef ns32532
#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned int size_t;   /* GCC likes size_t to be unsigned long */
#endif
#endif

#ifndef _WCHAR_T
#ifndef _T_WCHAR
#ifndef __WCHAR_T
#ifndef _WCHAR_T_
#ifndef ___int_wchar_t_h
#define _WCHAR_T
#define _T_WCHAR
#define __WCHAR_T
#define _WCHAR_T_
#define ___int_wchar_t_h

#ifdef ultrix
typedef unsigned char wchar_t;          /* Correct for Ultrix 4.0 */
#else
#ifdef sun
typedef unsigned short wchar_t;         /* Correct for SunOS 4.1 */
#else
typedef long wchar_t;                   /* Correct for System V.4 */
#endif
#endif

#endif /* ___int_wchar_t_h */
#endif /* _WCHAR_T_ */
#endif /* __WCHAR_T */
#endif /* _T_WCHAR */
#endif /* _WCHAR_T */

#endif
