/* This is a <stdlib.h> fix file which can be used either for older UN*X
   systems (e.g. SunOS 4.0, System V.3, and ULTRIX 3.x) which don't have
   their own <stdlib.h> file or for newer systems (e.g. SunOS 4.1) which
   have incomplete or slightly non-standard <stdlib.h> files.

   (Note that <stdlib.h> is required (by the ANSI C standard) to be present
   for a "hosted" C implementation.)

   Note that SunOS 4.1, System V.4, and Ultrix 4.x each have a <stdlib.h>
   file, so I guess that progress is being made towards ANSI-C conformance.

   This file should always be installed in the special GNU include directory.
   Even if your system already has its own <stdlib.h> file, having this file
   in the GNU include directory should cause no particular harm.

   The contents of this file are based upon specifications given in the
   ANSI C standard (a public document).  It is believed that the material
   contained herein is therefore non-copyrighted and non-copyrightable.
*/

#ifndef _GNU_STDLIB_H
#define _GNU_STDLIB_H

#define atof ___atof
#define atoi ___atoi
#define atol ___atol
#define strtod ___strtod
#define strtol ___strtol
#define strtoul ___strtoul
#define rand ___rand
#define srand ___srand
#define calloc ___calloc
#define free ___free
#define malloc ___malloc
#define realloc ___realloc
#define abort ___abort
#define atexit ___atexit
#define exit ___exit
#define getenv ___getenv
#define system ___system
#define bsearch ___bsearch
#define qsort ___qsort
#define abs ___abs
#define div ___div
#define labs ___labs
#define ldiv ___ldiv
/* #define mblen ___mblen */
#define mbtowc ___mbtowc
#define wctomb ___wctomb
#define mbstowcs ___mbstowcs
#define wcstombs ___wcstombs
#include </usr/include/stdlib.h>
#undef atof
#undef atoi
#undef atol
#undef strtod
#undef strtol
#undef strtoul
#undef rand
#undef srand
#undef calloc
#undef free
#undef malloc
#undef realloc
#undef abort
#undef atexit
#undef exit
#undef getenv
#undef system
#undef bsearch
#undef qsort
#undef abs
#undef div
#undef labs
#undef ldiv
/* #undef mblen */
#undef mbtowc
#undef wctomb
#undef mbstowcs
#undef wcstombs

#ifndef _SIZE_T
#ifndef _T_SIZE
#ifndef __SIZE_T
#ifndef _SIZE_T_
#ifndef ___int_size_t_h
#define _SIZE_T
#define _T_SIZE
#define __SIZE_T
#define _SIZE_T_
#define ___int_size_t_h
typedef unsigned long size_t;   /* GCC likes size_t to be unsigned long */
#endif /* ___int_size_t_h */
#endif /* _SIZE_T_ */
#endif /* __SIZE_T */
#endif /* _T_SIZE */
#endif /* _SIZE_T */

#ifndef _WCHAR_T
#ifndef _T_WCHAR
#ifndef __WCHAR_T
#ifndef _WCHAR_T_
#ifndef ___int_wchar_t_h
#define _WCHAR_T
#define _T_WCHAR
#define __WCHAR_T
#define _WCHAR_T_
#define ___int_wchar_t_h

#ifdef ultrix
typedef unsigned char wchar_t;          /* Correct for Ultrix 4.0 */
#else
#ifdef sun
typedef unsigned short wchar_t;         /* Correct for SunOS 4.1 */
#else
typedef long wchar_t;                   /* Correct for System V.4 */
#endif
#endif

#endif /* ___int_wchar_t_h */
#endif /* _WCHAR_T_ */
#endif /* __WCHAR_T */
#endif /* _T_WCHAR */
#endif /* _WCHAR_T */

/* If we got _STDLIB_H or _STDLIB_H_ defined, then we probably are on
   a System V.4 system or on an Ultrix 4.0 system (respectively) so the
   types div_t and ldiv_t have been defined already by the "native"
   system <stdlib.h> file.
*/

#if !defined (_STDLIB_H) && !defined(_STDLIB_H_)

typedef	struct {
	 int	quot;
	 int	rem;
	} div_t;

typedef struct {
	 long	quot;
	 long	rem;
	} ldiv_t;

#endif /* !defined(_STDLIB_H) && !defined(_STDLIB_H_) */

#undef NULL
#define NULL	((void *)0)

#ifndef EXIT_FAILURE
#define EXIT_FAILURE 1
#endif

#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS 0
#endif

#ifndef RAND_MAX
#define RAND_MAX	32767
#endif

#ifndef MB_CUR_MAX
/* Use 1 for lack of a better value.  */
#define MB_CUR_MAX	1
#endif

#ifdef __STDC__
#define __(x) x
#else
#define __(x) ()
#endif

extern double atof __((const char *__nptr));
extern int atoi __((const char *__nptr));
extern long int atol __((const char *__nptr));
extern double strtod __((const char *__nptr, char **__endptr));
extern long int strtol __((const char *__nptr, char **__endptr, int __base));
extern unsigned long int strtoul __((const char *__nptr, char **__endptr, int __base));

extern int rand __((void));
extern void srand __((unsigned int __seed));

extern void *calloc __((size_t __nmemb, size_t __size));
extern void free __((void *__ptr));
extern void *malloc __((size_t __size));
extern void *realloc __((void *__ptr, size_t __size));

extern void abort __((void));
extern int atexit __((void (*__func)(void)));
extern void exit __((int __status));
extern char *getenv __((const char *__name));
extern int system __((const char *__string));

extern void *bsearch __((const void *__key, const void *__base,
			 size_t __nmemb, size_t __size,
			 int (*__compar)(const void *, const void *)));
extern void qsort __((void *__base, size_t __nmemb, size_t __size,
		      int (*__compar)(const void *, const void *)));

extern int abs __((int __j));
extern div_t div __((int __numer, int __denom));
extern long int labs __((long int __j));
extern ldiv_t ldiv __((long int __numer, long int __denom));

/* NOTE: SunOS 4.1 defines mblen as a macro.  */

#ifndef mblen
extern int mblen __((const char *__s, size_t __n));
#endif
extern int mbtowc __((wchar_t *__pwc, const char *__s, size_t __n));
extern int wctomb __((char *__s, wchar_t __wchar));

extern size_t mbstowcs __((wchar_t *__pwcs, const char *__s, size_t __n));
extern size_t wcstombs __((char *__s, const wchar_t *__pwcs, size_t __n));

#undef __

#endif 	/* !defined __((_GNU_STDLIB_H) */
