/* According to the ANSI-C standard, all of the functions declared in this
   file should be declared in <stdio.h>, but on some operating systems (most
   notably SunOS 4.0 and SunOS 4.1) some/many of these functions are not
   declared in <stdio.h> as they should be.

   This file may be used with the GNU C compiler and may be placed into the
   GNU_LIBDIR/gcc-include directory.  GCC will then use it instead of your
   system's own native <stdio.h> file.

   This file includes your native <stdio.h> file and then makes sure that all
   functions which ANSI-C requires to be declared within <stdio.h> are in
   fact declared.

   Note that SunOS and some other BSD-derived systems have sprintf() returning
   a char* but the ANSI C standard calls for it to return an int.  These two
   possibilities are radically incompatible, but here we allow SunOS to have
   its way (even though that means deviating from the ANSI-C standard).
*/

#ifndef _GNU_STDIO_H
#define _GNU_STDIO_H

#define fprintf ___fprintf
#define fscanf ___fscanf
#define printf ___printf
#define scanf ___scanf
#define sprintf ___sprintf
#define sscanf ___sscanf
/*#define remove ___remove*/
#define fopen ___fopen
#define freopen ___freopen
#define setvbuf ___setvbuf
#define vprintf ___vprintf
#define vfprintf ___vfprintf
#define vsprintf ___vsprintf
#define fputs ___fputs
#define puts ___puts
#define fread ___fread
#define fwrite ___fwrite
#define fsetpos ___fsetpos
#define perror ___perror
#define rename ___rename
#include </usr/include/stdio.h>
#undef rename
#undef fprintf
#undef fscanf
#undef printf
#undef scanf
#undef sprintf
#undef sscanf
/*#undef remove*/
#undef fopen
#undef freopen
#undef setvbuf
#undef vprintf
#undef vfprintf
#undef vsprintf
#undef fputs
#undef puts
#undef fread
#undef fwrite
#undef fsetpos
#undef perror

/* The type size_t is always defined as `unsigned long' for GNU C.  */

#define _SIZE_T_TYPE unsigned long

/* The type fpos_t is probably type `long'.  If that's not correct for your
   system, change the following define.  */

#define _FPOS_T_TYPE long

#ifdef __STDC__
#define __(x) x
#else
#define __(x) ()
#endif

#ifndef ns32532
extern int remove __((const char *__filename));
#endif
extern int rename __((const char *__old, const char *__new));
extern FILE *tmpfile __((void));
extern char *tmpnam __((char *__s));
extern int fclose __((FILE *__stream));
extern int fflush __((FILE *__stream));
extern FILE *fopen __((const char *__filename, const char *__mode));
extern FILE *freopen __((const char *__filename, const char *__mode, FILE *__stream));
extern void setbuf __((FILE *__stream, char *__buf));
extern int setvbuf __((FILE *__stream, char *__buf, int __mode, _SIZE_T_TYPE __size));
extern int fprintf __((FILE *__stream, const char *__format, ...));
extern int fscanf __((FILE *__stream, const char *__format, ...));
extern int printf __((const char *__format, ...));
extern int scanf __((const char *__format, ...));
extern
#if defined(sun) || defined(bsd4_2) || defined (bsd43) || (defined(ultrix) && !defined(SYSTEM_FIVE)) || defined (alliant) || defined (aegis) || defined (convex) || defined (tahoe) || defined (is68k) || defined (NeXT) || defined (pyr) || defined (sequent)
	char *
#else
	int
#endif
		sprintf __((char *__s, const char *__format, ...));
extern int sscanf __((const char *__s, const char *__format, ...));
#if defined(va_list) || defined(_VA_LIST_)
extern int vfprintf __((FILE *__stream, const char *__format, va_list __arg));
extern int vprintf __((const char *__format, va_list __arg));
extern int vsprintf __((char *__s, const char *__format, va_list __arg));
#endif
extern int fgetc __((FILE *__stream));
extern char *fgets __((char *__s, int __n, FILE *__stream));
extern int fputc __((int __c, FILE *__stream));
extern int fputs __((const char *__s, FILE *__stream));
#ifndef getc
extern int getc __((FILE *__stream));
#endif
#ifndef getchar
extern int getchar __((void));
#endif
extern char *gets __((char *__s));
#ifndef putc
extern int putc __((int __c, FILE *__stream));
#endif
#ifndef putchar
extern int putchar __((int __c));
#endif
extern int puts __((const char *__s));
extern int ungetc __((int __c, FILE *__stream));
extern _SIZE_T_TYPE fread __((void *__ptr, _SIZE_T_TYPE __size, _SIZE_T_TYPE __nmemb, FILE *__stream));
extern _SIZE_T_TYPE fwrite __((const void *__ptr, _SIZE_T_TYPE __size, _SIZE_T_TYPE __nmemb, FILE *__stream));
extern int fgetpos __((FILE *__stream, _FPOS_T_TYPE *__pos));
extern int fseek __((FILE *__stream, long int __offset, int __whence));
extern int fsetpos __((FILE *__stream, const _FPOS_T_TYPE *__pos));
extern long int ftell __((FILE *__stream));
extern void rewind __((FILE *__stream));
#ifndef clearerr
extern void clearerr __((FILE *__stream));
#endif
#ifndef feof
extern int feof __((FILE *__stream));
#endif
#ifndef ferror
extern int ferror __((FILE *__stream));
#endif
extern void perror __((const char *__s));

#undef __

#endif /* !defined (_GNU_STDIO_H) */
