/* According to the ANSI-C standard, all of the functions declared in this
   file should be declared in <stdlib.h>, but many older versions of UN*X
   did not have a file called <stdlib.h> and so many older C programs still
   contain #include directives for <malloc.h>.

   This file may be used with the GNU C compiler to make sure that programs
   which #include <malloc.h> will get ANSI-conformant declarations of the
   functions declared below.

   This file may be placed into the GNU_LIBDIR/gcc-include directory.  GCC
   will then use it instead of your system's own native <malloc.h> file.

   This file includes your native <malloc.h> file and then makes sure that
   all functions normally declared within <malloc.h> have ANSI-conformant
   declarations.

   Note that older versions of UN*X have malloc, realloc, and calloc returning
   a char* but the ANSI C standard calls for these functions to return void*.
   This file effectively corrects such problems.
*/

#ifndef _GNU_MALLOC_H
#define _GNU_MALLOC_H

#define malloc ___malloc
#define realloc ___realloc
#define calloc ___calloc
#define free ___free
#undef malloc
#undef realloc
#undef calloc
#undef free

#include <stdlib.h>

#endif /* !defined (_GNU_MALLOC_H) */
