#include <stdio.h>
#include <sgtty.h>
#include "def.h"
#include "ttydef.h"

#define NOBUF 512
char obuf [NOBUF];
int  nobuf = 0,
     nrow,
     ncol;

FILE *fopen (), *ttyout;
int ttyin;
struct sgttyb old_bits;

ttopen()
{
  char *envstr;
  extern char *getenv();

  ttyin = open ("/dev/tty", 0);
  ttyout = fopen ("/dev/tty", "w");
  set_tty_mode ();
  ncol = 80;
  if (NULL != (envstr = getenv ("LINES")) &&
    1 == sscanf (envstr, "%d", &nrow));
  else if (NULL != (envstr = getenv ("TERM")) &&
    (!strcmp (envstr, "hp2622big") || !strcmp (envstr, "hp2622-45")))
    nrow = 45;
  else nrow = 24;
  if (nrow > NROW) nrow = NROW;
}

/* Save old tty mode, set raw mode. */
set_tty_mode ()
{
  struct sgttyb new_bits;

  if (-1 == ioctl (ttyin, TIOCGETP, &old_bits)) {
    fprintf (stderr, "IOCTL TIOCGETP failed\n");
    exit (-1);
  }
  new_bits = old_bits;
  new_bits.sg_flags &= ~CBREAK;
  new_bits.sg_flags &= ~ECHO;
  new_bits.sg_flags &= ~CRMOD;
  new_bits.sg_flags |= RAW;
  if (-1 == ioctl (ttyin, TIOCSETP, &new_bits)) {
    fprintf (stderr, "IOCTL TIOCSETP failed\n");
    exit (-1);
  }
}

/* Restore old tty mode. */
ttclose ()
{
  if (-1 == ioctl (ttyin, TIOCSETP, &old_bits)) {
    fprintf (stderr, "IOCTL TIOCSETP failed\n");
    exit (-1);
  }
}

/*
 * This routine scans a string, which is
 * actually the return value of a getenv call for the TERMCAP
 * variable, looking for numeric parameter "name". Return the value
 * if found. Return -1 if not there. Assume that "name" is 2
 * characters long. This limited use of the TERMCAP lets us find
 * out the size of a window on the X display.
 */
getvalue(cp, name)
register char	*cp;
register char	*name;
{
	for (;;) {
		while (*cp!=0 && *cp!=':')
			++cp;
		if (*cp++ == 0)			/* Not found.		*/
			return (-1);
		if (cp[0]==name[0] && cp[1]==name[1] && cp[2]=='#')
			return (atoi(cp+3));	/* Stops on ":".	*/
	}
}


/*
 * Write character to the display.
 * Characters are buffered up, to make things
 * a little bit more efficient.
 */
ttputc(c)
{
	if (nobuf >= NOBUF)
		ttflush();
	obuf[nobuf++] = c;
}

/*
 * Flush output.
 */
ttflush()
{
	if (nobuf != 0) {
		fwrite(obuf, sizeof (char), nobuf, ttyout);
		nobuf = 0;
                fflush (ttyout);
	}
}

/*
 * Read character from terminal.
 * All 8 bits are returned, so that you can use
 * a multi-national terminal.
 */
ttgetc()
{
	char	buf[1];

	while (read(0, &buf[0], 1) != 1)
		;
	return (buf[0] & 0xFF);
}
