/*
 * Name:	MicroEMACS
 *		Miscellaneous extensions
 * Version:	30+
 * Last edit:	30-Apr-86
 * By:		oz
 *		decvax!utzoo!yetti!oz
 */
#include	"def.h"

/* Ask for a file name, open the file, call fileinsert1() to actually
 * insert it, print number of lines inserted.
 */
fileinsert(f, n, k)
{
	int 		s;
	char		fname[NFILEN];
	int		nline;

	if ((s=efilename("Insert file: ", fname, NFILEN)) != TRUE)
		return (s);
	adjustcase(fname);
	if ((s=ffropen(fname)) == FIOFNF) {	/* hard file open*/
		if (kbdmop == NULL)
			eprintf("Cannot open %s", fname);
		return(FALSE);
	}
	if (FALSE == fileinsert1(&nline)) return FALSE;
	if (s==FIOEOF && kbdmop==NULL) {	/* do not zap anything  */
		if (nline == 1)
			eprintf("[Inserted 1 line]");
		else
			eprintf("[Inserted %d lines]", nline);
	}
	return (TRUE);
}

/*
 * Insert a file at the dot a la yank. This is not
 * terribly difficult. Insert routines handle
 * it all. Assume ffp is already open; loop through
 * the entire file. Just like yank, we try to
 * handle the cosmetic bug, so that when entire
 * text lands off screen, we will not look silly.
 * This is usually bound to C-X C-I.
 */
int
fileinsert1 (nl)
int *nl;
{
	int 	s;
	char	*p;
	LINE	*lp;
	char	line[NLINE];
	int	nline;

	nline = 0;				/* newline counting..*/
	while ((s=ffgetline(line, NLINE)) == FIOSUC) {
		for (p = line; *p; p++)
			if (linsert(1, *p) == FALSE)
				return(FALSE);
						/* eol: fake newline..*/
		if(newline(FALSE, 1, KRANDOM) == FALSE)
			return(FALSE);
		++nline;
	}
	ffclose();				/* ignore errors here*/
	lp = curwp->w_linep;			/* Cosmetic adjustment*/
	if (curwp->w_dotp == lp) {		/* if offscreen insert.*/
		while (nline-- && lback(lp)!=curbp->b_linep)
			lp = lback(lp);
		curwp->w_linep = lp;		/* Adjust framing.*/
		curwp->w_flag |= WFHARD;
	}
	*nl = nline;
	return (TRUE);
}
