/* Parenthesis matching.
 * Bruce Culbertson
 * 10 April 1989
 *
 * Dot character must be a matchable character.  Moves dot to matching
 * character, if found; else, beeps.
 */
#include "def.h"

typedef struct {
  char	cur_ch, match_ch;
  int	forward;
} match;

match match_tbl[] = {
  {'(', ')', TRUE},
  {'[', ']', TRUE},
  {'{', '}', TRUE},
  {')', '(', FALSE},
  {']', '[', FALSE},
  {'}', '{', FALSE},
};

#define MATCH_TBL_SZ (sizeof (match_tbl) / sizeof (match))

match_paren(f, n, k)
{
  register LINE		*clp;
  register int		cbo, c;
  register match	*mp;
  int	nesting;

  clp = curwp->w_dotp;
  cbo = curwp->w_doto;
  c = lgetc (clp,cbo);
  for (mp = match_tbl;			/* find character to match */
  mp < match_tbl + MATCH_TBL_SZ; ++mp)
    if (mp->cur_ch == c) break;
  if (mp == match_tbl + MATCH_TBL_SZ) {	/* beep if not found */
    ttbeep();
    return FALSE;
  }
  for (nesting = 1;;) {
    if (mp->forward) {			/* if forward direction */
      if (++cbo == llength(clp)) {	/* get character */
        clp = lforw(clp);
        if (clp == curbp->b_linep) break;	/* check EOB */
        cbo = -1;
        c = '\n';
      } else c = lgetc(clp, cbo);
    } else {				/* backward direction */
      if (cbo == 0) {			/* check BOB */
        clp = lback(clp);
        if (clp == curbp->b_linep) break;
        cbo = llength(clp)+1;
      }
      c = (--cbo == llength(clp))?	/* get character */
	'\n': lgetc(clp,cbo);
    }
    if (c == mp->cur_ch) ++nesting;
    else if (c == mp->match_ch) {
      if (0 == --nesting) {
        curwp->w_dotp = clp;
        curwp->w_doto = cbo;
        curwp->w_flag |= WFMOVE;
        return TRUE;
      }
    }
  }
  eprintf ("Not found");
  return FALSE;
}
