/*
 * Name:	MicroEMACS
 * 		Ultrix-32 file I/O.
 * Version:	29
 * Last edit:	05-Feb-86
 * By:		rex::conroy
 *		decvax!decwrl!dec-rhea!dec-rex!conroy
 */
#include	"def.h"
#include	"fcntl.h"

static	FILE	*ffp;
extern	FILE	*popen();
static	int	stderr_fd, stdout_fd;

/*
 * Open a file for reading.
 */
ffropen(fn)
char	*fn;
{
	if ((ffp=fopen(fn, "r")) == NULL)
		return (FIOFNF);
	return (FIOSUC);
}

/*
 * Open a file for writing.
 * Return TRUE if all is well, and
 * FALSE on error (cannot create).
 */
ffwopen(fn)
char	*fn;
{
	if ((ffp=fopen(fn, "w")) == NULL) {
		eprintf("Cannot open file for writing");
		return (FIOERR);
	}
	return (FIOSUC);
}

/*
 * Close a file.
 * Should look at the status.
 */
ffclose()
{
	fclose(ffp);
	return (FIOSUC);
}

/*
 * Set up a filter from uemacs, to user supplied commands, to a
 * temporary file.
 */
int
ffopenpipe (cmd, tmp)
char *cmd;
char *tmp;
{
  int newstdout, newstderr;

  stdout_fd = dup (1);			/* save stdout, stderr */
  stderr_fd = dup (2);
  close (1);				/* set stdout, stderr to tmp */
  close (2);
  newstdout = open (tmp, O_WRONLY | O_CREAT, 0600);
  newstderr = dup (1);
  if (newstdout != 1 || newstderr != 2) {
    close (1);
    close (2);
    dup (stdout_fd);
    dup (stderr_fd);
    eprintf ("Cannot redirect files correctly, stdout=%d, stderr=%d",
      newstdout, newstderr);
    return FIOERR;
  }
  ffp = popen (cmd, "w");		/* open pipe */
  if (ffp == NULL) {
    close (1);
    close (2);
    dup (stdout_fd);
    dup (stderr_fd);
    eprintf ("Popen failed");
    return FIOERR;
  } else return FIOSUC;
}

/* Close pipe, fix up stdout and stderr.
 */
ffclosepipe ()
{
  pclose (ffp);
  close (1);
  close (2);
  dup (stdout_fd);
  dup (stderr_fd);
}

/* Remove a file.
 */
ffunlink (t)
char *t;
{
  unlink (t);
}

/*
 * Write a line to the already
 * opened file. The "buf" points to the
 * buffer, and the "nbuf" is its length, less
 * the free newline. Return the status.
 * Check only at the newline.
 */
ffputline(buf, nbuf)
register char	buf[];
{
	register int	i;

	for (i=0; i<nbuf; ++i)
		putc(buf[i]&0xFF, ffp);
	putc('\n', ffp);
	if (ferror(ffp) != FALSE) {
		eprintf("Write I/O error");
		return (FIOERR);
	}
	return (FIOSUC);
}

/*
 * Read a line from a file, and store the bytes
 * in the supplied buffer. Stop on end of file or end of
 * line. Don't get upset by files that don't have an end of
 * line on the last line; this seem to be common on CP/M-86 and
 * MS-DOS (the suspected culprit is VAX/VMS kermit, but this
 * has not been confirmed. If this is sufficiently researched
 * it may be possible to pull this kludge). Delete any CR
 * followed by an LF. This is mainly for runoff documents,
 * both on VMS and on Ultrix (they get copied over from
 * VMS systems with DECnet).
 */
ffgetline(buf, nbuf)
register char	buf[];
{
	register int	c;
	register int	i;

	i = 0;
	for (;;) {
		c = getc(ffp);
		if (c == '\r') {		/* Delete any non-stray	*/
			c = getc(ffp);		/* carriage returns.	*/
			if (c != '\n') {
				if (i >= nbuf-1) {
					eprintf("File has long line");
					return (FIOERR);
				}
				buf[i++] = '\r';
			}
		}
		if (c==EOF || c=='\n')		/* End of line.		*/
			break;
		if (i >= nbuf-1) {
			eprintf("File has long line");
			return (FIOERR);
		}
		buf[i++] = c;
	}
	if (c == EOF) {				/* End of file.		*/
		if (ferror(ffp) != FALSE) {
			eprintf("File read error");
			return (FIOERR);
		}
		if (i == 0)			/* Don't get upset if	*/
			return (FIOEOF);	/* no newline at EOF.	*/
	}
	buf[i] = 0;
	return (FIOSUC);
}

/*
 * Rename the file "fname" into a backup
 * copy. On Unix the backup has the same name as the
 * original file, with a "~" on the end; this seems to
 * be newest of the new-speak. The error handling is
 * all in "file.c". The "unlink" is perhaps not the
 * right thing here; I don't care that much as
 * I don't enable backups myself.
 */
fbackupfile(fname)
char	*fname;
{
	register char	*nname;

	if ((nname=malloc(strlen(fname)+1+1)) == NULL)
		return (ABORT);
	(void) strcpy(nname, fname);
	(void) strcat(nname, "~");
	(void) unlink(nname);			/* Ignore errors.	*/
	if (link(fname, nname) < 0) {
		free(nname);
		return (FALSE);
	} else unlink (fname);
	free(nname);
	return (TRUE);
}

/*
 * The string "fn" is a file name.
 * Perform any required case adjustments. All sustems
 * we deal with so far have case insensitive file systems.
 * We zap everything to lower case. The problem we are trying
 * to solve is getting 2 buffers holding the same file if
 * you visit one of them with the "caps lock" key down.
 * On UNIX file names are dual case, so we leave
 * everything alone.
 */
adjustcase(fn)
register char	*fn;
{
  char tmp [NFILEN],
       *getenv(),
       *home,
       *cp;

  /* look for home directory -- "~" */
  for (cp = fn; *cp == ' '; ++cp);
  if (*cp == '~') {
    if (NULL != (home = getenv ("HOME"))) {
      strcpy (tmp, home);
      strcat (tmp, ++cp);
      strcpy (fn, tmp);
    }
  }

#if	0
	register int	c;

	while ((c = *fn) != 0) {
		if (c>='A' && c<='Z')
			*fn = c + 'a' - 'A';
		++fn;
	}
#endif
}
