#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>
#include <limits.h>

#ifndef PATH_MAX
#  define PATH_MAX 255
#endif

/* Expand a path.  Convert the path to be the intersection of all paths
 * which are super sets of the given path.  Return 1 if there is a
 * unique expansion, 0 if there are 0 or many expansions.
 */
int
expand_path (p)
char *p;
{
  DIR		*dp;
  struct dirent	*entp;
  char		directory [PATH_MAX + 1];
  char		file [PATH_MAX + 1];
  char		intersection [PATH_MAX + 1];
  int		num_intersect;
  int		ret;

  if (split_path (p, directory, file))
    dp = opendir (directory);
  else dp = opendir (".");
  if (NULL == dp) ret = 0;
  else {
    num_intersect = 0;
    while (NULL != (entp = readdir (dp)))
      if (substring (entp->d_name, file)) {
	if (0 == num_intersect++) strcpy (intersection, entp->d_name);
	else intersect (intersection, entp->d_name);
      }
    strcpy (p, directory);
    strcat (p, num_intersect == 0? file: intersection);
    ret = num_intersect == 1? 1: 0;
    closedir (dp);
  }
  return ret;
}

/* Split a path s into a directory and a file.  Return 1 if a directory
 * was found in s, 0 otherwise.  Return directory in d, file in f.
 * If s begins with "~/" and HOME is in the environment, then ~/ will
 * be expanded to HOME.
 */
int
split_path (s, d, f)
char *s, *d, *f;
{
  char	*sp = s,
	*dp = d,
	*last_slashs = NULL,
	*last_slashd = NULL,
	*home,
	*getenv();

  if (s[0] == '~' && s[1] == '/' &&	/* expand ~ to $HOME */
    NULL != (home = getenv ("HOME")))
  {
    sp += 1;
    strcpy (d, home);
    dp += strlen (home); 
  }
  for (; *sp; ++dp, ++sp)
    if ('/' == (*dp = *sp)) {
      last_slashd = dp;
      last_slashs = sp;
    }
  if (NULL == last_slashd) {
    strcpy (f, s);
    *d = '\0';
    return 0;
  } else {
    last_slashd[1] = '\0';
    strcpy (f, last_slashs + 1);
    return 1;
  }
}

/* Return 1 if sub is a substring of s.
 */
int
substring (s, sub)
char *s, *sub;
{
  for (; *sub; ++s, ++sub) {
    if (*s != *sub) return 0;
  }
  return 1;
}

/* Return in i the intersection of string i and s.
 */
intersect (i, s)
char *i, *s;
{
  for (; *i && *i == *s; ++i, ++s);
  *i = '\0';
}
