/* Module default_pager_object */

#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/mig_errors.h>

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

/* Due to pcc compiler bug, cannot use void */
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(hc)
#define novalue void
#else
#define novalue int
#endif

#define msgh_request_port	msgh_local_port
#define MACH_MSGH_BITS_REQUEST(bits)	MACH_MSGH_BITS_LOCAL(bits)
#define msgh_reply_port		msgh_remote_port
#define MACH_MSGH_BITS_REPLY(bits)	MACH_MSGH_BITS_REMOTE(bits)

#include <mach/std_types.h>
#include <mach/mach_types.h>

/* Routine default_pager_object_create */
mig_internal novalue _Xdefault_pager_object_create
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t object_sizeType;
		vm_size_t object_size;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t memory_objectType;
		memory_object_t memory_object;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t default_pager_object_create
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t default_pager, memory_object_t *memory_object, mach_msg_type_name_t *memory_objectPoly, vm_size_t object_size);
#else
		();
#endif

	boolean_t msgh_simple;
#if	UseStaticMsgType
	static mach_msg_type_t object_sizeCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t memory_objectType = {
		/* msgt_name = */		((mach_msg_type_name_t) -1),
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	mach_msg_type_name_t memory_objectPoly;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->object_sizeType != * (int *) &object_sizeCheck)
#else	UseStaticMsgType
	if ((In0P->object_sizeType.msgt_inline != TRUE) ||
	    (In0P->object_sizeType.msgt_longform != FALSE) ||
	    (In0P->object_sizeType.msgt_name != 2) ||
	    (In0P->object_sizeType.msgt_number != 1) ||
	    (In0P->object_sizeType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = default_pager_object_create(In0P->Head.msgh_request_port, &OutP->memory_object, &memory_objectPoly, In0P->object_size);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	msgh_simple = TRUE;
	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->memory_objectType = memory_objectType;
#else	UseStaticMsgType
	OutP->memory_objectType.msgt_size = 32;
	OutP->memory_objectType.msgt_number = 1;
	OutP->memory_objectType.msgt_inline = TRUE;
	OutP->memory_objectType.msgt_longform = FALSE;
	OutP->memory_objectType.msgt_deallocate = FALSE;
	OutP->memory_objectType.msgt_unused = 0;
#endif	UseStaticMsgType

	if (MACH_MSG_TYPE_PORT_ANY(memory_objectPoly))
		msgh_simple = FALSE;

	OutP->memory_objectType.msgt_name = memory_objectPoly;

	if (!msgh_simple)
		OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
}

/* Routine default_pager_info */
mig_internal novalue _Xdefault_pager_info
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t total_spaceType;
		vm_size_t total_space;
		mach_msg_type_t free_spaceType;
		vm_size_t free_space;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t default_pager_info
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t default_pager, vm_size_t *total_space, vm_size_t *free_space);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t total_spaceType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t free_spaceType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = default_pager_info(In0P->Head.msgh_request_port, &OutP->total_space, &OutP->free_space);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 48;

#if	UseStaticMsgType
	OutP->total_spaceType = total_spaceType;
#else	UseStaticMsgType
	OutP->total_spaceType.msgt_name = 2;
	OutP->total_spaceType.msgt_size = 32;
	OutP->total_spaceType.msgt_number = 1;
	OutP->total_spaceType.msgt_inline = TRUE;
	OutP->total_spaceType.msgt_longform = FALSE;
	OutP->total_spaceType.msgt_deallocate = FALSE;
	OutP->total_spaceType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->free_spaceType = free_spaceType;
#else	UseStaticMsgType
	OutP->free_spaceType.msgt_name = 2;
	OutP->free_spaceType.msgt_size = 32;
	OutP->free_spaceType.msgt_number = 1;
	OutP->free_spaceType.msgt_inline = TRUE;
	OutP->free_spaceType.msgt_longform = FALSE;
	OutP->free_spaceType.msgt_deallocate = FALSE;
	OutP->free_spaceType.msgt_unused = 0;
#endif	UseStaticMsgType
}

static mig_routine_t default_pager_object_server_routines[] = {
		_Xdefault_pager_object_create,
		_Xdefault_pager_info,
};

mig_external boolean_t default_pager_object_server
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	register mach_msg_header_t *InP =  InHeadP;
	register mig_reply_header_t *OutP = (mig_reply_header_t *) OutHeadP;

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	register mig_routine_t routine;

	OutP->Head.msgh_bits = MACH_MSGH_BITS(MACH_MSGH_BITS_REPLY(InP->msgh_bits), 0);
	OutP->Head.msgh_size = sizeof *OutP;
	OutP->Head.msgh_remote_port = InP->msgh_reply_port;
	OutP->Head.msgh_local_port = MACH_PORT_NULL;
	OutP->Head.msgh_seqno = 0;
	OutP->Head.msgh_id = InP->msgh_id + 100;

#if	UseStaticMsgType
	OutP->RetCodeType = RetCodeType;
#else	UseStaticMsgType
	OutP->RetCodeType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->RetCodeType.msgt_size = 32;
	OutP->RetCodeType.msgt_number = 1;
	OutP->RetCodeType.msgt_inline = TRUE;
	OutP->RetCodeType.msgt_longform = FALSE;
	OutP->RetCodeType.msgt_deallocate = FALSE;
	OutP->RetCodeType.msgt_unused = 0;
#endif	UseStaticMsgType

	if ((InP->msgh_id > 2276) || (InP->msgh_id < 2275) ||
	    ((routine = default_pager_object_server_routines[InP->msgh_id - 2275]) == 0)) {
		OutP->RetCode = MIG_BAD_ID;
		return FALSE;
	}
	(*routine) (InP, &OutP->Head);
	return TRUE;
}

mig_external mig_routine_t default_pager_object_server_routine
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP)
#else
	(InHeadP)
	mach_msg_header_t *InHeadP;
#endif
{
	register int msgh_id;

	msgh_id = InHeadP->msgh_id - 2275;

	if ((msgh_id > 1) || (msgh_id < 0))
		return 0;

	return default_pager_object_server_routines[msgh_id];
}

