/* Module service */

#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/mig_errors.h>

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

/* Due to pcc compiler bug, cannot use void */
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(hc)
#define novalue void
#else
#define novalue int
#endif

#define msgh_request_port	msgh_local_port
#define MACH_MSGH_BITS_REQUEST(bits)	MACH_MSGH_BITS_LOCAL(bits)
#define msgh_reply_port		msgh_remote_port
#define MACH_MSGH_BITS_REPLY(bits)	MACH_MSGH_BITS_REMOTE(bits)

#include <mach/std_types.h>

/* Routine service_checkin */
mig_internal novalue _Xservice_checkin
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t service_desiredType;
		mach_port_t service_desired;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t service_grantedType;
		mach_port_t service_granted;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t do_service_checkin
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t service_request, mach_port_t service_desired, mach_port_t *service_granted);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t service_desiredCheck = {
		/* msgt_name = */		17,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t service_grantedType = {
		/* msgt_name = */		16,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->service_desiredType != * (int *) &service_desiredCheck)
#else	UseStaticMsgType
	if ((In0P->service_desiredType.msgt_inline != TRUE) ||
	    (In0P->service_desiredType.msgt_longform != FALSE) ||
	    (In0P->service_desiredType.msgt_name != 17) ||
	    (In0P->service_desiredType.msgt_number != 1) ||
	    (In0P->service_desiredType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = do_service_checkin(In0P->Head.msgh_request_port, In0P->service_desired, &OutP->service_granted);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->service_grantedType = service_grantedType;
#else	UseStaticMsgType
	OutP->service_grantedType.msgt_name = 16;
	OutP->service_grantedType.msgt_size = 32;
	OutP->service_grantedType.msgt_number = 1;
	OutP->service_grantedType.msgt_inline = TRUE;
	OutP->service_grantedType.msgt_longform = FALSE;
	OutP->service_grantedType.msgt_deallocate = FALSE;
	OutP->service_grantedType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine service_waitfor */
mig_internal novalue _Xservice_waitfor
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t service_desiredType;
		mach_port_t service_desired;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t do_service_waitfor
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t service_request, mach_port_t service_desired);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t service_desiredCheck = {
		/* msgt_name = */		17,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->service_desiredType != * (int *) &service_desiredCheck)
#else	UseStaticMsgType
	if ((In0P->service_desiredType.msgt_inline != TRUE) ||
	    (In0P->service_desiredType.msgt_longform != FALSE) ||
	    (In0P->service_desiredType.msgt_name != 17) ||
	    (In0P->service_desiredType.msgt_number != 1) ||
	    (In0P->service_desiredType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = do_service_waitfor(In0P->Head.msgh_request_port, In0P->service_desired);
}

static mig_routine_t service_server_routines[] = {
		0,
		_Xservice_checkin,
		_Xservice_waitfor,
};

mig_external boolean_t service_server
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	register mach_msg_header_t *InP =  InHeadP;
	register mig_reply_header_t *OutP = (mig_reply_header_t *) OutHeadP;

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	register mig_routine_t routine;

	OutP->Head.msgh_bits = MACH_MSGH_BITS(MACH_MSGH_BITS_REPLY(InP->msgh_bits), 0);
	OutP->Head.msgh_size = sizeof *OutP;
	OutP->Head.msgh_remote_port = InP->msgh_reply_port;
	OutP->Head.msgh_local_port = MACH_PORT_NULL;
	OutP->Head.msgh_seqno = 0;
	OutP->Head.msgh_id = InP->msgh_id + 100;

#if	UseStaticMsgType
	OutP->RetCodeType = RetCodeType;
#else	UseStaticMsgType
	OutP->RetCodeType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->RetCodeType.msgt_size = 32;
	OutP->RetCodeType.msgt_number = 1;
	OutP->RetCodeType.msgt_inline = TRUE;
	OutP->RetCodeType.msgt_longform = FALSE;
	OutP->RetCodeType.msgt_deallocate = FALSE;
	OutP->RetCodeType.msgt_unused = 0;
#endif	UseStaticMsgType

	if ((InP->msgh_id > 402) || (InP->msgh_id < 400) ||
	    ((routine = service_server_routines[InP->msgh_id - 400]) == 0)) {
		OutP->RetCode = MIG_BAD_ID;
		return FALSE;
	}
	(*routine) (InP, &OutP->Head);
	return TRUE;
}

mig_external mig_routine_t service_server_routine
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP)
#else
	(InHeadP)
	mach_msg_header_t *InHeadP;
#endif
{
	register int msgh_id;

	msgh_id = InHeadP->msgh_id - 400;

	if ((msgh_id > 2) || (msgh_id < 0))
		return 0;

	return service_server_routines[msgh_id];
}

