#include "memory_object_user.h"
#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/notify.h>
#include <mach/mach_types.h>
#include <mach/mig_errors.h>
#include <mach/msg_type.h>
#ifndef	KERNEL
#include <strings.h>
#endif	KERNEL
/* LINTLIBRARY */

extern mach_port_t mig_get_reply_port();
extern void mig_dealloc_reply_port();

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

#define msgh_request_port	msgh_remote_port
#define msgh_reply_port		msgh_local_port


/* SimpleRoutine memory_object_init */
mig_external kern_return_t memory_object_init
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t memory_object,
	mach_port_t memory_control,
	mach_port_t memory_object_name,
	vm_size_t memory_object_page_size
)
#else
	(memory_object, memory_control, memory_object_name, memory_object_page_size)
	mach_port_t memory_object;
	mach_port_t memory_control;
	mach_port_t memory_object_name;
	vm_size_t memory_object_page_size;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t memory_controlType;
		mach_port_t memory_control;
		mach_msg_type_t memory_object_nameType;
		mach_port_t memory_object_name;
		mach_msg_type_t memory_object_page_sizeType;
		vm_size_t memory_object_page_size;
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;


#if	UseStaticMsgType
	static mach_msg_type_t memory_controlType = {
		/* msgt_name = */		20,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t memory_object_nameType = {
		/* msgt_name = */		20,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t memory_object_page_sizeType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->memory_controlType = memory_controlType;
#else	UseStaticMsgType
	InP->memory_controlType.msgt_name = 20;
	InP->memory_controlType.msgt_size = 32;
	InP->memory_controlType.msgt_number = 1;
	InP->memory_controlType.msgt_inline = TRUE;
	InP->memory_controlType.msgt_longform = FALSE;
	InP->memory_controlType.msgt_deallocate = FALSE;
	InP->memory_controlType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->memory_control = memory_control;

#if	UseStaticMsgType
	InP->memory_object_nameType = memory_object_nameType;
#else	UseStaticMsgType
	InP->memory_object_nameType.msgt_name = 20;
	InP->memory_object_nameType.msgt_size = 32;
	InP->memory_object_nameType.msgt_number = 1;
	InP->memory_object_nameType.msgt_inline = TRUE;
	InP->memory_object_nameType.msgt_longform = FALSE;
	InP->memory_object_nameType.msgt_deallocate = FALSE;
	InP->memory_object_nameType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->memory_object_name = memory_object_name;

#if	UseStaticMsgType
	InP->memory_object_page_sizeType = memory_object_page_sizeType;
#else	UseStaticMsgType
	InP->memory_object_page_sizeType.msgt_name = 2;
	InP->memory_object_page_sizeType.msgt_size = 32;
	InP->memory_object_page_sizeType.msgt_number = 1;
	InP->memory_object_page_sizeType.msgt_inline = TRUE;
	InP->memory_object_page_sizeType.msgt_longform = FALSE;
	InP->memory_object_page_sizeType.msgt_deallocate = FALSE;
	InP->memory_object_page_sizeType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->memory_object_page_size = memory_object_page_size;

	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(19, 0);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = memory_object;
	InP->Head.msgh_reply_port = MACH_PORT_NULL;
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 2200;

	return mach_msg(&InP->Head, MACH_SEND_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), 0, MACH_PORT_NULL, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
}

/* SimpleRoutine memory_object_terminate */
mig_external kern_return_t memory_object_terminate
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t memory_object,
	mach_port_t memory_control,
	mach_port_t memory_object_name
)
#else
	(memory_object, memory_control, memory_object_name)
	mach_port_t memory_object;
	mach_port_t memory_control;
	mach_port_t memory_object_name;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t memory_controlType;
		mach_port_t memory_control;
		mach_msg_type_t memory_object_nameType;
		mach_port_t memory_object_name;
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;


#if	UseStaticMsgType
	static mach_msg_type_t memory_controlType = {
		/* msgt_name = */		16,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t memory_object_nameType = {
		/* msgt_name = */		16,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->memory_controlType = memory_controlType;
#else	UseStaticMsgType
	InP->memory_controlType.msgt_name = 16;
	InP->memory_controlType.msgt_size = 32;
	InP->memory_controlType.msgt_number = 1;
	InP->memory_controlType.msgt_inline = TRUE;
	InP->memory_controlType.msgt_longform = FALSE;
	InP->memory_controlType.msgt_deallocate = FALSE;
	InP->memory_controlType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->memory_control = memory_control;

#if	UseStaticMsgType
	InP->memory_object_nameType = memory_object_nameType;
#else	UseStaticMsgType
	InP->memory_object_nameType.msgt_name = 16;
	InP->memory_object_nameType.msgt_size = 32;
	InP->memory_object_nameType.msgt_number = 1;
	InP->memory_object_nameType.msgt_inline = TRUE;
	InP->memory_object_nameType.msgt_longform = FALSE;
	InP->memory_object_nameType.msgt_deallocate = FALSE;
	InP->memory_object_nameType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->memory_object_name = memory_object_name;

	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(17, 0);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = memory_object;
	InP->Head.msgh_reply_port = MACH_PORT_NULL;
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 2201;

	return mach_msg(&InP->Head, MACH_SEND_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), 0, MACH_PORT_NULL, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
}

/* SimpleRoutine memory_object_copy */
mig_external kern_return_t memory_object_copy
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t old_memory_object,
	mach_port_t old_memory_control,
	vm_offset_t offset,
	vm_size_t length,
	mach_port_t new_memory_object
)
#else
	(old_memory_object, old_memory_control, offset, length, new_memory_object)
	mach_port_t old_memory_object;
	mach_port_t old_memory_control;
	vm_offset_t offset;
	vm_size_t length;
	mach_port_t new_memory_object;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t old_memory_controlType;
		mach_port_t old_memory_control;
		mach_msg_type_t offsetType;
		vm_offset_t offset;
		mach_msg_type_t lengthType;
		vm_size_t length;
		mach_msg_type_t new_memory_objectType;
		mach_port_t new_memory_object;
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;


#if	UseStaticMsgType
	static mach_msg_type_t old_memory_controlType = {
		/* msgt_name = */		20,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t offsetType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t lengthType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t new_memory_objectType = {
		/* msgt_name = */		16,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->old_memory_controlType = old_memory_controlType;
#else	UseStaticMsgType
	InP->old_memory_controlType.msgt_name = 20;
	InP->old_memory_controlType.msgt_size = 32;
	InP->old_memory_controlType.msgt_number = 1;
	InP->old_memory_controlType.msgt_inline = TRUE;
	InP->old_memory_controlType.msgt_longform = FALSE;
	InP->old_memory_controlType.msgt_deallocate = FALSE;
	InP->old_memory_controlType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->old_memory_control = old_memory_control;

#if	UseStaticMsgType
	InP->offsetType = offsetType;
#else	UseStaticMsgType
	InP->offsetType.msgt_name = 2;
	InP->offsetType.msgt_size = 32;
	InP->offsetType.msgt_number = 1;
	InP->offsetType.msgt_inline = TRUE;
	InP->offsetType.msgt_longform = FALSE;
	InP->offsetType.msgt_deallocate = FALSE;
	InP->offsetType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->offset = offset;

#if	UseStaticMsgType
	InP->lengthType = lengthType;
#else	UseStaticMsgType
	InP->lengthType.msgt_name = 2;
	InP->lengthType.msgt_size = 32;
	InP->lengthType.msgt_number = 1;
	InP->lengthType.msgt_inline = TRUE;
	InP->lengthType.msgt_longform = FALSE;
	InP->lengthType.msgt_deallocate = FALSE;
	InP->lengthType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->length = length;

#if	UseStaticMsgType
	InP->new_memory_objectType = new_memory_objectType;
#else	UseStaticMsgType
	InP->new_memory_objectType.msgt_name = 16;
	InP->new_memory_objectType.msgt_size = 32;
	InP->new_memory_objectType.msgt_number = 1;
	InP->new_memory_objectType.msgt_inline = TRUE;
	InP->new_memory_objectType.msgt_longform = FALSE;
	InP->new_memory_objectType.msgt_deallocate = FALSE;
	InP->new_memory_objectType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->new_memory_object = new_memory_object;

	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(19, 0);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = old_memory_object;
	InP->Head.msgh_reply_port = MACH_PORT_NULL;
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 2202;

	return mach_msg(&InP->Head, MACH_SEND_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), 0, MACH_PORT_NULL, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
}

/* SimpleRoutine memory_object_data_request */
mig_external kern_return_t memory_object_data_request
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t memory_object,
	mach_port_t memory_control,
	vm_offset_t offset,
	vm_size_t length,
	vm_prot_t desired_access
)
#else
	(memory_object, memory_control, offset, length, desired_access)
	mach_port_t memory_object;
	mach_port_t memory_control;
	vm_offset_t offset;
	vm_size_t length;
	vm_prot_t desired_access;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t memory_controlType;
		mach_port_t memory_control;
		mach_msg_type_t offsetType;
		vm_offset_t offset;
		mach_msg_type_t lengthType;
		vm_size_t length;
		mach_msg_type_t desired_accessType;
		vm_prot_t desired_access;
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;


#if	UseStaticMsgType
	static mach_msg_type_t memory_controlType = {
		/* msgt_name = */		20,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t offsetType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t lengthType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t desired_accessType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->memory_controlType = memory_controlType;
#else	UseStaticMsgType
	InP->memory_controlType.msgt_name = 20;
	InP->memory_controlType.msgt_size = 32;
	InP->memory_controlType.msgt_number = 1;
	InP->memory_controlType.msgt_inline = TRUE;
	InP->memory_controlType.msgt_longform = FALSE;
	InP->memory_controlType.msgt_deallocate = FALSE;
	InP->memory_controlType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->memory_control = memory_control;

#if	UseStaticMsgType
	InP->offsetType = offsetType;
#else	UseStaticMsgType
	InP->offsetType.msgt_name = 2;
	InP->offsetType.msgt_size = 32;
	InP->offsetType.msgt_number = 1;
	InP->offsetType.msgt_inline = TRUE;
	InP->offsetType.msgt_longform = FALSE;
	InP->offsetType.msgt_deallocate = FALSE;
	InP->offsetType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->offset = offset;

#if	UseStaticMsgType
	InP->lengthType = lengthType;
#else	UseStaticMsgType
	InP->lengthType.msgt_name = 2;
	InP->lengthType.msgt_size = 32;
	InP->lengthType.msgt_number = 1;
	InP->lengthType.msgt_inline = TRUE;
	InP->lengthType.msgt_longform = FALSE;
	InP->lengthType.msgt_deallocate = FALSE;
	InP->lengthType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->length = length;

#if	UseStaticMsgType
	InP->desired_accessType = desired_accessType;
#else	UseStaticMsgType
	InP->desired_accessType.msgt_name = 2;
	InP->desired_accessType.msgt_size = 32;
	InP->desired_accessType.msgt_number = 1;
	InP->desired_accessType.msgt_inline = TRUE;
	InP->desired_accessType.msgt_longform = FALSE;
	InP->desired_accessType.msgt_deallocate = FALSE;
	InP->desired_accessType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->desired_access = desired_access;

	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(19, 0);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = memory_object;
	InP->Head.msgh_reply_port = MACH_PORT_NULL;
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 2203;

	return mach_msg(&InP->Head, MACH_SEND_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), 0, MACH_PORT_NULL, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
}

/* SimpleRoutine memory_object_data_unlock */
mig_external kern_return_t memory_object_data_unlock
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t memory_object,
	mach_port_t memory_control,
	vm_offset_t offset,
	vm_size_t length,
	vm_prot_t desired_access
)
#else
	(memory_object, memory_control, offset, length, desired_access)
	mach_port_t memory_object;
	mach_port_t memory_control;
	vm_offset_t offset;
	vm_size_t length;
	vm_prot_t desired_access;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t memory_controlType;
		mach_port_t memory_control;
		mach_msg_type_t offsetType;
		vm_offset_t offset;
		mach_msg_type_t lengthType;
		vm_size_t length;
		mach_msg_type_t desired_accessType;
		vm_prot_t desired_access;
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;


#if	UseStaticMsgType
	static mach_msg_type_t memory_controlType = {
		/* msgt_name = */		20,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t offsetType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t lengthType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t desired_accessType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->memory_controlType = memory_controlType;
#else	UseStaticMsgType
	InP->memory_controlType.msgt_name = 20;
	InP->memory_controlType.msgt_size = 32;
	InP->memory_controlType.msgt_number = 1;
	InP->memory_controlType.msgt_inline = TRUE;
	InP->memory_controlType.msgt_longform = FALSE;
	InP->memory_controlType.msgt_deallocate = FALSE;
	InP->memory_controlType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->memory_control = memory_control;

#if	UseStaticMsgType
	InP->offsetType = offsetType;
#else	UseStaticMsgType
	InP->offsetType.msgt_name = 2;
	InP->offsetType.msgt_size = 32;
	InP->offsetType.msgt_number = 1;
	InP->offsetType.msgt_inline = TRUE;
	InP->offsetType.msgt_longform = FALSE;
	InP->offsetType.msgt_deallocate = FALSE;
	InP->offsetType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->offset = offset;

#if	UseStaticMsgType
	InP->lengthType = lengthType;
#else	UseStaticMsgType
	InP->lengthType.msgt_name = 2;
	InP->lengthType.msgt_size = 32;
	InP->lengthType.msgt_number = 1;
	InP->lengthType.msgt_inline = TRUE;
	InP->lengthType.msgt_longform = FALSE;
	InP->lengthType.msgt_deallocate = FALSE;
	InP->lengthType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->length = length;

#if	UseStaticMsgType
	InP->desired_accessType = desired_accessType;
#else	UseStaticMsgType
	InP->desired_accessType.msgt_name = 2;
	InP->desired_accessType.msgt_size = 32;
	InP->desired_accessType.msgt_number = 1;
	InP->desired_accessType.msgt_inline = TRUE;
	InP->desired_accessType.msgt_longform = FALSE;
	InP->desired_accessType.msgt_deallocate = FALSE;
	InP->desired_accessType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->desired_access = desired_access;

	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(19, 0);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = memory_object;
	InP->Head.msgh_reply_port = MACH_PORT_NULL;
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 2204;

	return mach_msg(&InP->Head, MACH_SEND_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), 0, MACH_PORT_NULL, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
}

/* SimpleRoutine memory_object_data_write */
mig_external kern_return_t memory_object_data_write
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t memory_object,
	mach_port_t memory_control,
	vm_offset_t offset,
	vm_offset_t data,
	mach_msg_type_number_t dataCnt
)
#else
	(memory_object, memory_control, offset, data, dataCnt)
	mach_port_t memory_object;
	mach_port_t memory_control;
	vm_offset_t offset;
	vm_offset_t data;
	mach_msg_type_number_t dataCnt;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t memory_controlType;
		mach_port_t memory_control;
		mach_msg_type_t offsetType;
		vm_offset_t offset;
		mach_msg_type_long_t dataType;
		vm_offset_t data;
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;


#if	UseStaticMsgType
	static mach_msg_type_t memory_controlType = {
		/* msgt_name = */		20,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t offsetType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t dataType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		FALSE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	9,
		/* msgtl_size = */	8,
		/* msgtl_number = */	0,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->memory_controlType = memory_controlType;
#else	UseStaticMsgType
	InP->memory_controlType.msgt_name = 20;
	InP->memory_controlType.msgt_size = 32;
	InP->memory_controlType.msgt_number = 1;
	InP->memory_controlType.msgt_inline = TRUE;
	InP->memory_controlType.msgt_longform = FALSE;
	InP->memory_controlType.msgt_deallocate = FALSE;
	InP->memory_controlType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->memory_control = memory_control;

#if	UseStaticMsgType
	InP->offsetType = offsetType;
#else	UseStaticMsgType
	InP->offsetType.msgt_name = 2;
	InP->offsetType.msgt_size = 32;
	InP->offsetType.msgt_number = 1;
	InP->offsetType.msgt_inline = TRUE;
	InP->offsetType.msgt_longform = FALSE;
	InP->offsetType.msgt_deallocate = FALSE;
	InP->offsetType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->offset = offset;

#if	UseStaticMsgType
	InP->dataType = dataType;
#else	UseStaticMsgType
	InP->dataType.msgtl_name = 9;
	InP->dataType.msgtl_size = 8;
	InP->dataType.msgtl_header.msgt_name = 0;
	InP->dataType.msgtl_header.msgt_size = 0;
	InP->dataType.msgtl_header.msgt_number = 0;
	InP->dataType.msgtl_header.msgt_inline = FALSE;
	InP->dataType.msgtl_header.msgt_longform = TRUE;
	InP->dataType.msgtl_header.msgt_deallocate = FALSE;
	InP->dataType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->data = data;

	InP->dataType.msgtl_number = dataCnt;

	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(19, 0);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = memory_object;
	InP->Head.msgh_reply_port = MACH_PORT_NULL;
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 2205;

	return mach_msg(&InP->Head, MACH_SEND_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), 0, MACH_PORT_NULL, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
}

/* SimpleRoutine memory_object_lock_completed */
mig_external kern_return_t memory_object_lock_completed
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t memory_object,
	mach_msg_type_name_t memory_objectPoly,
	mach_port_t memory_control,
	vm_offset_t offset,
	vm_size_t length
)
#else
	(memory_object, memory_objectPoly, memory_control, offset, length)
	mach_port_t memory_object;
	mach_msg_type_name_t memory_objectPoly;
	mach_port_t memory_control;
	vm_offset_t offset;
	vm_size_t length;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t memory_controlType;
		mach_port_t memory_control;
		mach_msg_type_t offsetType;
		vm_offset_t offset;
		mach_msg_type_t lengthType;
		vm_size_t length;
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;


#if	UseStaticMsgType
	static mach_msg_type_t memory_controlType = {
		/* msgt_name = */		20,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t offsetType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t lengthType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->memory_controlType = memory_controlType;
#else	UseStaticMsgType
	InP->memory_controlType.msgt_name = 20;
	InP->memory_controlType.msgt_size = 32;
	InP->memory_controlType.msgt_number = 1;
	InP->memory_controlType.msgt_inline = TRUE;
	InP->memory_controlType.msgt_longform = FALSE;
	InP->memory_controlType.msgt_deallocate = FALSE;
	InP->memory_controlType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->memory_control = memory_control;

#if	UseStaticMsgType
	InP->offsetType = offsetType;
#else	UseStaticMsgType
	InP->offsetType.msgt_name = 2;
	InP->offsetType.msgt_size = 32;
	InP->offsetType.msgt_number = 1;
	InP->offsetType.msgt_inline = TRUE;
	InP->offsetType.msgt_longform = FALSE;
	InP->offsetType.msgt_deallocate = FALSE;
	InP->offsetType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->offset = offset;

#if	UseStaticMsgType
	InP->lengthType = lengthType;
#else	UseStaticMsgType
	InP->lengthType.msgt_name = 2;
	InP->lengthType.msgt_size = 32;
	InP->lengthType.msgt_number = 1;
	InP->lengthType.msgt_inline = TRUE;
	InP->lengthType.msgt_longform = FALSE;
	InP->lengthType.msgt_deallocate = FALSE;
	InP->lengthType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->length = length;

	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(memory_objectPoly, 0);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = memory_object;
	InP->Head.msgh_reply_port = MACH_PORT_NULL;
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 2206;

	return mach_msg(&InP->Head, MACH_SEND_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), 0, MACH_PORT_NULL, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
}

/* SimpleRoutine memory_object_supply_completed */
mig_external kern_return_t memory_object_supply_completed
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t memory_object,
	mach_msg_type_name_t memory_objectPoly,
	mach_port_t memory_control,
	vm_offset_t offset,
	vm_size_t length,
	kern_return_t result,
	vm_offset_t error_offset
)
#else
	(memory_object, memory_objectPoly, memory_control, offset, length, result, error_offset)
	mach_port_t memory_object;
	mach_msg_type_name_t memory_objectPoly;
	mach_port_t memory_control;
	vm_offset_t offset;
	vm_size_t length;
	kern_return_t result;
	vm_offset_t error_offset;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t memory_controlType;
		mach_port_t memory_control;
		mach_msg_type_t offsetType;
		vm_offset_t offset;
		mach_msg_type_t lengthType;
		vm_size_t length;
		mach_msg_type_t resultType;
		kern_return_t result;
		mach_msg_type_t error_offsetType;
		vm_offset_t error_offset;
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;


#if	UseStaticMsgType
	static mach_msg_type_t memory_controlType = {
		/* msgt_name = */		20,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t offsetType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t lengthType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t resultType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t error_offsetType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->memory_controlType = memory_controlType;
#else	UseStaticMsgType
	InP->memory_controlType.msgt_name = 20;
	InP->memory_controlType.msgt_size = 32;
	InP->memory_controlType.msgt_number = 1;
	InP->memory_controlType.msgt_inline = TRUE;
	InP->memory_controlType.msgt_longform = FALSE;
	InP->memory_controlType.msgt_deallocate = FALSE;
	InP->memory_controlType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->memory_control = memory_control;

#if	UseStaticMsgType
	InP->offsetType = offsetType;
#else	UseStaticMsgType
	InP->offsetType.msgt_name = 2;
	InP->offsetType.msgt_size = 32;
	InP->offsetType.msgt_number = 1;
	InP->offsetType.msgt_inline = TRUE;
	InP->offsetType.msgt_longform = FALSE;
	InP->offsetType.msgt_deallocate = FALSE;
	InP->offsetType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->offset = offset;

#if	UseStaticMsgType
	InP->lengthType = lengthType;
#else	UseStaticMsgType
	InP->lengthType.msgt_name = 2;
	InP->lengthType.msgt_size = 32;
	InP->lengthType.msgt_number = 1;
	InP->lengthType.msgt_inline = TRUE;
	InP->lengthType.msgt_longform = FALSE;
	InP->lengthType.msgt_deallocate = FALSE;
	InP->lengthType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->length = length;

#if	UseStaticMsgType
	InP->resultType = resultType;
#else	UseStaticMsgType
	InP->resultType.msgt_name = 2;
	InP->resultType.msgt_size = 32;
	InP->resultType.msgt_number = 1;
	InP->resultType.msgt_inline = TRUE;
	InP->resultType.msgt_longform = FALSE;
	InP->resultType.msgt_deallocate = FALSE;
	InP->resultType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->result = result;

#if	UseStaticMsgType
	InP->error_offsetType = error_offsetType;
#else	UseStaticMsgType
	InP->error_offsetType.msgt_name = 2;
	InP->error_offsetType.msgt_size = 32;
	InP->error_offsetType.msgt_number = 1;
	InP->error_offsetType.msgt_inline = TRUE;
	InP->error_offsetType.msgt_longform = FALSE;
	InP->error_offsetType.msgt_deallocate = FALSE;
	InP->error_offsetType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->error_offset = error_offset;

	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(memory_objectPoly, 0);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = memory_object;
	InP->Head.msgh_reply_port = MACH_PORT_NULL;
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 2207;

	return mach_msg(&InP->Head, MACH_SEND_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), 0, MACH_PORT_NULL, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
}

/* SimpleRoutine memory_object_data_return */
mig_external kern_return_t memory_object_data_return
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t memory_object,
	mach_port_t memory_control,
	vm_offset_t offset,
	vm_offset_t data,
	mach_msg_type_number_t dataCnt,
	boolean_t dirty,
	boolean_t kernel_copy
)
#else
	(memory_object, memory_control, offset, data, dataCnt, dirty, kernel_copy)
	mach_port_t memory_object;
	mach_port_t memory_control;
	vm_offset_t offset;
	vm_offset_t data;
	mach_msg_type_number_t dataCnt;
	boolean_t dirty;
	boolean_t kernel_copy;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t memory_controlType;
		mach_port_t memory_control;
		mach_msg_type_t offsetType;
		vm_offset_t offset;
		mach_msg_type_long_t dataType;
		vm_offset_t data;
		mach_msg_type_t dirtyType;
		boolean_t dirty;
		mach_msg_type_t kernel_copyType;
		boolean_t kernel_copy;
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;


#if	UseStaticMsgType
	static mach_msg_type_t memory_controlType = {
		/* msgt_name = */		20,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t offsetType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t dataType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		FALSE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	9,
		/* msgtl_size = */	8,
		/* msgtl_number = */	0,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t dirtyType = {
		/* msgt_name = */		0,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t kernel_copyType = {
		/* msgt_name = */		0,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->memory_controlType = memory_controlType;
#else	UseStaticMsgType
	InP->memory_controlType.msgt_name = 20;
	InP->memory_controlType.msgt_size = 32;
	InP->memory_controlType.msgt_number = 1;
	InP->memory_controlType.msgt_inline = TRUE;
	InP->memory_controlType.msgt_longform = FALSE;
	InP->memory_controlType.msgt_deallocate = FALSE;
	InP->memory_controlType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->memory_control = memory_control;

#if	UseStaticMsgType
	InP->offsetType = offsetType;
#else	UseStaticMsgType
	InP->offsetType.msgt_name = 2;
	InP->offsetType.msgt_size = 32;
	InP->offsetType.msgt_number = 1;
	InP->offsetType.msgt_inline = TRUE;
	InP->offsetType.msgt_longform = FALSE;
	InP->offsetType.msgt_deallocate = FALSE;
	InP->offsetType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->offset = offset;

#if	UseStaticMsgType
	InP->dataType = dataType;
#else	UseStaticMsgType
	InP->dataType.msgtl_name = 9;
	InP->dataType.msgtl_size = 8;
	InP->dataType.msgtl_header.msgt_name = 0;
	InP->dataType.msgtl_header.msgt_size = 0;
	InP->dataType.msgtl_header.msgt_number = 0;
	InP->dataType.msgtl_header.msgt_inline = FALSE;
	InP->dataType.msgtl_header.msgt_longform = TRUE;
	InP->dataType.msgtl_header.msgt_deallocate = FALSE;
	InP->dataType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->data = data;

	InP->dataType.msgtl_number = dataCnt;

#if	UseStaticMsgType
	InP->dirtyType = dirtyType;
#else	UseStaticMsgType
	InP->dirtyType.msgt_name = 0;
	InP->dirtyType.msgt_size = 32;
	InP->dirtyType.msgt_number = 1;
	InP->dirtyType.msgt_inline = TRUE;
	InP->dirtyType.msgt_longform = FALSE;
	InP->dirtyType.msgt_deallocate = FALSE;
	InP->dirtyType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->dirty = dirty;

#if	UseStaticMsgType
	InP->kernel_copyType = kernel_copyType;
#else	UseStaticMsgType
	InP->kernel_copyType.msgt_name = 0;
	InP->kernel_copyType.msgt_size = 32;
	InP->kernel_copyType.msgt_number = 1;
	InP->kernel_copyType.msgt_inline = TRUE;
	InP->kernel_copyType.msgt_longform = FALSE;
	InP->kernel_copyType.msgt_deallocate = FALSE;
	InP->kernel_copyType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->kernel_copy = kernel_copy;

	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(19, 0);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = memory_object;
	InP->Head.msgh_reply_port = MACH_PORT_NULL;
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 2208;

	return mach_msg(&InP->Head, MACH_SEND_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), 0, MACH_PORT_NULL, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
}

/* SimpleRoutine memory_object_change_completed */
mig_external kern_return_t memory_object_change_completed
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t memory_object,
	mach_msg_type_name_t memory_objectPoly,
	boolean_t may_cache,
	memory_object_copy_strategy_t copy_strategy
)
#else
	(memory_object, memory_objectPoly, may_cache, copy_strategy)
	mach_port_t memory_object;
	mach_msg_type_name_t memory_objectPoly;
	boolean_t may_cache;
	memory_object_copy_strategy_t copy_strategy;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t may_cacheType;
		boolean_t may_cache;
		mach_msg_type_t copy_strategyType;
		memory_object_copy_strategy_t copy_strategy;
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;


#if	UseStaticMsgType
	static mach_msg_type_t may_cacheType = {
		/* msgt_name = */		0,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t copy_strategyType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->may_cacheType = may_cacheType;
#else	UseStaticMsgType
	InP->may_cacheType.msgt_name = 0;
	InP->may_cacheType.msgt_size = 32;
	InP->may_cacheType.msgt_number = 1;
	InP->may_cacheType.msgt_inline = TRUE;
	InP->may_cacheType.msgt_longform = FALSE;
	InP->may_cacheType.msgt_deallocate = FALSE;
	InP->may_cacheType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->may_cache = may_cache;

#if	UseStaticMsgType
	InP->copy_strategyType = copy_strategyType;
#else	UseStaticMsgType
	InP->copy_strategyType.msgt_name = 2;
	InP->copy_strategyType.msgt_size = 32;
	InP->copy_strategyType.msgt_number = 1;
	InP->copy_strategyType.msgt_inline = TRUE;
	InP->copy_strategyType.msgt_longform = FALSE;
	InP->copy_strategyType.msgt_deallocate = FALSE;
	InP->copy_strategyType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->copy_strategy = copy_strategy;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(memory_objectPoly, 0);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = memory_object;
	InP->Head.msgh_reply_port = MACH_PORT_NULL;
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 2209;

	return mach_msg(&InP->Head, MACH_SEND_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), 0, MACH_PORT_NULL, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
}
