/* Module mach */

#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/mig_errors.h>

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

/* Due to pcc compiler bug, cannot use void */
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(hc)
#define novalue void
#else
#define novalue int
#endif

#define msgh_request_port	msgh_local_port
#define MACH_MSGH_BITS_REQUEST(bits)	MACH_MSGH_BITS_LOCAL(bits)
#define msgh_reply_port		msgh_remote_port
#define MACH_MSGH_BITS_REPLY(bits)	MACH_MSGH_BITS_REMOTE(bits)

#include <mach/std_types.h>
#include <mach/mach_types.h>

/* Routine task_create */
mig_internal novalue _Xtask_create
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t inherit_memoryType;
		boolean_t inherit_memory;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t child_taskType;
		mach_port_t child_task;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t task_create
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_task, boolean_t inherit_memory, mach_port_t *child_task);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t inherit_memoryCheck = {
		/* msgt_name = */		0,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t child_taskType = {
		/* msgt_name = */		19,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->inherit_memoryType != * (int *) &inherit_memoryCheck)
#else	UseStaticMsgType
	if ((In0P->inherit_memoryType.msgt_inline != TRUE) ||
	    (In0P->inherit_memoryType.msgt_longform != FALSE) ||
	    (In0P->inherit_memoryType.msgt_name != 0) ||
	    (In0P->inherit_memoryType.msgt_number != 1) ||
	    (In0P->inherit_memoryType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = task_create(In0P->Head.msgh_request_port, In0P->inherit_memory, &OutP->child_task);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->child_taskType = child_taskType;
#else	UseStaticMsgType
	OutP->child_taskType.msgt_name = 19;
	OutP->child_taskType.msgt_size = 32;
	OutP->child_taskType.msgt_number = 1;
	OutP->child_taskType.msgt_inline = TRUE;
	OutP->child_taskType.msgt_longform = FALSE;
	OutP->child_taskType.msgt_deallocate = FALSE;
	OutP->child_taskType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine task_terminate */
mig_internal novalue _Xtask_terminate
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t task_terminate
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_task);
#else
		();
#endif

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = task_terminate(In0P->Head.msgh_request_port);
}

/* Routine task_get_emulation_vector */
mig_internal novalue _Xtask_get_emulation_vector
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t vector_startType;
		int vector_start;
		mach_msg_type_long_t emulation_vectorType;
		emulation_vector_t emulation_vector;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t task_get_emulation_vector
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t task, int *vector_start, emulation_vector_t *emulation_vector, mach_msg_type_number_t *emulation_vectorCnt);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t vector_startType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t emulation_vectorType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		FALSE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	2,
		/* msgtl_size = */	32,
		/* msgtl_number = */	0,
	};
#endif	UseStaticMsgType

	mach_msg_type_number_t emulation_vectorCnt;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = task_get_emulation_vector(In0P->Head.msgh_request_port, &OutP->vector_start, &OutP->emulation_vector, &emulation_vectorCnt);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 56;

#if	UseStaticMsgType
	OutP->vector_startType = vector_startType;
#else	UseStaticMsgType
	OutP->vector_startType.msgt_name = 2;
	OutP->vector_startType.msgt_size = 32;
	OutP->vector_startType.msgt_number = 1;
	OutP->vector_startType.msgt_inline = TRUE;
	OutP->vector_startType.msgt_longform = FALSE;
	OutP->vector_startType.msgt_deallocate = FALSE;
	OutP->vector_startType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->emulation_vectorType = emulation_vectorType;
#else	UseStaticMsgType
	OutP->emulation_vectorType.msgtl_name = 2;
	OutP->emulation_vectorType.msgtl_size = 32;
	OutP->emulation_vectorType.msgtl_header.msgt_name = 0;
	OutP->emulation_vectorType.msgtl_header.msgt_size = 0;
	OutP->emulation_vectorType.msgtl_header.msgt_number = 0;
	OutP->emulation_vectorType.msgtl_header.msgt_inline = FALSE;
	OutP->emulation_vectorType.msgtl_header.msgt_longform = TRUE;
	OutP->emulation_vectorType.msgtl_header.msgt_deallocate = FALSE;
	OutP->emulation_vectorType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType

	OutP->emulation_vectorType.msgtl_number = emulation_vectorCnt;
}

/* Routine task_set_emulation_vector */
mig_internal novalue _Xtask_set_emulation_vector
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t vector_startType;
		int vector_start;
		mach_msg_type_long_t emulation_vectorType;
		emulation_vector_t emulation_vector;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t task_set_emulation_vector
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t task, int vector_start, emulation_vector_t emulation_vector, mach_msg_type_number_t emulation_vectorCnt);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t vector_startCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 48) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->vector_startType != * (int *) &vector_startCheck)
#else	UseStaticMsgType
	if ((In0P->vector_startType.msgt_inline != TRUE) ||
	    (In0P->vector_startType.msgt_longform != FALSE) ||
	    (In0P->vector_startType.msgt_name != 2) ||
	    (In0P->vector_startType.msgt_number != 1) ||
	    (In0P->vector_startType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if ((In0P->emulation_vectorType.msgtl_header.msgt_inline != FALSE) ||
	    (In0P->emulation_vectorType.msgtl_header.msgt_longform != TRUE) ||
	    (In0P->emulation_vectorType.msgtl_name != 2) ||
	    (In0P->emulation_vectorType.msgtl_size != 32))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = task_set_emulation_vector(In0P->Head.msgh_request_port, In0P->vector_start, In0P->emulation_vector, In0P->emulation_vectorType.msgtl_number);
}

/* Routine task_threads */
mig_internal novalue _Xtask_threads
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_long_t thread_listType;
		thread_array_t thread_list;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t task_threads
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_task, thread_array_t *thread_list, mach_msg_type_number_t *thread_listCnt);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_long_t thread_listType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		FALSE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	19,
		/* msgtl_size = */	32,
		/* msgtl_number = */	0,
	};
#endif	UseStaticMsgType

	mach_msg_type_number_t thread_listCnt;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = task_threads(In0P->Head.msgh_request_port, &OutP->thread_list, &thread_listCnt);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 48;

#if	UseStaticMsgType
	OutP->thread_listType = thread_listType;
#else	UseStaticMsgType
	OutP->thread_listType.msgtl_name = 19;
	OutP->thread_listType.msgtl_size = 32;
	OutP->thread_listType.msgtl_header.msgt_name = 0;
	OutP->thread_listType.msgtl_header.msgt_size = 0;
	OutP->thread_listType.msgtl_header.msgt_number = 0;
	OutP->thread_listType.msgtl_header.msgt_inline = FALSE;
	OutP->thread_listType.msgtl_header.msgt_longform = TRUE;
	OutP->thread_listType.msgtl_header.msgt_deallocate = FALSE;
	OutP->thread_listType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType

	OutP->thread_listType.msgtl_number = thread_listCnt;
}

/* Routine task_info */
mig_internal novalue _Xtask_info
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t flavorType;
		int flavor;
		mach_msg_type_t task_info_outCntType;
		mach_msg_type_number_t task_info_outCnt;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t task_info_outType;
		int task_info_out[1024];
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t task_info
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_task, int flavor, task_info_t task_info_out, mach_msg_type_number_t *task_info_outCnt);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t flavorCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t task_info_outCntCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t task_info_outType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1024,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	mach_msg_type_number_t task_info_outCnt;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->flavorType != * (int *) &flavorCheck)
#else	UseStaticMsgType
	if ((In0P->flavorType.msgt_inline != TRUE) ||
	    (In0P->flavorType.msgt_longform != FALSE) ||
	    (In0P->flavorType.msgt_name != 2) ||
	    (In0P->flavorType.msgt_number != 1) ||
	    (In0P->flavorType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->task_info_outCntType != * (int *) &task_info_outCntCheck)
#else	UseStaticMsgType
	if ((In0P->task_info_outCntType.msgt_inline != TRUE) ||
	    (In0P->task_info_outCntType.msgt_longform != FALSE) ||
	    (In0P->task_info_outCntType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->task_info_outCntType.msgt_number != 1) ||
	    (In0P->task_info_outCntType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	task_info_outCnt = 1024;
	if (In0P->task_info_outCnt < task_info_outCnt)
		task_info_outCnt = In0P->task_info_outCnt;

	OutP->RetCode = task_info(In0P->Head.msgh_request_port, In0P->flavor, OutP->task_info_out, &task_info_outCnt);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

#if	UseStaticMsgType
	OutP->task_info_outType = task_info_outType;
#else	UseStaticMsgType
	OutP->task_info_outType.msgt_name = 2;
	OutP->task_info_outType.msgt_size = 32;
	OutP->task_info_outType.msgt_inline = TRUE;
	OutP->task_info_outType.msgt_longform = FALSE;
	OutP->task_info_outType.msgt_deallocate = FALSE;
	OutP->task_info_outType.msgt_unused = 0;
#endif	UseStaticMsgType

	OutP->task_info_outType.msgt_number = task_info_outCnt;
	OutP->Head.msgh_size = 36 + (4 * task_info_outCnt);
}

/* Routine thread_terminate */
mig_internal novalue _Xthread_terminate
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t thread_terminate
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_thread);
#else
		();
#endif

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = thread_terminate(In0P->Head.msgh_request_port);
}

/* Routine thread_get_state */
mig_internal novalue _Xthread_get_state
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t flavorType;
		int flavor;
		mach_msg_type_t old_stateCntType;
		mach_msg_type_number_t old_stateCnt;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t old_stateType;
		int old_state[1024];
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t thread_get_state
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_thread, int flavor, thread_state_t old_state, mach_msg_type_number_t *old_stateCnt);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t flavorCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t old_stateCntCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t old_stateType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1024,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	mach_msg_type_number_t old_stateCnt;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->flavorType != * (int *) &flavorCheck)
#else	UseStaticMsgType
	if ((In0P->flavorType.msgt_inline != TRUE) ||
	    (In0P->flavorType.msgt_longform != FALSE) ||
	    (In0P->flavorType.msgt_name != 2) ||
	    (In0P->flavorType.msgt_number != 1) ||
	    (In0P->flavorType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->old_stateCntType != * (int *) &old_stateCntCheck)
#else	UseStaticMsgType
	if ((In0P->old_stateCntType.msgt_inline != TRUE) ||
	    (In0P->old_stateCntType.msgt_longform != FALSE) ||
	    (In0P->old_stateCntType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->old_stateCntType.msgt_number != 1) ||
	    (In0P->old_stateCntType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	old_stateCnt = 1024;
	if (In0P->old_stateCnt < old_stateCnt)
		old_stateCnt = In0P->old_stateCnt;

	OutP->RetCode = thread_get_state(In0P->Head.msgh_request_port, In0P->flavor, OutP->old_state, &old_stateCnt);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

#if	UseStaticMsgType
	OutP->old_stateType = old_stateType;
#else	UseStaticMsgType
	OutP->old_stateType.msgt_name = 2;
	OutP->old_stateType.msgt_size = 32;
	OutP->old_stateType.msgt_inline = TRUE;
	OutP->old_stateType.msgt_longform = FALSE;
	OutP->old_stateType.msgt_deallocate = FALSE;
	OutP->old_stateType.msgt_unused = 0;
#endif	UseStaticMsgType

	OutP->old_stateType.msgt_number = old_stateCnt;
	OutP->Head.msgh_size = 36 + (4 * old_stateCnt);
}

/* Routine thread_set_state */
mig_internal novalue _Xthread_set_state
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t flavorType;
		int flavor;
		mach_msg_type_t new_stateType;
		int new_state[1024];
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t thread_set_state
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_thread, int flavor, thread_state_t new_state, mach_msg_type_number_t new_stateCnt);
#else
		();
#endif

	unsigned int msgh_size;

#if	UseStaticMsgType
	static mach_msg_type_t flavorCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	msgh_size = In0P->Head.msgh_size;
	if ((msgh_size < 36) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->flavorType != * (int *) &flavorCheck)
#else	UseStaticMsgType
	if ((In0P->flavorType.msgt_inline != TRUE) ||
	    (In0P->flavorType.msgt_longform != FALSE) ||
	    (In0P->flavorType.msgt_name != 2) ||
	    (In0P->flavorType.msgt_number != 1) ||
	    (In0P->flavorType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if ((In0P->new_stateType.msgt_inline != TRUE) ||
	    (In0P->new_stateType.msgt_longform != FALSE) ||
	    (In0P->new_stateType.msgt_name != 2) ||
	    (In0P->new_stateType.msgt_size != 32))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if (msgh_size != 36 + (4 * In0P->new_stateType.msgt_number))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = thread_set_state(In0P->Head.msgh_request_port, In0P->flavor, In0P->new_state, In0P->new_stateType.msgt_number);
}

/* Routine thread_info */
mig_internal novalue _Xthread_info
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t flavorType;
		int flavor;
		mach_msg_type_t thread_info_outCntType;
		mach_msg_type_number_t thread_info_outCnt;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t thread_info_outType;
		int thread_info_out[1024];
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t thread_info
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_thread, int flavor, thread_info_t thread_info_out, mach_msg_type_number_t *thread_info_outCnt);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t flavorCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t thread_info_outCntCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t thread_info_outType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1024,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	mach_msg_type_number_t thread_info_outCnt;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->flavorType != * (int *) &flavorCheck)
#else	UseStaticMsgType
	if ((In0P->flavorType.msgt_inline != TRUE) ||
	    (In0P->flavorType.msgt_longform != FALSE) ||
	    (In0P->flavorType.msgt_name != 2) ||
	    (In0P->flavorType.msgt_number != 1) ||
	    (In0P->flavorType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->thread_info_outCntType != * (int *) &thread_info_outCntCheck)
#else	UseStaticMsgType
	if ((In0P->thread_info_outCntType.msgt_inline != TRUE) ||
	    (In0P->thread_info_outCntType.msgt_longform != FALSE) ||
	    (In0P->thread_info_outCntType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->thread_info_outCntType.msgt_number != 1) ||
	    (In0P->thread_info_outCntType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	thread_info_outCnt = 1024;
	if (In0P->thread_info_outCnt < thread_info_outCnt)
		thread_info_outCnt = In0P->thread_info_outCnt;

	OutP->RetCode = thread_info(In0P->Head.msgh_request_port, In0P->flavor, OutP->thread_info_out, &thread_info_outCnt);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

#if	UseStaticMsgType
	OutP->thread_info_outType = thread_info_outType;
#else	UseStaticMsgType
	OutP->thread_info_outType.msgt_name = 2;
	OutP->thread_info_outType.msgt_size = 32;
	OutP->thread_info_outType.msgt_inline = TRUE;
	OutP->thread_info_outType.msgt_longform = FALSE;
	OutP->thread_info_outType.msgt_deallocate = FALSE;
	OutP->thread_info_outType.msgt_unused = 0;
#endif	UseStaticMsgType

	OutP->thread_info_outType.msgt_number = thread_info_outCnt;
	OutP->Head.msgh_size = 36 + (4 * thread_info_outCnt);
}

/* Routine vm_allocate */
mig_internal novalue _Xvm_allocate
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t addressType;
		vm_address_t address;
		mach_msg_type_t sizeType;
		vm_size_t size;
		mach_msg_type_t anywhereType;
		boolean_t anywhere;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t addressType;
		vm_address_t address;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t vm_allocate
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_task, vm_address_t *address, vm_size_t size, boolean_t anywhere);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t addressCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t sizeCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t anywhereCheck = {
		/* msgt_name = */		0,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t addressType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 48) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->addressType != * (int *) &addressCheck)
#else	UseStaticMsgType
	if ((In0P->addressType.msgt_inline != TRUE) ||
	    (In0P->addressType.msgt_longform != FALSE) ||
	    (In0P->addressType.msgt_name != 2) ||
	    (In0P->addressType.msgt_number != 1) ||
	    (In0P->addressType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->sizeType != * (int *) &sizeCheck)
#else	UseStaticMsgType
	if ((In0P->sizeType.msgt_inline != TRUE) ||
	    (In0P->sizeType.msgt_longform != FALSE) ||
	    (In0P->sizeType.msgt_name != 2) ||
	    (In0P->sizeType.msgt_number != 1) ||
	    (In0P->sizeType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->anywhereType != * (int *) &anywhereCheck)
#else	UseStaticMsgType
	if ((In0P->anywhereType.msgt_inline != TRUE) ||
	    (In0P->anywhereType.msgt_longform != FALSE) ||
	    (In0P->anywhereType.msgt_name != 0) ||
	    (In0P->anywhereType.msgt_number != 1) ||
	    (In0P->anywhereType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = vm_allocate(In0P->Head.msgh_request_port, &In0P->address, In0P->size, In0P->anywhere);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->addressType = addressType;
#else	UseStaticMsgType
	OutP->addressType.msgt_name = 2;
	OutP->addressType.msgt_size = 32;
	OutP->addressType.msgt_number = 1;
	OutP->addressType.msgt_inline = TRUE;
	OutP->addressType.msgt_longform = FALSE;
	OutP->addressType.msgt_deallocate = FALSE;
	OutP->addressType.msgt_unused = 0;
#endif	UseStaticMsgType

	OutP->address = In0P->address;
}

/* Routine vm_deallocate */
mig_internal novalue _Xvm_deallocate
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t addressType;
		vm_address_t address;
		mach_msg_type_t sizeType;
		vm_size_t size;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t vm_deallocate
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_task, vm_address_t address, vm_size_t size);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t addressCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t sizeCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->addressType != * (int *) &addressCheck)
#else	UseStaticMsgType
	if ((In0P->addressType.msgt_inline != TRUE) ||
	    (In0P->addressType.msgt_longform != FALSE) ||
	    (In0P->addressType.msgt_name != 2) ||
	    (In0P->addressType.msgt_number != 1) ||
	    (In0P->addressType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->sizeType != * (int *) &sizeCheck)
#else	UseStaticMsgType
	if ((In0P->sizeType.msgt_inline != TRUE) ||
	    (In0P->sizeType.msgt_longform != FALSE) ||
	    (In0P->sizeType.msgt_name != 2) ||
	    (In0P->sizeType.msgt_number != 1) ||
	    (In0P->sizeType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = vm_deallocate(In0P->Head.msgh_request_port, In0P->address, In0P->size);
}

/* Routine vm_protect */
mig_internal novalue _Xvm_protect
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t addressType;
		vm_address_t address;
		mach_msg_type_t sizeType;
		vm_size_t size;
		mach_msg_type_t set_maximumType;
		boolean_t set_maximum;
		mach_msg_type_t new_protectionType;
		vm_prot_t new_protection;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t vm_protect
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_task, vm_address_t address, vm_size_t size, boolean_t set_maximum, vm_prot_t new_protection);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t addressCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t sizeCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t set_maximumCheck = {
		/* msgt_name = */		0,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t new_protectionCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 56) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->addressType != * (int *) &addressCheck)
#else	UseStaticMsgType
	if ((In0P->addressType.msgt_inline != TRUE) ||
	    (In0P->addressType.msgt_longform != FALSE) ||
	    (In0P->addressType.msgt_name != 2) ||
	    (In0P->addressType.msgt_number != 1) ||
	    (In0P->addressType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->sizeType != * (int *) &sizeCheck)
#else	UseStaticMsgType
	if ((In0P->sizeType.msgt_inline != TRUE) ||
	    (In0P->sizeType.msgt_longform != FALSE) ||
	    (In0P->sizeType.msgt_name != 2) ||
	    (In0P->sizeType.msgt_number != 1) ||
	    (In0P->sizeType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->set_maximumType != * (int *) &set_maximumCheck)
#else	UseStaticMsgType
	if ((In0P->set_maximumType.msgt_inline != TRUE) ||
	    (In0P->set_maximumType.msgt_longform != FALSE) ||
	    (In0P->set_maximumType.msgt_name != 0) ||
	    (In0P->set_maximumType.msgt_number != 1) ||
	    (In0P->set_maximumType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->new_protectionType != * (int *) &new_protectionCheck)
#else	UseStaticMsgType
	if ((In0P->new_protectionType.msgt_inline != TRUE) ||
	    (In0P->new_protectionType.msgt_longform != FALSE) ||
	    (In0P->new_protectionType.msgt_name != 2) ||
	    (In0P->new_protectionType.msgt_number != 1) ||
	    (In0P->new_protectionType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = vm_protect(In0P->Head.msgh_request_port, In0P->address, In0P->size, In0P->set_maximum, In0P->new_protection);
}

/* Routine vm_inherit */
mig_internal novalue _Xvm_inherit
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t addressType;
		vm_address_t address;
		mach_msg_type_t sizeType;
		vm_size_t size;
		mach_msg_type_t new_inheritanceType;
		vm_inherit_t new_inheritance;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t vm_inherit
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_task, vm_address_t address, vm_size_t size, vm_inherit_t new_inheritance);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t addressCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t sizeCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t new_inheritanceCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 48) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->addressType != * (int *) &addressCheck)
#else	UseStaticMsgType
	if ((In0P->addressType.msgt_inline != TRUE) ||
	    (In0P->addressType.msgt_longform != FALSE) ||
	    (In0P->addressType.msgt_name != 2) ||
	    (In0P->addressType.msgt_number != 1) ||
	    (In0P->addressType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->sizeType != * (int *) &sizeCheck)
#else	UseStaticMsgType
	if ((In0P->sizeType.msgt_inline != TRUE) ||
	    (In0P->sizeType.msgt_longform != FALSE) ||
	    (In0P->sizeType.msgt_name != 2) ||
	    (In0P->sizeType.msgt_number != 1) ||
	    (In0P->sizeType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->new_inheritanceType != * (int *) &new_inheritanceCheck)
#else	UseStaticMsgType
	if ((In0P->new_inheritanceType.msgt_inline != TRUE) ||
	    (In0P->new_inheritanceType.msgt_longform != FALSE) ||
	    (In0P->new_inheritanceType.msgt_name != 2) ||
	    (In0P->new_inheritanceType.msgt_number != 1) ||
	    (In0P->new_inheritanceType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = vm_inherit(In0P->Head.msgh_request_port, In0P->address, In0P->size, In0P->new_inheritance);
}

/* Routine vm_read */
mig_internal novalue _Xvm_read
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t addressType;
		vm_address_t address;
		mach_msg_type_t sizeType;
		vm_size_t size;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_long_t dataType;
		vm_offset_t data;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t vm_read
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_task, vm_address_t address, vm_size_t size, vm_offset_t *data, mach_msg_type_number_t *dataCnt);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t addressCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t sizeCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t dataType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		FALSE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	9,
		/* msgtl_size = */	8,
		/* msgtl_number = */	0,
	};
#endif	UseStaticMsgType

	mach_msg_type_number_t dataCnt;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->addressType != * (int *) &addressCheck)
#else	UseStaticMsgType
	if ((In0P->addressType.msgt_inline != TRUE) ||
	    (In0P->addressType.msgt_longform != FALSE) ||
	    (In0P->addressType.msgt_name != 2) ||
	    (In0P->addressType.msgt_number != 1) ||
	    (In0P->addressType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->sizeType != * (int *) &sizeCheck)
#else	UseStaticMsgType
	if ((In0P->sizeType.msgt_inline != TRUE) ||
	    (In0P->sizeType.msgt_longform != FALSE) ||
	    (In0P->sizeType.msgt_name != 2) ||
	    (In0P->sizeType.msgt_number != 1) ||
	    (In0P->sizeType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = vm_read(In0P->Head.msgh_request_port, In0P->address, In0P->size, &OutP->data, &dataCnt);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 48;

#if	UseStaticMsgType
	OutP->dataType = dataType;
#else	UseStaticMsgType
	OutP->dataType.msgtl_name = 9;
	OutP->dataType.msgtl_size = 8;
	OutP->dataType.msgtl_header.msgt_name = 0;
	OutP->dataType.msgtl_header.msgt_size = 0;
	OutP->dataType.msgtl_header.msgt_number = 0;
	OutP->dataType.msgtl_header.msgt_inline = FALSE;
	OutP->dataType.msgtl_header.msgt_longform = TRUE;
	OutP->dataType.msgtl_header.msgt_deallocate = FALSE;
	OutP->dataType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType

	OutP->dataType.msgtl_number = dataCnt;
}

/* Routine vm_write */
mig_internal novalue _Xvm_write
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t addressType;
		vm_address_t address;
		mach_msg_type_long_t dataType;
		vm_offset_t data;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t vm_write
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_task, vm_address_t address, vm_offset_t data, mach_msg_type_number_t dataCnt);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t addressCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 48) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->addressType != * (int *) &addressCheck)
#else	UseStaticMsgType
	if ((In0P->addressType.msgt_inline != TRUE) ||
	    (In0P->addressType.msgt_longform != FALSE) ||
	    (In0P->addressType.msgt_name != 2) ||
	    (In0P->addressType.msgt_number != 1) ||
	    (In0P->addressType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if ((In0P->dataType.msgtl_header.msgt_inline != FALSE) ||
	    (In0P->dataType.msgtl_header.msgt_longform != TRUE) ||
	    (In0P->dataType.msgtl_name != 9) ||
	    (In0P->dataType.msgtl_size != 8))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = vm_write(In0P->Head.msgh_request_port, In0P->address, In0P->data, In0P->dataType.msgtl_number);
}

/* Routine vm_copy */
mig_internal novalue _Xvm_copy
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t source_addressType;
		vm_address_t source_address;
		mach_msg_type_t sizeType;
		vm_size_t size;
		mach_msg_type_t dest_addressType;
		vm_address_t dest_address;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t vm_copy
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_task, vm_address_t source_address, vm_size_t size, vm_address_t dest_address);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t source_addressCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t sizeCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t dest_addressCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 48) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->source_addressType != * (int *) &source_addressCheck)
#else	UseStaticMsgType
	if ((In0P->source_addressType.msgt_inline != TRUE) ||
	    (In0P->source_addressType.msgt_longform != FALSE) ||
	    (In0P->source_addressType.msgt_name != 2) ||
	    (In0P->source_addressType.msgt_number != 1) ||
	    (In0P->source_addressType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->sizeType != * (int *) &sizeCheck)
#else	UseStaticMsgType
	if ((In0P->sizeType.msgt_inline != TRUE) ||
	    (In0P->sizeType.msgt_longform != FALSE) ||
	    (In0P->sizeType.msgt_name != 2) ||
	    (In0P->sizeType.msgt_number != 1) ||
	    (In0P->sizeType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->dest_addressType != * (int *) &dest_addressCheck)
#else	UseStaticMsgType
	if ((In0P->dest_addressType.msgt_inline != TRUE) ||
	    (In0P->dest_addressType.msgt_longform != FALSE) ||
	    (In0P->dest_addressType.msgt_name != 2) ||
	    (In0P->dest_addressType.msgt_number != 1) ||
	    (In0P->dest_addressType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = vm_copy(In0P->Head.msgh_request_port, In0P->source_address, In0P->size, In0P->dest_address);
}

/* Routine vm_region */
mig_internal novalue _Xvm_region
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t addressType;
		vm_address_t address;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t addressType;
		vm_address_t address;
		mach_msg_type_t sizeType;
		vm_size_t size;
		mach_msg_type_t protectionType;
		vm_prot_t protection;
		mach_msg_type_t max_protectionType;
		vm_prot_t max_protection;
		mach_msg_type_t inheritanceType;
		vm_inherit_t inheritance;
		mach_msg_type_t is_sharedType;
		boolean_t is_shared;
		mach_msg_type_t object_nameType;
		mach_port_t object_name;
		mach_msg_type_t offsetType;
		vm_offset_t offset;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t vm_region
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_task, vm_address_t *address, vm_size_t *size, vm_prot_t *protection, vm_prot_t *max_protection, vm_inherit_t *inheritance, boolean_t *is_shared, mach_port_t *object_name, vm_offset_t *offset);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t addressCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t addressType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t sizeType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t protectionType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t max_protectionType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t inheritanceType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t is_sharedType = {
		/* msgt_name = */		0,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t object_nameType = {
		/* msgt_name = */		17,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t offsetType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->addressType != * (int *) &addressCheck)
#else	UseStaticMsgType
	if ((In0P->addressType.msgt_inline != TRUE) ||
	    (In0P->addressType.msgt_longform != FALSE) ||
	    (In0P->addressType.msgt_name != 2) ||
	    (In0P->addressType.msgt_number != 1) ||
	    (In0P->addressType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = vm_region(In0P->Head.msgh_request_port, &In0P->address, &OutP->size, &OutP->protection, &OutP->max_protection, &OutP->inheritance, &OutP->is_shared, &OutP->object_name, &OutP->offset);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 96;

#if	UseStaticMsgType
	OutP->addressType = addressType;
#else	UseStaticMsgType
	OutP->addressType.msgt_name = 2;
	OutP->addressType.msgt_size = 32;
	OutP->addressType.msgt_number = 1;
	OutP->addressType.msgt_inline = TRUE;
	OutP->addressType.msgt_longform = FALSE;
	OutP->addressType.msgt_deallocate = FALSE;
	OutP->addressType.msgt_unused = 0;
#endif	UseStaticMsgType

	OutP->address = In0P->address;

#if	UseStaticMsgType
	OutP->sizeType = sizeType;
#else	UseStaticMsgType
	OutP->sizeType.msgt_name = 2;
	OutP->sizeType.msgt_size = 32;
	OutP->sizeType.msgt_number = 1;
	OutP->sizeType.msgt_inline = TRUE;
	OutP->sizeType.msgt_longform = FALSE;
	OutP->sizeType.msgt_deallocate = FALSE;
	OutP->sizeType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->protectionType = protectionType;
#else	UseStaticMsgType
	OutP->protectionType.msgt_name = 2;
	OutP->protectionType.msgt_size = 32;
	OutP->protectionType.msgt_number = 1;
	OutP->protectionType.msgt_inline = TRUE;
	OutP->protectionType.msgt_longform = FALSE;
	OutP->protectionType.msgt_deallocate = FALSE;
	OutP->protectionType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->max_protectionType = max_protectionType;
#else	UseStaticMsgType
	OutP->max_protectionType.msgt_name = 2;
	OutP->max_protectionType.msgt_size = 32;
	OutP->max_protectionType.msgt_number = 1;
	OutP->max_protectionType.msgt_inline = TRUE;
	OutP->max_protectionType.msgt_longform = FALSE;
	OutP->max_protectionType.msgt_deallocate = FALSE;
	OutP->max_protectionType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->inheritanceType = inheritanceType;
#else	UseStaticMsgType
	OutP->inheritanceType.msgt_name = 2;
	OutP->inheritanceType.msgt_size = 32;
	OutP->inheritanceType.msgt_number = 1;
	OutP->inheritanceType.msgt_inline = TRUE;
	OutP->inheritanceType.msgt_longform = FALSE;
	OutP->inheritanceType.msgt_deallocate = FALSE;
	OutP->inheritanceType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->is_sharedType = is_sharedType;
#else	UseStaticMsgType
	OutP->is_sharedType.msgt_name = 0;
	OutP->is_sharedType.msgt_size = 32;
	OutP->is_sharedType.msgt_number = 1;
	OutP->is_sharedType.msgt_inline = TRUE;
	OutP->is_sharedType.msgt_longform = FALSE;
	OutP->is_sharedType.msgt_deallocate = FALSE;
	OutP->is_sharedType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->object_nameType = object_nameType;
#else	UseStaticMsgType
	OutP->object_nameType.msgt_name = 17;
	OutP->object_nameType.msgt_size = 32;
	OutP->object_nameType.msgt_number = 1;
	OutP->object_nameType.msgt_inline = TRUE;
	OutP->object_nameType.msgt_longform = FALSE;
	OutP->object_nameType.msgt_deallocate = FALSE;
	OutP->object_nameType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->offsetType = offsetType;
#else	UseStaticMsgType
	OutP->offsetType.msgt_name = 2;
	OutP->offsetType.msgt_size = 32;
	OutP->offsetType.msgt_number = 1;
	OutP->offsetType.msgt_inline = TRUE;
	OutP->offsetType.msgt_longform = FALSE;
	OutP->offsetType.msgt_deallocate = FALSE;
	OutP->offsetType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine vm_statistics */
mig_internal novalue _Xvm_statistics
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t vm_statsType;
		vm_statistics_data_t vm_stats;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t vm_statistics
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_task, vm_statistics_data_t *vm_stats);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t vm_statsType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		13,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = vm_statistics(In0P->Head.msgh_request_port, &OutP->vm_stats);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 88;

#if	UseStaticMsgType
	OutP->vm_statsType = vm_statsType;
#else	UseStaticMsgType
	OutP->vm_statsType.msgt_name = 2;
	OutP->vm_statsType.msgt_size = 32;
	OutP->vm_statsType.msgt_number = 13;
	OutP->vm_statsType.msgt_inline = TRUE;
	OutP->vm_statsType.msgt_longform = FALSE;
	OutP->vm_statsType.msgt_deallocate = FALSE;
	OutP->vm_statsType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine mach_ports_register */
mig_internal novalue _Xmach_ports_register
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_long_t init_port_setType;
		mach_port_array_t init_port_set;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t mach_ports_register
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_task, mach_port_array_t init_port_set, mach_msg_type_number_t init_port_setCnt);
#else
		();
#endif

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if ((In0P->init_port_setType.msgtl_header.msgt_inline != FALSE) ||
	    (In0P->init_port_setType.msgtl_header.msgt_longform != TRUE) ||
	    (In0P->init_port_setType.msgtl_name != 17) ||
	    (In0P->init_port_setType.msgtl_size != 32))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = mach_ports_register(In0P->Head.msgh_request_port, In0P->init_port_set, In0P->init_port_setType.msgtl_number);
}

/* Routine mach_ports_lookup */
mig_internal novalue _Xmach_ports_lookup
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_long_t init_port_setType;
		mach_port_array_t init_port_set;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t mach_ports_lookup
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_task, mach_port_array_t *init_port_set, mach_msg_type_number_t *init_port_setCnt);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_long_t init_port_setType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		FALSE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	19,
		/* msgtl_size = */	32,
		/* msgtl_number = */	0,
	};
#endif	UseStaticMsgType

	mach_msg_type_number_t init_port_setCnt;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = mach_ports_lookup(In0P->Head.msgh_request_port, &OutP->init_port_set, &init_port_setCnt);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 48;

#if	UseStaticMsgType
	OutP->init_port_setType = init_port_setType;
#else	UseStaticMsgType
	OutP->init_port_setType.msgtl_name = 19;
	OutP->init_port_setType.msgtl_size = 32;
	OutP->init_port_setType.msgtl_header.msgt_name = 0;
	OutP->init_port_setType.msgtl_header.msgt_size = 0;
	OutP->init_port_setType.msgtl_header.msgt_number = 0;
	OutP->init_port_setType.msgtl_header.msgt_inline = FALSE;
	OutP->init_port_setType.msgtl_header.msgt_longform = TRUE;
	OutP->init_port_setType.msgtl_header.msgt_deallocate = FALSE;
	OutP->init_port_setType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType

	OutP->init_port_setType.msgtl_number = init_port_setCnt;
}

/* SimpleRoutine memory_object_data_provided */
mig_internal novalue _Xmemory_object_data_provided
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t offsetType;
		vm_offset_t offset;
		mach_msg_type_long_t dataType;
		vm_offset_t data;
		mach_msg_type_t lock_valueType;
		vm_prot_t lock_value;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t memory_object_data_provided
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t memory_control, vm_offset_t offset, vm_offset_t data, mach_msg_type_number_t dataCnt, vm_prot_t lock_value);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t offsetCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t lock_valueCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 56) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->offsetType != * (int *) &offsetCheck)
#else	UseStaticMsgType
	if ((In0P->offsetType.msgt_inline != TRUE) ||
	    (In0P->offsetType.msgt_longform != FALSE) ||
	    (In0P->offsetType.msgt_name != 2) ||
	    (In0P->offsetType.msgt_number != 1) ||
	    (In0P->offsetType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if ((In0P->dataType.msgtl_header.msgt_inline != FALSE) ||
	    (In0P->dataType.msgtl_header.msgt_longform != TRUE) ||
	    (In0P->dataType.msgtl_name != 9) ||
	    (In0P->dataType.msgtl_size != 8))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->lock_valueType != * (int *) &lock_valueCheck)
#else	UseStaticMsgType
	if ((In0P->lock_valueType.msgt_inline != TRUE) ||
	    (In0P->lock_valueType.msgt_longform != FALSE) ||
	    (In0P->lock_valueType.msgt_name != 2) ||
	    (In0P->lock_valueType.msgt_number != 1) ||
	    (In0P->lock_valueType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = memory_object_data_provided(In0P->Head.msgh_request_port, In0P->offset, In0P->data, In0P->dataType.msgtl_number, In0P->lock_value);
}

/* SimpleRoutine memory_object_data_unavailable */
mig_internal novalue _Xmemory_object_data_unavailable
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t offsetType;
		vm_offset_t offset;
		mach_msg_type_t sizeType;
		vm_size_t size;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t memory_object_data_unavailable
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t memory_control, vm_offset_t offset, vm_size_t size);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t offsetCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t sizeCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->offsetType != * (int *) &offsetCheck)
#else	UseStaticMsgType
	if ((In0P->offsetType.msgt_inline != TRUE) ||
	    (In0P->offsetType.msgt_longform != FALSE) ||
	    (In0P->offsetType.msgt_name != 2) ||
	    (In0P->offsetType.msgt_number != 1) ||
	    (In0P->offsetType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->sizeType != * (int *) &sizeCheck)
#else	UseStaticMsgType
	if ((In0P->sizeType.msgt_inline != TRUE) ||
	    (In0P->sizeType.msgt_longform != FALSE) ||
	    (In0P->sizeType.msgt_name != 2) ||
	    (In0P->sizeType.msgt_number != 1) ||
	    (In0P->sizeType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = memory_object_data_unavailable(In0P->Head.msgh_request_port, In0P->offset, In0P->size);
}

/* Routine memory_object_get_attributes */
mig_internal novalue _Xmemory_object_get_attributes
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t object_readyType;
		boolean_t object_ready;
		mach_msg_type_t may_cacheType;
		boolean_t may_cache;
		mach_msg_type_t copy_strategyType;
		memory_object_copy_strategy_t copy_strategy;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t memory_object_get_attributes
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t memory_control, boolean_t *object_ready, boolean_t *may_cache, memory_object_copy_strategy_t *copy_strategy);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t object_readyType = {
		/* msgt_name = */		0,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t may_cacheType = {
		/* msgt_name = */		0,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t copy_strategyType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = memory_object_get_attributes(In0P->Head.msgh_request_port, &OutP->object_ready, &OutP->may_cache, &OutP->copy_strategy);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 56;

#if	UseStaticMsgType
	OutP->object_readyType = object_readyType;
#else	UseStaticMsgType
	OutP->object_readyType.msgt_name = 0;
	OutP->object_readyType.msgt_size = 32;
	OutP->object_readyType.msgt_number = 1;
	OutP->object_readyType.msgt_inline = TRUE;
	OutP->object_readyType.msgt_longform = FALSE;
	OutP->object_readyType.msgt_deallocate = FALSE;
	OutP->object_readyType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->may_cacheType = may_cacheType;
#else	UseStaticMsgType
	OutP->may_cacheType.msgt_name = 0;
	OutP->may_cacheType.msgt_size = 32;
	OutP->may_cacheType.msgt_number = 1;
	OutP->may_cacheType.msgt_inline = TRUE;
	OutP->may_cacheType.msgt_longform = FALSE;
	OutP->may_cacheType.msgt_deallocate = FALSE;
	OutP->may_cacheType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->copy_strategyType = copy_strategyType;
#else	UseStaticMsgType
	OutP->copy_strategyType.msgt_name = 2;
	OutP->copy_strategyType.msgt_size = 32;
	OutP->copy_strategyType.msgt_number = 1;
	OutP->copy_strategyType.msgt_inline = TRUE;
	OutP->copy_strategyType.msgt_longform = FALSE;
	OutP->copy_strategyType.msgt_deallocate = FALSE;
	OutP->copy_strategyType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine vm_set_default_memory_manager */
mig_internal novalue _Xvm_set_default_memory_manager
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t default_managerType;
		mach_port_t default_manager;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t default_managerType;
		mach_port_t default_manager;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t vm_set_default_memory_manager
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t host_priv, mach_port_t *default_manager);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t default_managerCheck = {
		/* msgt_name = */		17,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t default_managerType = {
		/* msgt_name = */		20,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->default_managerType != * (int *) &default_managerCheck)
#else	UseStaticMsgType
	if ((In0P->default_managerType.msgt_inline != TRUE) ||
	    (In0P->default_managerType.msgt_longform != FALSE) ||
	    (In0P->default_managerType.msgt_name != 17) ||
	    (In0P->default_managerType.msgt_number != 1) ||
	    (In0P->default_managerType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = vm_set_default_memory_manager(In0P->Head.msgh_request_port, &In0P->default_manager);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->default_managerType = default_managerType;
#else	UseStaticMsgType
	OutP->default_managerType.msgt_name = 20;
	OutP->default_managerType.msgt_size = 32;
	OutP->default_managerType.msgt_number = 1;
	OutP->default_managerType.msgt_inline = TRUE;
	OutP->default_managerType.msgt_longform = FALSE;
	OutP->default_managerType.msgt_deallocate = FALSE;
	OutP->default_managerType.msgt_unused = 0;
#endif	UseStaticMsgType

	OutP->default_manager = In0P->default_manager;
}

/* SimpleRoutine xxx_memory_object_lock_request */
mig_internal novalue _Xxxx_memory_object_lock_request
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t offsetType;
		vm_offset_t offset;
		mach_msg_type_t sizeType;
		vm_size_t size;
		mach_msg_type_t should_cleanType;
		boolean_t should_clean;
		mach_msg_type_t should_flushType;
		boolean_t should_flush;
		mach_msg_type_t lock_valueType;
		vm_prot_t lock_value;
		mach_msg_type_t reply_toType;
		mach_port_t reply_to;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t xxx_memory_object_lock_request
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t memory_control, vm_offset_t offset, vm_size_t size, boolean_t should_clean, boolean_t should_flush, vm_prot_t lock_value, mach_port_t reply_to, mach_msg_type_name_t reply_toPoly);
#else
		();
#endif

#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck

#if	UseStaticMsgType
	static mach_msg_type_t offsetCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t sizeCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t should_cleanCheck = {
		/* msgt_name = */		0,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t should_flushCheck = {
		/* msgt_name = */		0,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t lock_valueCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	msgh_simple = !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
	if ((In0P->Head.msgh_size != 72))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->offsetType != * (int *) &offsetCheck)
#else	UseStaticMsgType
	if ((In0P->offsetType.msgt_inline != TRUE) ||
	    (In0P->offsetType.msgt_longform != FALSE) ||
	    (In0P->offsetType.msgt_name != 2) ||
	    (In0P->offsetType.msgt_number != 1) ||
	    (In0P->offsetType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->sizeType != * (int *) &sizeCheck)
#else	UseStaticMsgType
	if ((In0P->sizeType.msgt_inline != TRUE) ||
	    (In0P->sizeType.msgt_longform != FALSE) ||
	    (In0P->sizeType.msgt_name != 2) ||
	    (In0P->sizeType.msgt_number != 1) ||
	    (In0P->sizeType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->should_cleanType != * (int *) &should_cleanCheck)
#else	UseStaticMsgType
	if ((In0P->should_cleanType.msgt_inline != TRUE) ||
	    (In0P->should_cleanType.msgt_longform != FALSE) ||
	    (In0P->should_cleanType.msgt_name != 0) ||
	    (In0P->should_cleanType.msgt_number != 1) ||
	    (In0P->should_cleanType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->should_flushType != * (int *) &should_flushCheck)
#else	UseStaticMsgType
	if ((In0P->should_flushType.msgt_inline != TRUE) ||
	    (In0P->should_flushType.msgt_longform != FALSE) ||
	    (In0P->should_flushType.msgt_name != 0) ||
	    (In0P->should_flushType.msgt_number != 1) ||
	    (In0P->should_flushType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->lock_valueType != * (int *) &lock_valueCheck)
#else	UseStaticMsgType
	if ((In0P->lock_valueType.msgt_inline != TRUE) ||
	    (In0P->lock_valueType.msgt_longform != FALSE) ||
	    (In0P->lock_valueType.msgt_name != 2) ||
	    (In0P->lock_valueType.msgt_number != 1) ||
	    (In0P->lock_valueType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if ((In0P->reply_toType.msgt_inline != TRUE) ||
	    (In0P->reply_toType.msgt_longform != FALSE) ||
	    (MACH_MSG_TYPE_PORT_ANY(In0P->reply_toType.msgt_name) && msgh_simple) ||
	    (In0P->reply_toType.msgt_number != 1) ||
	    (In0P->reply_toType.msgt_size != 32))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = xxx_memory_object_lock_request(In0P->Head.msgh_request_port, In0P->offset, In0P->size, In0P->should_clean, In0P->should_flush, In0P->lock_value, In0P->reply_to, In0P->reply_toType.msgt_name);
}

/* SimpleRoutine memory_object_lock_request */
mig_internal novalue _Xmemory_object_lock_request
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t offsetType;
		vm_offset_t offset;
		mach_msg_type_t sizeType;
		vm_size_t size;
		mach_msg_type_t should_returnType;
		memory_object_return_t should_return;
		mach_msg_type_t should_flushType;
		boolean_t should_flush;
		mach_msg_type_t lock_valueType;
		vm_prot_t lock_value;
		mach_msg_type_t reply_toType;
		mach_port_t reply_to;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t memory_object_lock_request
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t memory_control, vm_offset_t offset, vm_size_t size, memory_object_return_t should_return, boolean_t should_flush, vm_prot_t lock_value, mach_port_t reply_to, mach_msg_type_name_t reply_toPoly);
#else
		();
#endif

#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck

#if	UseStaticMsgType
	static mach_msg_type_t offsetCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t sizeCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t should_returnCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t should_flushCheck = {
		/* msgt_name = */		0,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t lock_valueCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	msgh_simple = !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
	if ((In0P->Head.msgh_size != 72))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->offsetType != * (int *) &offsetCheck)
#else	UseStaticMsgType
	if ((In0P->offsetType.msgt_inline != TRUE) ||
	    (In0P->offsetType.msgt_longform != FALSE) ||
	    (In0P->offsetType.msgt_name != 2) ||
	    (In0P->offsetType.msgt_number != 1) ||
	    (In0P->offsetType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->sizeType != * (int *) &sizeCheck)
#else	UseStaticMsgType
	if ((In0P->sizeType.msgt_inline != TRUE) ||
	    (In0P->sizeType.msgt_longform != FALSE) ||
	    (In0P->sizeType.msgt_name != 2) ||
	    (In0P->sizeType.msgt_number != 1) ||
	    (In0P->sizeType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->should_returnType != * (int *) &should_returnCheck)
#else	UseStaticMsgType
	if ((In0P->should_returnType.msgt_inline != TRUE) ||
	    (In0P->should_returnType.msgt_longform != FALSE) ||
	    (In0P->should_returnType.msgt_name != 2) ||
	    (In0P->should_returnType.msgt_number != 1) ||
	    (In0P->should_returnType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->should_flushType != * (int *) &should_flushCheck)
#else	UseStaticMsgType
	if ((In0P->should_flushType.msgt_inline != TRUE) ||
	    (In0P->should_flushType.msgt_longform != FALSE) ||
	    (In0P->should_flushType.msgt_name != 0) ||
	    (In0P->should_flushType.msgt_number != 1) ||
	    (In0P->should_flushType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->lock_valueType != * (int *) &lock_valueCheck)
#else	UseStaticMsgType
	if ((In0P->lock_valueType.msgt_inline != TRUE) ||
	    (In0P->lock_valueType.msgt_longform != FALSE) ||
	    (In0P->lock_valueType.msgt_name != 2) ||
	    (In0P->lock_valueType.msgt_number != 1) ||
	    (In0P->lock_valueType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if ((In0P->reply_toType.msgt_inline != TRUE) ||
	    (In0P->reply_toType.msgt_longform != FALSE) ||
	    (MACH_MSG_TYPE_PORT_ANY(In0P->reply_toType.msgt_name) && msgh_simple) ||
	    (In0P->reply_toType.msgt_number != 1) ||
	    (In0P->reply_toType.msgt_size != 32))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = memory_object_lock_request(In0P->Head.msgh_request_port, In0P->offset, In0P->size, In0P->should_return, In0P->should_flush, In0P->lock_value, In0P->reply_to, In0P->reply_toType.msgt_name);
}

/* Routine xxx_task_get_emulation_vector */
mig_internal novalue _Xxxx_task_get_emulation_vector
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t vector_startType;
		int vector_start;
		mach_msg_type_long_t emulation_vectorType;
		vm_offset_t emulation_vector[1024];
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t xxx_task_get_emulation_vector
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t task, int *vector_start, emulation_vector_t emulation_vector, mach_msg_type_number_t *emulation_vectorCnt);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t vector_startType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t emulation_vectorType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	2,
		/* msgtl_size = */	32,
		/* msgtl_number = */	1024,
	};
#endif	UseStaticMsgType

	mach_msg_type_number_t emulation_vectorCnt;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	emulation_vectorCnt = 1024;

	OutP->RetCode = xxx_task_get_emulation_vector(In0P->Head.msgh_request_port, &OutP->vector_start, OutP->emulation_vector, &emulation_vectorCnt);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

#if	UseStaticMsgType
	OutP->vector_startType = vector_startType;
#else	UseStaticMsgType
	OutP->vector_startType.msgt_name = 2;
	OutP->vector_startType.msgt_size = 32;
	OutP->vector_startType.msgt_number = 1;
	OutP->vector_startType.msgt_inline = TRUE;
	OutP->vector_startType.msgt_longform = FALSE;
	OutP->vector_startType.msgt_deallocate = FALSE;
	OutP->vector_startType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->emulation_vectorType = emulation_vectorType;
#else	UseStaticMsgType
	OutP->emulation_vectorType.msgtl_name = 2;
	OutP->emulation_vectorType.msgtl_size = 32;
	OutP->emulation_vectorType.msgtl_header.msgt_name = 0;
	OutP->emulation_vectorType.msgtl_header.msgt_size = 0;
	OutP->emulation_vectorType.msgtl_header.msgt_number = 0;
	OutP->emulation_vectorType.msgtl_header.msgt_inline = TRUE;
	OutP->emulation_vectorType.msgtl_header.msgt_longform = TRUE;
	OutP->emulation_vectorType.msgtl_header.msgt_deallocate = FALSE;
	OutP->emulation_vectorType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType

	OutP->emulation_vectorType.msgtl_number = emulation_vectorCnt;
	OutP->Head.msgh_size = 52 + (4 * emulation_vectorCnt);
}

/* Routine xxx_task_set_emulation_vector */
mig_internal novalue _Xxxx_task_set_emulation_vector
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t vector_startType;
		int vector_start;
		mach_msg_type_long_t emulation_vectorType;
		vm_offset_t emulation_vector[1024];
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t xxx_task_set_emulation_vector
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t task, int vector_start, emulation_vector_t emulation_vector, mach_msg_type_number_t emulation_vectorCnt);
#else
		();
#endif

	unsigned int msgh_size;

#if	UseStaticMsgType
	static mach_msg_type_t vector_startCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	msgh_size = In0P->Head.msgh_size;
	if ((msgh_size < 44) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->vector_startType != * (int *) &vector_startCheck)
#else	UseStaticMsgType
	if ((In0P->vector_startType.msgt_inline != TRUE) ||
	    (In0P->vector_startType.msgt_longform != FALSE) ||
	    (In0P->vector_startType.msgt_name != 2) ||
	    (In0P->vector_startType.msgt_number != 1) ||
	    (In0P->vector_startType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if ((In0P->emulation_vectorType.msgtl_header.msgt_inline != TRUE) ||
	    (In0P->emulation_vectorType.msgtl_header.msgt_longform != TRUE) ||
	    (In0P->emulation_vectorType.msgtl_name != 2) ||
	    (In0P->emulation_vectorType.msgtl_size != 32))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if (msgh_size != 44 + (4 * In0P->emulation_vectorType.msgtl_number))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = xxx_task_set_emulation_vector(In0P->Head.msgh_request_port, In0P->vector_start, In0P->emulation_vector, In0P->emulation_vectorType.msgtl_number);
}

/* Routine xxx_host_info */
mig_internal novalue _Xxxx_host_info
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t infoType;
		machine_info_data_t info;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t xxx_host_info
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_task, machine_info_data_t *info);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t infoType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		5,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = xxx_host_info(In0P->Head.msgh_request_port, &OutP->info);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 56;

#if	UseStaticMsgType
	OutP->infoType = infoType;
#else	UseStaticMsgType
	OutP->infoType.msgt_name = 2;
	OutP->infoType.msgt_size = 32;
	OutP->infoType.msgt_number = 5;
	OutP->infoType.msgt_inline = TRUE;
	OutP->infoType.msgt_longform = FALSE;
	OutP->infoType.msgt_deallocate = FALSE;
	OutP->infoType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine xxx_slot_info */
mig_internal novalue _Xxxx_slot_info
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t slotType;
		int slot;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t infoType;
		machine_slot_data_t info;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t xxx_slot_info
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_task, int slot, machine_slot_data_t *info);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t slotCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t infoType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		8,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->slotType != * (int *) &slotCheck)
#else	UseStaticMsgType
	if ((In0P->slotType.msgt_inline != TRUE) ||
	    (In0P->slotType.msgt_longform != FALSE) ||
	    (In0P->slotType.msgt_name != 2) ||
	    (In0P->slotType.msgt_number != 1) ||
	    (In0P->slotType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = xxx_slot_info(In0P->Head.msgh_request_port, In0P->slot, &OutP->info);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 68;

#if	UseStaticMsgType
	OutP->infoType = infoType;
#else	UseStaticMsgType
	OutP->infoType.msgt_name = 2;
	OutP->infoType.msgt_size = 32;
	OutP->infoType.msgt_number = 8;
	OutP->infoType.msgt_inline = TRUE;
	OutP->infoType.msgt_longform = FALSE;
	OutP->infoType.msgt_deallocate = FALSE;
	OutP->infoType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine xxx_cpu_control */
mig_internal novalue _Xxxx_cpu_control
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t cpuType;
		int cpu;
		mach_msg_type_t runningType;
		boolean_t running;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t xxx_cpu_control
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_task, int cpu, boolean_t running);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t cpuCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t runningCheck = {
		/* msgt_name = */		0,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->cpuType != * (int *) &cpuCheck)
#else	UseStaticMsgType
	if ((In0P->cpuType.msgt_inline != TRUE) ||
	    (In0P->cpuType.msgt_longform != FALSE) ||
	    (In0P->cpuType.msgt_name != 2) ||
	    (In0P->cpuType.msgt_number != 1) ||
	    (In0P->cpuType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->runningType != * (int *) &runningCheck)
#else	UseStaticMsgType
	if ((In0P->runningType.msgt_inline != TRUE) ||
	    (In0P->runningType.msgt_longform != FALSE) ||
	    (In0P->runningType.msgt_name != 0) ||
	    (In0P->runningType.msgt_number != 1) ||
	    (In0P->runningType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = xxx_cpu_control(In0P->Head.msgh_request_port, In0P->cpu, In0P->running);
}

/* Routine task_suspend */
mig_internal novalue _Xtask_suspend
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t task_suspend
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_task);
#else
		();
#endif

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = task_suspend(In0P->Head.msgh_request_port);
}

/* Routine task_resume */
mig_internal novalue _Xtask_resume
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t task_resume
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_task);
#else
		();
#endif

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = task_resume(In0P->Head.msgh_request_port);
}

/* Routine task_get_special_port */
mig_internal novalue _Xtask_get_special_port
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t which_portType;
		int which_port;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t special_portType;
		mach_port_t special_port;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t task_get_special_port
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t task, int which_port, mach_port_t *special_port);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t which_portCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t special_portType = {
		/* msgt_name = */		19,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->which_portType != * (int *) &which_portCheck)
#else	UseStaticMsgType
	if ((In0P->which_portType.msgt_inline != TRUE) ||
	    (In0P->which_portType.msgt_longform != FALSE) ||
	    (In0P->which_portType.msgt_name != 2) ||
	    (In0P->which_portType.msgt_number != 1) ||
	    (In0P->which_portType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = task_get_special_port(In0P->Head.msgh_request_port, In0P->which_port, &OutP->special_port);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->special_portType = special_portType;
#else	UseStaticMsgType
	OutP->special_portType.msgt_name = 19;
	OutP->special_portType.msgt_size = 32;
	OutP->special_portType.msgt_number = 1;
	OutP->special_portType.msgt_inline = TRUE;
	OutP->special_portType.msgt_longform = FALSE;
	OutP->special_portType.msgt_deallocate = FALSE;
	OutP->special_portType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine task_set_special_port */
mig_internal novalue _Xtask_set_special_port
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t which_portType;
		int which_port;
		mach_msg_type_t special_portType;
		mach_port_t special_port;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t task_set_special_port
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t task, int which_port, mach_port_t special_port);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t which_portCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t special_portCheck = {
		/* msgt_name = */		17,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->which_portType != * (int *) &which_portCheck)
#else	UseStaticMsgType
	if ((In0P->which_portType.msgt_inline != TRUE) ||
	    (In0P->which_portType.msgt_longform != FALSE) ||
	    (In0P->which_portType.msgt_name != 2) ||
	    (In0P->which_portType.msgt_number != 1) ||
	    (In0P->which_portType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->special_portType != * (int *) &special_portCheck)
#else	UseStaticMsgType
	if ((In0P->special_portType.msgt_inline != TRUE) ||
	    (In0P->special_portType.msgt_longform != FALSE) ||
	    (In0P->special_portType.msgt_name != 17) ||
	    (In0P->special_portType.msgt_number != 1) ||
	    (In0P->special_portType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = task_set_special_port(In0P->Head.msgh_request_port, In0P->which_port, In0P->special_port);
}

/* Routine xxx_task_info */
mig_internal novalue _Xxxx_task_info
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t flavorType;
		int flavor;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_long_t task_info_outType;
		int task_info_out[1024];
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t xxx_task_info
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_task, int flavor, task_info_t task_info_out, mach_msg_type_number_t *task_info_outCnt);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t flavorCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t task_info_outType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	2,
		/* msgtl_size = */	32,
		/* msgtl_number = */	1024,
	};
#endif	UseStaticMsgType

	mach_msg_type_number_t task_info_outCnt;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->flavorType != * (int *) &flavorCheck)
#else	UseStaticMsgType
	if ((In0P->flavorType.msgt_inline != TRUE) ||
	    (In0P->flavorType.msgt_longform != FALSE) ||
	    (In0P->flavorType.msgt_name != 2) ||
	    (In0P->flavorType.msgt_number != 1) ||
	    (In0P->flavorType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	task_info_outCnt = 1024;

	OutP->RetCode = xxx_task_info(In0P->Head.msgh_request_port, In0P->flavor, OutP->task_info_out, &task_info_outCnt);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

#if	UseStaticMsgType
	OutP->task_info_outType = task_info_outType;
#else	UseStaticMsgType
	OutP->task_info_outType.msgtl_name = 2;
	OutP->task_info_outType.msgtl_size = 32;
	OutP->task_info_outType.msgtl_header.msgt_name = 0;
	OutP->task_info_outType.msgtl_header.msgt_size = 0;
	OutP->task_info_outType.msgtl_header.msgt_number = 0;
	OutP->task_info_outType.msgtl_header.msgt_inline = TRUE;
	OutP->task_info_outType.msgtl_header.msgt_longform = TRUE;
	OutP->task_info_outType.msgtl_header.msgt_deallocate = FALSE;
	OutP->task_info_outType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType

	OutP->task_info_outType.msgtl_number = task_info_outCnt;
	OutP->Head.msgh_size = 44 + (4 * task_info_outCnt);
}

/* Routine thread_create */
mig_internal novalue _Xthread_create
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t child_threadType;
		mach_port_t child_thread;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t thread_create
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t parent_task, mach_port_t *child_thread);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t child_threadType = {
		/* msgt_name = */		19,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = thread_create(In0P->Head.msgh_request_port, &OutP->child_thread);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->child_threadType = child_threadType;
#else	UseStaticMsgType
	OutP->child_threadType.msgt_name = 19;
	OutP->child_threadType.msgt_size = 32;
	OutP->child_threadType.msgt_number = 1;
	OutP->child_threadType.msgt_inline = TRUE;
	OutP->child_threadType.msgt_longform = FALSE;
	OutP->child_threadType.msgt_deallocate = FALSE;
	OutP->child_threadType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine thread_suspend */
mig_internal novalue _Xthread_suspend
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t thread_suspend
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_thread);
#else
		();
#endif

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = thread_suspend(In0P->Head.msgh_request_port);
}

/* Routine thread_resume */
mig_internal novalue _Xthread_resume
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t thread_resume
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_thread);
#else
		();
#endif

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = thread_resume(In0P->Head.msgh_request_port);
}

/* Routine thread_abort */
mig_internal novalue _Xthread_abort
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t thread_abort
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_thread);
#else
		();
#endif

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = thread_abort(In0P->Head.msgh_request_port);
}

/* Routine xxx_thread_get_state */
mig_internal novalue _Xxxx_thread_get_state
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t flavorType;
		int flavor;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_long_t old_stateType;
		int old_state[1024];
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t xxx_thread_get_state
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_thread, int flavor, thread_state_t old_state, mach_msg_type_number_t *old_stateCnt);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t flavorCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t old_stateType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	2,
		/* msgtl_size = */	32,
		/* msgtl_number = */	1024,
	};
#endif	UseStaticMsgType

	mach_msg_type_number_t old_stateCnt;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->flavorType != * (int *) &flavorCheck)
#else	UseStaticMsgType
	if ((In0P->flavorType.msgt_inline != TRUE) ||
	    (In0P->flavorType.msgt_longform != FALSE) ||
	    (In0P->flavorType.msgt_name != 2) ||
	    (In0P->flavorType.msgt_number != 1) ||
	    (In0P->flavorType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	old_stateCnt = 1024;

	OutP->RetCode = xxx_thread_get_state(In0P->Head.msgh_request_port, In0P->flavor, OutP->old_state, &old_stateCnt);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

#if	UseStaticMsgType
	OutP->old_stateType = old_stateType;
#else	UseStaticMsgType
	OutP->old_stateType.msgtl_name = 2;
	OutP->old_stateType.msgtl_size = 32;
	OutP->old_stateType.msgtl_header.msgt_name = 0;
	OutP->old_stateType.msgtl_header.msgt_size = 0;
	OutP->old_stateType.msgtl_header.msgt_number = 0;
	OutP->old_stateType.msgtl_header.msgt_inline = TRUE;
	OutP->old_stateType.msgtl_header.msgt_longform = TRUE;
	OutP->old_stateType.msgtl_header.msgt_deallocate = FALSE;
	OutP->old_stateType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType

	OutP->old_stateType.msgtl_number = old_stateCnt;
	OutP->Head.msgh_size = 44 + (4 * old_stateCnt);
}

/* Routine xxx_thread_set_state */
mig_internal novalue _Xxxx_thread_set_state
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t flavorType;
		int flavor;
		mach_msg_type_long_t new_stateType;
		int new_state[1024];
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t xxx_thread_set_state
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_thread, int flavor, thread_state_t new_state, mach_msg_type_number_t new_stateCnt);
#else
		();
#endif

	unsigned int msgh_size;

#if	UseStaticMsgType
	static mach_msg_type_t flavorCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	msgh_size = In0P->Head.msgh_size;
	if ((msgh_size < 44) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->flavorType != * (int *) &flavorCheck)
#else	UseStaticMsgType
	if ((In0P->flavorType.msgt_inline != TRUE) ||
	    (In0P->flavorType.msgt_longform != FALSE) ||
	    (In0P->flavorType.msgt_name != 2) ||
	    (In0P->flavorType.msgt_number != 1) ||
	    (In0P->flavorType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if ((In0P->new_stateType.msgtl_header.msgt_inline != TRUE) ||
	    (In0P->new_stateType.msgtl_header.msgt_longform != TRUE) ||
	    (In0P->new_stateType.msgtl_name != 2) ||
	    (In0P->new_stateType.msgtl_size != 32))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if (msgh_size != 44 + (4 * In0P->new_stateType.msgtl_number))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = xxx_thread_set_state(In0P->Head.msgh_request_port, In0P->flavor, In0P->new_state, In0P->new_stateType.msgtl_number);
}

/* Routine thread_get_special_port */
mig_internal novalue _Xthread_get_special_port
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t which_portType;
		int which_port;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t special_portType;
		mach_port_t special_port;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t thread_get_special_port
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t thread, int which_port, mach_port_t *special_port);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t which_portCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t special_portType = {
		/* msgt_name = */		19,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->which_portType != * (int *) &which_portCheck)
#else	UseStaticMsgType
	if ((In0P->which_portType.msgt_inline != TRUE) ||
	    (In0P->which_portType.msgt_longform != FALSE) ||
	    (In0P->which_portType.msgt_name != 2) ||
	    (In0P->which_portType.msgt_number != 1) ||
	    (In0P->which_portType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = thread_get_special_port(In0P->Head.msgh_request_port, In0P->which_port, &OutP->special_port);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->special_portType = special_portType;
#else	UseStaticMsgType
	OutP->special_portType.msgt_name = 19;
	OutP->special_portType.msgt_size = 32;
	OutP->special_portType.msgt_number = 1;
	OutP->special_portType.msgt_inline = TRUE;
	OutP->special_portType.msgt_longform = FALSE;
	OutP->special_portType.msgt_deallocate = FALSE;
	OutP->special_portType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine thread_set_special_port */
mig_internal novalue _Xthread_set_special_port
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t which_portType;
		int which_port;
		mach_msg_type_t special_portType;
		mach_port_t special_port;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t thread_set_special_port
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t thread, int which_port, mach_port_t special_port);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t which_portCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t special_portCheck = {
		/* msgt_name = */		17,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->which_portType != * (int *) &which_portCheck)
#else	UseStaticMsgType
	if ((In0P->which_portType.msgt_inline != TRUE) ||
	    (In0P->which_portType.msgt_longform != FALSE) ||
	    (In0P->which_portType.msgt_name != 2) ||
	    (In0P->which_portType.msgt_number != 1) ||
	    (In0P->which_portType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->special_portType != * (int *) &special_portCheck)
#else	UseStaticMsgType
	if ((In0P->special_portType.msgt_inline != TRUE) ||
	    (In0P->special_portType.msgt_longform != FALSE) ||
	    (In0P->special_portType.msgt_name != 17) ||
	    (In0P->special_portType.msgt_number != 1) ||
	    (In0P->special_portType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = thread_set_special_port(In0P->Head.msgh_request_port, In0P->which_port, In0P->special_port);
}

/* Routine xxx_thread_info */
mig_internal novalue _Xxxx_thread_info
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t flavorType;
		int flavor;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_long_t thread_info_outType;
		int thread_info_out[1024];
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t xxx_thread_info
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_thread, int flavor, thread_info_t thread_info_out, mach_msg_type_number_t *thread_info_outCnt);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t flavorCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t thread_info_outType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	2,
		/* msgtl_size = */	32,
		/* msgtl_number = */	1024,
	};
#endif	UseStaticMsgType

	mach_msg_type_number_t thread_info_outCnt;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->flavorType != * (int *) &flavorCheck)
#else	UseStaticMsgType
	if ((In0P->flavorType.msgt_inline != TRUE) ||
	    (In0P->flavorType.msgt_longform != FALSE) ||
	    (In0P->flavorType.msgt_name != 2) ||
	    (In0P->flavorType.msgt_number != 1) ||
	    (In0P->flavorType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	thread_info_outCnt = 1024;

	OutP->RetCode = xxx_thread_info(In0P->Head.msgh_request_port, In0P->flavor, OutP->thread_info_out, &thread_info_outCnt);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

#if	UseStaticMsgType
	OutP->thread_info_outType = thread_info_outType;
#else	UseStaticMsgType
	OutP->thread_info_outType.msgtl_name = 2;
	OutP->thread_info_outType.msgtl_size = 32;
	OutP->thread_info_outType.msgtl_header.msgt_name = 0;
	OutP->thread_info_outType.msgtl_header.msgt_size = 0;
	OutP->thread_info_outType.msgtl_header.msgt_number = 0;
	OutP->thread_info_outType.msgtl_header.msgt_inline = TRUE;
	OutP->thread_info_outType.msgtl_header.msgt_longform = TRUE;
	OutP->thread_info_outType.msgtl_header.msgt_deallocate = FALSE;
	OutP->thread_info_outType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType

	OutP->thread_info_outType.msgtl_number = thread_info_outCnt;
	OutP->Head.msgh_size = 44 + (4 * thread_info_outCnt);
}

/* Routine task_set_emulation */
mig_internal novalue _Xtask_set_emulation
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t routine_entry_ptType;
		vm_address_t routine_entry_pt;
		mach_msg_type_t routine_numberType;
		int routine_number;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t task_set_emulation
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_port, vm_address_t routine_entry_pt, int routine_number);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t routine_entry_ptCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t routine_numberCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->routine_entry_ptType != * (int *) &routine_entry_ptCheck)
#else	UseStaticMsgType
	if ((In0P->routine_entry_ptType.msgt_inline != TRUE) ||
	    (In0P->routine_entry_ptType.msgt_longform != FALSE) ||
	    (In0P->routine_entry_ptType.msgt_name != 2) ||
	    (In0P->routine_entry_ptType.msgt_number != 1) ||
	    (In0P->routine_entry_ptType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->routine_numberType != * (int *) &routine_numberCheck)
#else	UseStaticMsgType
	if ((In0P->routine_numberType.msgt_inline != TRUE) ||
	    (In0P->routine_numberType.msgt_longform != FALSE) ||
	    (In0P->routine_numberType.msgt_name != 2) ||
	    (In0P->routine_numberType.msgt_number != 1) ||
	    (In0P->routine_numberType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = task_set_emulation(In0P->Head.msgh_request_port, In0P->routine_entry_pt, In0P->routine_number);
}

/* Routine task_set_ras_pc */
mig_internal novalue _Xtask_set_ras_pc
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t basepcType;
		vm_address_t basepc;
		mach_msg_type_t boundspcType;
		vm_address_t boundspc;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t task_set_ras_pc
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_task, vm_address_t basepc, vm_address_t boundspc);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t basepcCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t boundspcCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->basepcType != * (int *) &basepcCheck)
#else	UseStaticMsgType
	if ((In0P->basepcType.msgt_inline != TRUE) ||
	    (In0P->basepcType.msgt_longform != FALSE) ||
	    (In0P->basepcType.msgt_name != 2) ||
	    (In0P->basepcType.msgt_number != 1) ||
	    (In0P->basepcType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->boundspcType != * (int *) &boundspcCheck)
#else	UseStaticMsgType
	if ((In0P->boundspcType.msgt_inline != TRUE) ||
	    (In0P->boundspcType.msgt_longform != FALSE) ||
	    (In0P->boundspcType.msgt_name != 2) ||
	    (In0P->boundspcType.msgt_number != 1) ||
	    (In0P->boundspcType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = task_set_ras_pc(In0P->Head.msgh_request_port, In0P->basepc, In0P->boundspc);
}

/* Routine vm_map */
mig_internal novalue _Xvm_map
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t addressType;
		vm_address_t address;
		mach_msg_type_t sizeType;
		vm_size_t size;
		mach_msg_type_t maskType;
		vm_address_t mask;
		mach_msg_type_t anywhereType;
		boolean_t anywhere;
		mach_msg_type_t memory_objectType;
		mach_port_t memory_object;
		mach_msg_type_t offsetType;
		vm_offset_t offset;
		mach_msg_type_t copyType;
		boolean_t copy;
		mach_msg_type_t cur_protectionType;
		vm_prot_t cur_protection;
		mach_msg_type_t max_protectionType;
		vm_prot_t max_protection;
		mach_msg_type_t inheritanceType;
		vm_inherit_t inheritance;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t addressType;
		vm_address_t address;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t vm_map
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_task, vm_address_t *address, vm_size_t size, vm_address_t mask, boolean_t anywhere, mach_port_t memory_object, vm_offset_t offset, boolean_t copy, vm_prot_t cur_protection, vm_prot_t max_protection, vm_inherit_t inheritance);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t addressCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t sizeCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t maskCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t anywhereCheck = {
		/* msgt_name = */		0,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t memory_objectCheck = {
		/* msgt_name = */		17,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t offsetCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t copyCheck = {
		/* msgt_name = */		0,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t cur_protectionCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t max_protectionCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t inheritanceCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t addressType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 104) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->addressType != * (int *) &addressCheck)
#else	UseStaticMsgType
	if ((In0P->addressType.msgt_inline != TRUE) ||
	    (In0P->addressType.msgt_longform != FALSE) ||
	    (In0P->addressType.msgt_name != 2) ||
	    (In0P->addressType.msgt_number != 1) ||
	    (In0P->addressType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->sizeType != * (int *) &sizeCheck)
#else	UseStaticMsgType
	if ((In0P->sizeType.msgt_inline != TRUE) ||
	    (In0P->sizeType.msgt_longform != FALSE) ||
	    (In0P->sizeType.msgt_name != 2) ||
	    (In0P->sizeType.msgt_number != 1) ||
	    (In0P->sizeType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->maskType != * (int *) &maskCheck)
#else	UseStaticMsgType
	if ((In0P->maskType.msgt_inline != TRUE) ||
	    (In0P->maskType.msgt_longform != FALSE) ||
	    (In0P->maskType.msgt_name != 2) ||
	    (In0P->maskType.msgt_number != 1) ||
	    (In0P->maskType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->anywhereType != * (int *) &anywhereCheck)
#else	UseStaticMsgType
	if ((In0P->anywhereType.msgt_inline != TRUE) ||
	    (In0P->anywhereType.msgt_longform != FALSE) ||
	    (In0P->anywhereType.msgt_name != 0) ||
	    (In0P->anywhereType.msgt_number != 1) ||
	    (In0P->anywhereType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->memory_objectType != * (int *) &memory_objectCheck)
#else	UseStaticMsgType
	if ((In0P->memory_objectType.msgt_inline != TRUE) ||
	    (In0P->memory_objectType.msgt_longform != FALSE) ||
	    (In0P->memory_objectType.msgt_name != 17) ||
	    (In0P->memory_objectType.msgt_number != 1) ||
	    (In0P->memory_objectType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->offsetType != * (int *) &offsetCheck)
#else	UseStaticMsgType
	if ((In0P->offsetType.msgt_inline != TRUE) ||
	    (In0P->offsetType.msgt_longform != FALSE) ||
	    (In0P->offsetType.msgt_name != 2) ||
	    (In0P->offsetType.msgt_number != 1) ||
	    (In0P->offsetType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->copyType != * (int *) &copyCheck)
#else	UseStaticMsgType
	if ((In0P->copyType.msgt_inline != TRUE) ||
	    (In0P->copyType.msgt_longform != FALSE) ||
	    (In0P->copyType.msgt_name != 0) ||
	    (In0P->copyType.msgt_number != 1) ||
	    (In0P->copyType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->cur_protectionType != * (int *) &cur_protectionCheck)
#else	UseStaticMsgType
	if ((In0P->cur_protectionType.msgt_inline != TRUE) ||
	    (In0P->cur_protectionType.msgt_longform != FALSE) ||
	    (In0P->cur_protectionType.msgt_name != 2) ||
	    (In0P->cur_protectionType.msgt_number != 1) ||
	    (In0P->cur_protectionType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->max_protectionType != * (int *) &max_protectionCheck)
#else	UseStaticMsgType
	if ((In0P->max_protectionType.msgt_inline != TRUE) ||
	    (In0P->max_protectionType.msgt_longform != FALSE) ||
	    (In0P->max_protectionType.msgt_name != 2) ||
	    (In0P->max_protectionType.msgt_number != 1) ||
	    (In0P->max_protectionType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->inheritanceType != * (int *) &inheritanceCheck)
#else	UseStaticMsgType
	if ((In0P->inheritanceType.msgt_inline != TRUE) ||
	    (In0P->inheritanceType.msgt_longform != FALSE) ||
	    (In0P->inheritanceType.msgt_name != 2) ||
	    (In0P->inheritanceType.msgt_number != 1) ||
	    (In0P->inheritanceType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = vm_map(In0P->Head.msgh_request_port, &In0P->address, In0P->size, In0P->mask, In0P->anywhere, In0P->memory_object, In0P->offset, In0P->copy, In0P->cur_protection, In0P->max_protection, In0P->inheritance);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->addressType = addressType;
#else	UseStaticMsgType
	OutP->addressType.msgt_name = 2;
	OutP->addressType.msgt_size = 32;
	OutP->addressType.msgt_number = 1;
	OutP->addressType.msgt_inline = TRUE;
	OutP->addressType.msgt_longform = FALSE;
	OutP->addressType.msgt_deallocate = FALSE;
	OutP->addressType.msgt_unused = 0;
#endif	UseStaticMsgType

	OutP->address = In0P->address;
}

/* SimpleRoutine memory_object_data_error */
mig_internal novalue _Xmemory_object_data_error
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t offsetType;
		vm_offset_t offset;
		mach_msg_type_t sizeType;
		vm_size_t size;
		mach_msg_type_t error_valueType;
		kern_return_t error_value;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t memory_object_data_error
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t memory_control, vm_offset_t offset, vm_size_t size, kern_return_t error_value);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t offsetCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t sizeCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t error_valueCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 48) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->offsetType != * (int *) &offsetCheck)
#else	UseStaticMsgType
	if ((In0P->offsetType.msgt_inline != TRUE) ||
	    (In0P->offsetType.msgt_longform != FALSE) ||
	    (In0P->offsetType.msgt_name != 2) ||
	    (In0P->offsetType.msgt_number != 1) ||
	    (In0P->offsetType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->sizeType != * (int *) &sizeCheck)
#else	UseStaticMsgType
	if ((In0P->sizeType.msgt_inline != TRUE) ||
	    (In0P->sizeType.msgt_longform != FALSE) ||
	    (In0P->sizeType.msgt_name != 2) ||
	    (In0P->sizeType.msgt_number != 1) ||
	    (In0P->sizeType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->error_valueType != * (int *) &error_valueCheck)
#else	UseStaticMsgType
	if ((In0P->error_valueType.msgt_inline != TRUE) ||
	    (In0P->error_valueType.msgt_longform != FALSE) ||
	    (In0P->error_valueType.msgt_name != 2) ||
	    (In0P->error_valueType.msgt_number != 1) ||
	    (In0P->error_valueType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = memory_object_data_error(In0P->Head.msgh_request_port, In0P->offset, In0P->size, In0P->error_value);
}

/* SimpleRoutine memory_object_set_attributes */
mig_internal novalue _Xmemory_object_set_attributes
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t object_readyType;
		boolean_t object_ready;
		mach_msg_type_t may_cacheType;
		boolean_t may_cache;
		mach_msg_type_t copy_strategyType;
		memory_object_copy_strategy_t copy_strategy;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t memory_object_set_attributes
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t memory_control, boolean_t object_ready, boolean_t may_cache, memory_object_copy_strategy_t copy_strategy);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t object_readyCheck = {
		/* msgt_name = */		0,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t may_cacheCheck = {
		/* msgt_name = */		0,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t copy_strategyCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 48) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->object_readyType != * (int *) &object_readyCheck)
#else	UseStaticMsgType
	if ((In0P->object_readyType.msgt_inline != TRUE) ||
	    (In0P->object_readyType.msgt_longform != FALSE) ||
	    (In0P->object_readyType.msgt_name != 0) ||
	    (In0P->object_readyType.msgt_number != 1) ||
	    (In0P->object_readyType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->may_cacheType != * (int *) &may_cacheCheck)
#else	UseStaticMsgType
	if ((In0P->may_cacheType.msgt_inline != TRUE) ||
	    (In0P->may_cacheType.msgt_longform != FALSE) ||
	    (In0P->may_cacheType.msgt_name != 0) ||
	    (In0P->may_cacheType.msgt_number != 1) ||
	    (In0P->may_cacheType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->copy_strategyType != * (int *) &copy_strategyCheck)
#else	UseStaticMsgType
	if ((In0P->copy_strategyType.msgt_inline != TRUE) ||
	    (In0P->copy_strategyType.msgt_longform != FALSE) ||
	    (In0P->copy_strategyType.msgt_name != 2) ||
	    (In0P->copy_strategyType.msgt_number != 1) ||
	    (In0P->copy_strategyType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = memory_object_set_attributes(In0P->Head.msgh_request_port, In0P->object_ready, In0P->may_cache, In0P->copy_strategy);
}

/* SimpleRoutine memory_object_destroy */
mig_internal novalue _Xmemory_object_destroy
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t reasonType;
		kern_return_t reason;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t memory_object_destroy
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t memory_control, kern_return_t reason);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t reasonCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->reasonType != * (int *) &reasonCheck)
#else	UseStaticMsgType
	if ((In0P->reasonType.msgt_inline != TRUE) ||
	    (In0P->reasonType.msgt_longform != FALSE) ||
	    (In0P->reasonType.msgt_name != 2) ||
	    (In0P->reasonType.msgt_number != 1) ||
	    (In0P->reasonType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = memory_object_destroy(In0P->Head.msgh_request_port, In0P->reason);
}

/* SimpleRoutine memory_object_data_supply */
mig_internal novalue _Xmemory_object_data_supply
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t offsetType;
		vm_offset_t offset;
		mach_msg_type_long_t dataType;
		vm_offset_t data;
		mach_msg_type_t lock_valueType;
		vm_prot_t lock_value;
		mach_msg_type_t preciousType;
		boolean_t precious;
		mach_msg_type_t reply_toType;
		mach_port_t reply_to;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t memory_object_data_supply
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t memory_control, vm_offset_t offset, vm_offset_t data, mach_msg_type_number_t dataCnt, vm_prot_t lock_value, boolean_t precious, mach_port_t reply_to, mach_msg_type_name_t reply_toPoly);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t offsetCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t lock_valueCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t preciousCheck = {
		/* msgt_name = */		0,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 72) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->offsetType != * (int *) &offsetCheck)
#else	UseStaticMsgType
	if ((In0P->offsetType.msgt_inline != TRUE) ||
	    (In0P->offsetType.msgt_longform != FALSE) ||
	    (In0P->offsetType.msgt_name != 2) ||
	    (In0P->offsetType.msgt_number != 1) ||
	    (In0P->offsetType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if ((In0P->dataType.msgtl_header.msgt_inline != FALSE) ||
	    (In0P->dataType.msgtl_header.msgt_longform != TRUE) ||
	    (In0P->dataType.msgtl_name != 9) ||
	    (In0P->dataType.msgtl_size != 8))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->lock_valueType != * (int *) &lock_valueCheck)
#else	UseStaticMsgType
	if ((In0P->lock_valueType.msgt_inline != TRUE) ||
	    (In0P->lock_valueType.msgt_longform != FALSE) ||
	    (In0P->lock_valueType.msgt_name != 2) ||
	    (In0P->lock_valueType.msgt_number != 1) ||
	    (In0P->lock_valueType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->preciousType != * (int *) &preciousCheck)
#else	UseStaticMsgType
	if ((In0P->preciousType.msgt_inline != TRUE) ||
	    (In0P->preciousType.msgt_longform != FALSE) ||
	    (In0P->preciousType.msgt_name != 0) ||
	    (In0P->preciousType.msgt_number != 1) ||
	    (In0P->preciousType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if ((In0P->reply_toType.msgt_inline != TRUE) ||
	    (In0P->reply_toType.msgt_longform != FALSE) ||
	    (In0P->reply_toType.msgt_number != 1) ||
	    (In0P->reply_toType.msgt_size != 32))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = memory_object_data_supply(In0P->Head.msgh_request_port, In0P->offset, In0P->data, In0P->dataType.msgtl_number, In0P->lock_value, In0P->precious, In0P->reply_to, In0P->reply_toType.msgt_name);
}

/* SimpleRoutine memory_object_ready */
mig_internal novalue _Xmemory_object_ready
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t may_cacheType;
		boolean_t may_cache;
		mach_msg_type_t copy_strategyType;
		memory_object_copy_strategy_t copy_strategy;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t memory_object_ready
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t memory_control, boolean_t may_cache, memory_object_copy_strategy_t copy_strategy);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t may_cacheCheck = {
		/* msgt_name = */		0,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t copy_strategyCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->may_cacheType != * (int *) &may_cacheCheck)
#else	UseStaticMsgType
	if ((In0P->may_cacheType.msgt_inline != TRUE) ||
	    (In0P->may_cacheType.msgt_longform != FALSE) ||
	    (In0P->may_cacheType.msgt_name != 0) ||
	    (In0P->may_cacheType.msgt_number != 1) ||
	    (In0P->may_cacheType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->copy_strategyType != * (int *) &copy_strategyCheck)
#else	UseStaticMsgType
	if ((In0P->copy_strategyType.msgt_inline != TRUE) ||
	    (In0P->copy_strategyType.msgt_longform != FALSE) ||
	    (In0P->copy_strategyType.msgt_name != 2) ||
	    (In0P->copy_strategyType.msgt_number != 1) ||
	    (In0P->copy_strategyType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = memory_object_ready(In0P->Head.msgh_request_port, In0P->may_cache, In0P->copy_strategy);
}

/* SimpleRoutine memory_object_change_attributes */
mig_internal novalue _Xmemory_object_change_attributes
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t may_cacheType;
		boolean_t may_cache;
		mach_msg_type_t copy_strategyType;
		memory_object_copy_strategy_t copy_strategy;
		mach_msg_type_t reply_toType;
		mach_port_t reply_to;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t memory_object_change_attributes
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t memory_control, boolean_t may_cache, memory_object_copy_strategy_t copy_strategy, mach_port_t reply_to, mach_msg_type_name_t reply_toPoly);
#else
		();
#endif

#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck

#if	UseStaticMsgType
	static mach_msg_type_t may_cacheCheck = {
		/* msgt_name = */		0,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t copy_strategyCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	msgh_simple = !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
	if ((In0P->Head.msgh_size != 48))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->may_cacheType != * (int *) &may_cacheCheck)
#else	UseStaticMsgType
	if ((In0P->may_cacheType.msgt_inline != TRUE) ||
	    (In0P->may_cacheType.msgt_longform != FALSE) ||
	    (In0P->may_cacheType.msgt_name != 0) ||
	    (In0P->may_cacheType.msgt_number != 1) ||
	    (In0P->may_cacheType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->copy_strategyType != * (int *) &copy_strategyCheck)
#else	UseStaticMsgType
	if ((In0P->copy_strategyType.msgt_inline != TRUE) ||
	    (In0P->copy_strategyType.msgt_longform != FALSE) ||
	    (In0P->copy_strategyType.msgt_name != 2) ||
	    (In0P->copy_strategyType.msgt_number != 1) ||
	    (In0P->copy_strategyType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if ((In0P->reply_toType.msgt_inline != TRUE) ||
	    (In0P->reply_toType.msgt_longform != FALSE) ||
	    (MACH_MSG_TYPE_PORT_ANY(In0P->reply_toType.msgt_name) && msgh_simple) ||
	    (In0P->reply_toType.msgt_number != 1) ||
	    (In0P->reply_toType.msgt_size != 32))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = memory_object_change_attributes(In0P->Head.msgh_request_port, In0P->may_cache, In0P->copy_strategy, In0P->reply_to, In0P->reply_toType.msgt_name);
}

/* Routine vm_machine_attribute */
mig_internal novalue _Xvm_machine_attribute
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t addressType;
		vm_address_t address;
		mach_msg_type_t sizeType;
		vm_size_t size;
		mach_msg_type_t attributeType;
		vm_machine_attribute_t attribute;
		mach_msg_type_t valueType;
		vm_machine_attribute_val_t value;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t valueType;
		vm_machine_attribute_val_t value;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t vm_machine_attribute
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_task, vm_address_t address, vm_size_t size, vm_machine_attribute_t attribute, vm_machine_attribute_val_t *value);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t addressCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t sizeCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t attributeCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t valueCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t valueType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 56) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->addressType != * (int *) &addressCheck)
#else	UseStaticMsgType
	if ((In0P->addressType.msgt_inline != TRUE) ||
	    (In0P->addressType.msgt_longform != FALSE) ||
	    (In0P->addressType.msgt_name != 2) ||
	    (In0P->addressType.msgt_number != 1) ||
	    (In0P->addressType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->sizeType != * (int *) &sizeCheck)
#else	UseStaticMsgType
	if ((In0P->sizeType.msgt_inline != TRUE) ||
	    (In0P->sizeType.msgt_longform != FALSE) ||
	    (In0P->sizeType.msgt_name != 2) ||
	    (In0P->sizeType.msgt_number != 1) ||
	    (In0P->sizeType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->attributeType != * (int *) &attributeCheck)
#else	UseStaticMsgType
	if ((In0P->attributeType.msgt_inline != TRUE) ||
	    (In0P->attributeType.msgt_longform != FALSE) ||
	    (In0P->attributeType.msgt_name != 2) ||
	    (In0P->attributeType.msgt_number != 1) ||
	    (In0P->attributeType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->valueType != * (int *) &valueCheck)
#else	UseStaticMsgType
	if ((In0P->valueType.msgt_inline != TRUE) ||
	    (In0P->valueType.msgt_longform != FALSE) ||
	    (In0P->valueType.msgt_name != 2) ||
	    (In0P->valueType.msgt_number != 1) ||
	    (In0P->valueType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = vm_machine_attribute(In0P->Head.msgh_request_port, In0P->address, In0P->size, In0P->attribute, &In0P->value);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->valueType = valueType;
#else	UseStaticMsgType
	OutP->valueType.msgt_name = 2;
	OutP->valueType.msgt_size = 32;
	OutP->valueType.msgt_number = 1;
	OutP->valueType.msgt_inline = TRUE;
	OutP->valueType.msgt_longform = FALSE;
	OutP->valueType.msgt_deallocate = FALSE;
	OutP->valueType.msgt_unused = 0;
#endif	UseStaticMsgType

	OutP->value = In0P->value;
}

static mig_routine_t mach_server_routines[] = {
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		_Xtask_create,
		_Xtask_terminate,
		_Xtask_get_emulation_vector,
		_Xtask_set_emulation_vector,
		_Xtask_threads,
		_Xtask_info,
		0,
		0,
		0,
		_Xthread_terminate,
		_Xthread_get_state,
		_Xthread_set_state,
		_Xthread_info,
		0,
		_Xvm_allocate,
		0,
		_Xvm_deallocate,
		_Xvm_protect,
		_Xvm_inherit,
		_Xvm_read,
		_Xvm_write,
		_Xvm_copy,
		_Xvm_region,
		_Xvm_statistics,
		0,
		0,
		_Xmach_ports_register,
		_Xmach_ports_lookup,
		0,
		0,
		0,
		_Xmemory_object_data_provided,
		_Xmemory_object_data_unavailable,
		_Xmemory_object_get_attributes,
		_Xvm_set_default_memory_manager,
		0,
		_Xxxx_memory_object_lock_request,
		_Xmemory_object_lock_request,
		_Xxxx_task_get_emulation_vector,
		_Xxxx_task_set_emulation_vector,
		_Xxxx_host_info,
		_Xxxx_slot_info,
		_Xxxx_cpu_control,
		0,
		0,
		0,
		0,
		0,
		0,
		_Xtask_suspend,
		_Xtask_resume,
		_Xtask_get_special_port,
		_Xtask_set_special_port,
		_Xxxx_task_info,
		_Xthread_create,
		_Xthread_suspend,
		_Xthread_resume,
		_Xthread_abort,
		_Xxxx_thread_get_state,
		_Xxxx_thread_set_state,
		_Xthread_get_special_port,
		_Xthread_set_special_port,
		_Xxxx_thread_info,
		_Xtask_set_emulation,
		_Xtask_set_ras_pc,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		_Xvm_map,
		_Xmemory_object_data_error,
		_Xmemory_object_set_attributes,
		_Xmemory_object_destroy,
		_Xmemory_object_data_supply,
		_Xmemory_object_ready,
		_Xmemory_object_change_attributes,
		0,
		0,
		0,
		_Xvm_machine_attribute,
			0,
};

mig_external boolean_t mach_server
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	register mach_msg_header_t *InP =  InHeadP;
	register mig_reply_header_t *OutP = (mig_reply_header_t *) OutHeadP;

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	register mig_routine_t routine;

	OutP->Head.msgh_bits = MACH_MSGH_BITS(MACH_MSGH_BITS_REPLY(InP->msgh_bits), 0);
	OutP->Head.msgh_size = sizeof *OutP;
	OutP->Head.msgh_remote_port = InP->msgh_reply_port;
	OutP->Head.msgh_local_port = MACH_PORT_NULL;
	OutP->Head.msgh_seqno = 0;
	OutP->Head.msgh_id = InP->msgh_id + 100;

#if	UseStaticMsgType
	OutP->RetCodeType = RetCodeType;
#else	UseStaticMsgType
	OutP->RetCodeType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->RetCodeType.msgt_size = 32;
	OutP->RetCodeType.msgt_number = 1;
	OutP->RetCodeType.msgt_inline = TRUE;
	OutP->RetCodeType.msgt_longform = FALSE;
	OutP->RetCodeType.msgt_deallocate = FALSE;
	OutP->RetCodeType.msgt_unused = 0;
#endif	UseStaticMsgType

	if ((InP->msgh_id > 2100) || (InP->msgh_id < 2000) ||
	    ((routine = mach_server_routines[InP->msgh_id - 2000]) == 0)) {
		OutP->RetCode = MIG_BAD_ID;
		return FALSE;
	}
	(*routine) (InP, &OutP->Head);
	return TRUE;
}

mig_external mig_routine_t mach_server_routine
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP)
#else
	(InHeadP)
	mach_msg_header_t *InHeadP;
#endif
{
	register int msgh_id;

	msgh_id = InHeadP->msgh_id - 2000;

	if ((msgh_id > 100) || (msgh_id < 0))
		return 0;

	return mach_server_routines[msgh_id];
}

