/* Module mach_norma */

#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/mig_errors.h>

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

/* Due to pcc compiler bug, cannot use void */
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(hc)
#define novalue void
#else
#define novalue int
#endif

#define msgh_request_port	msgh_local_port
#define MACH_MSGH_BITS_REQUEST(bits)	MACH_MSGH_BITS_LOCAL(bits)
#define msgh_reply_port		msgh_remote_port
#define MACH_MSGH_BITS_REPLY(bits)	MACH_MSGH_BITS_REMOTE(bits)

#include <mach/std_types.h>
#include <mach/mach_types.h>

/* Routine task_set_child_node */
mig_internal novalue _Xtask_set_child_node
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t child_nodeType;
		int child_node;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t task_set_child_node
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_task, int child_node);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t child_nodeCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->child_nodeType != * (int *) &child_nodeCheck)
#else	UseStaticMsgType
	if ((In0P->child_nodeType.msgt_inline != TRUE) ||
	    (In0P->child_nodeType.msgt_longform != FALSE) ||
	    (In0P->child_nodeType.msgt_name != 2) ||
	    (In0P->child_nodeType.msgt_number != 1) ||
	    (In0P->child_nodeType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = task_set_child_node(In0P->Head.msgh_request_port, In0P->child_node);
}

/* Routine norma_node_self */
mig_internal novalue _Xnorma_node_self
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t nodeType;
		int node;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t norma_node_self
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t host, int *node);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t nodeType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = norma_node_self(In0P->Head.msgh_request_port, &OutP->node);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->nodeType = nodeType;
#else	UseStaticMsgType
	OutP->nodeType.msgt_name = 2;
	OutP->nodeType.msgt_size = 32;
	OutP->nodeType.msgt_number = 1;
	OutP->nodeType.msgt_inline = TRUE;
	OutP->nodeType.msgt_longform = FALSE;
	OutP->nodeType.msgt_deallocate = FALSE;
	OutP->nodeType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine norma_task_create */
mig_internal novalue _Xnorma_task_create
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t inherit_memoryType;
		boolean_t inherit_memory;
		mach_msg_type_t child_nodeType;
		int child_node;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t child_taskType;
		mach_port_t child_task;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t norma_task_create
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t target_task, boolean_t inherit_memory, int child_node, mach_port_t *child_task);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t inherit_memoryCheck = {
		/* msgt_name = */		0,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t child_nodeCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t child_taskType = {
		/* msgt_name = */		19,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->inherit_memoryType != * (int *) &inherit_memoryCheck)
#else	UseStaticMsgType
	if ((In0P->inherit_memoryType.msgt_inline != TRUE) ||
	    (In0P->inherit_memoryType.msgt_longform != FALSE) ||
	    (In0P->inherit_memoryType.msgt_name != 0) ||
	    (In0P->inherit_memoryType.msgt_number != 1) ||
	    (In0P->inherit_memoryType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->child_nodeType != * (int *) &child_nodeCheck)
#else	UseStaticMsgType
	if ((In0P->child_nodeType.msgt_inline != TRUE) ||
	    (In0P->child_nodeType.msgt_longform != FALSE) ||
	    (In0P->child_nodeType.msgt_name != 2) ||
	    (In0P->child_nodeType.msgt_number != 1) ||
	    (In0P->child_nodeType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = norma_task_create(In0P->Head.msgh_request_port, In0P->inherit_memory, In0P->child_node, &OutP->child_task);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->child_taskType = child_taskType;
#else	UseStaticMsgType
	OutP->child_taskType.msgt_name = 19;
	OutP->child_taskType.msgt_size = 32;
	OutP->child_taskType.msgt_number = 1;
	OutP->child_taskType.msgt_inline = TRUE;
	OutP->child_taskType.msgt_longform = FALSE;
	OutP->child_taskType.msgt_deallocate = FALSE;
	OutP->child_taskType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine norma_get_special_port */
mig_internal novalue _Xnorma_get_special_port
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t nodeType;
		int node;
		mach_msg_type_t whichType;
		int which;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t portType;
		mach_port_t port;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t norma_get_special_port
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t host_priv, int node, int which, mach_port_t *port);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t nodeCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t whichCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t portType = {
		/* msgt_name = */		19,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->nodeType != * (int *) &nodeCheck)
#else	UseStaticMsgType
	if ((In0P->nodeType.msgt_inline != TRUE) ||
	    (In0P->nodeType.msgt_longform != FALSE) ||
	    (In0P->nodeType.msgt_name != 2) ||
	    (In0P->nodeType.msgt_number != 1) ||
	    (In0P->nodeType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->whichType != * (int *) &whichCheck)
#else	UseStaticMsgType
	if ((In0P->whichType.msgt_inline != TRUE) ||
	    (In0P->whichType.msgt_longform != FALSE) ||
	    (In0P->whichType.msgt_name != 2) ||
	    (In0P->whichType.msgt_number != 1) ||
	    (In0P->whichType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = norma_get_special_port(In0P->Head.msgh_request_port, In0P->node, In0P->which, &OutP->port);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->portType = portType;
#else	UseStaticMsgType
	OutP->portType.msgt_name = 19;
	OutP->portType.msgt_size = 32;
	OutP->portType.msgt_number = 1;
	OutP->portType.msgt_inline = TRUE;
	OutP->portType.msgt_longform = FALSE;
	OutP->portType.msgt_deallocate = FALSE;
	OutP->portType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine norma_set_special_port */
mig_internal novalue _Xnorma_set_special_port
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t whichType;
		int which;
		mach_msg_type_t portType;
		mach_port_t port;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t norma_set_special_port
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t host_priv, int which, mach_port_t port);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t whichCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t portCheck = {
		/* msgt_name = */		17,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->whichType != * (int *) &whichCheck)
#else	UseStaticMsgType
	if ((In0P->whichType.msgt_inline != TRUE) ||
	    (In0P->whichType.msgt_longform != FALSE) ||
	    (In0P->whichType.msgt_name != 2) ||
	    (In0P->whichType.msgt_number != 1) ||
	    (In0P->whichType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->portType != * (int *) &portCheck)
#else	UseStaticMsgType
	if ((In0P->portType.msgt_inline != TRUE) ||
	    (In0P->portType.msgt_longform != FALSE) ||
	    (In0P->portType.msgt_name != 17) ||
	    (In0P->portType.msgt_number != 1) ||
	    (In0P->portType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = norma_set_special_port(In0P->Head.msgh_request_port, In0P->which, In0P->port);
}

/* Routine norma_port_location_hint */
mig_internal novalue _Xnorma_port_location_hint
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t portType;
		mach_port_t port;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t nodeType;
		int node;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t norma_port_location_hint
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t task, mach_port_t port, int *node);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t portCheck = {
		/* msgt_name = */		17,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t nodeType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->portType != * (int *) &portCheck)
#else	UseStaticMsgType
	if ((In0P->portType.msgt_inline != TRUE) ||
	    (In0P->portType.msgt_longform != FALSE) ||
	    (In0P->portType.msgt_name != 17) ||
	    (In0P->portType.msgt_number != 1) ||
	    (In0P->portType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = norma_port_location_hint(In0P->Head.msgh_request_port, In0P->port, &OutP->node);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->nodeType = nodeType;
#else	UseStaticMsgType
	OutP->nodeType.msgt_name = 2;
	OutP->nodeType.msgt_size = 32;
	OutP->nodeType.msgt_number = 1;
	OutP->nodeType.msgt_inline = TRUE;
	OutP->nodeType.msgt_longform = FALSE;
	OutP->nodeType.msgt_deallocate = FALSE;
	OutP->nodeType.msgt_unused = 0;
#endif	UseStaticMsgType
}

static mig_routine_t mach_norma_server_routines[] = {
		0,
		_Xtask_set_child_node,
		_Xnorma_node_self,
		0,
		0,
		0,
		_Xnorma_task_create,
		_Xnorma_get_special_port,
		_Xnorma_set_special_port,
		0,
		0,
		0,
		_Xnorma_port_location_hint,
};

mig_external boolean_t mach_norma_server
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	register mach_msg_header_t *InP =  InHeadP;
	register mig_reply_header_t *OutP = (mig_reply_header_t *) OutHeadP;

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	register mig_routine_t routine;

	OutP->Head.msgh_bits = MACH_MSGH_BITS(MACH_MSGH_BITS_REPLY(InP->msgh_bits), 0);
	OutP->Head.msgh_size = sizeof *OutP;
	OutP->Head.msgh_remote_port = InP->msgh_reply_port;
	OutP->Head.msgh_local_port = MACH_PORT_NULL;
	OutP->Head.msgh_seqno = 0;
	OutP->Head.msgh_id = InP->msgh_id + 100;

#if	UseStaticMsgType
	OutP->RetCodeType = RetCodeType;
#else	UseStaticMsgType
	OutP->RetCodeType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->RetCodeType.msgt_size = 32;
	OutP->RetCodeType.msgt_number = 1;
	OutP->RetCodeType.msgt_inline = TRUE;
	OutP->RetCodeType.msgt_longform = FALSE;
	OutP->RetCodeType.msgt_deallocate = FALSE;
	OutP->RetCodeType.msgt_unused = 0;
#endif	UseStaticMsgType

	if ((InP->msgh_id > 555012) || (InP->msgh_id < 555000) ||
	    ((routine = mach_norma_server_routines[InP->msgh_id - 555000]) == 0)) {
		OutP->RetCode = MIG_BAD_ID;
		return FALSE;
	}
	(*routine) (InP, &OutP->Head);
	return TRUE;
}

mig_external mig_routine_t mach_norma_server_routine
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP)
#else
	(InHeadP)
	mach_msg_header_t *InHeadP;
#endif
{
	register int msgh_id;

	msgh_id = InHeadP->msgh_id - 555000;

	if ((msgh_id > 12) || (msgh_id < 0))
		return 0;

	return mach_norma_server_routines[msgh_id];
}

