/* Module default_pager */

#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/mig_errors.h>

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

/* Due to pcc compiler bug, cannot use void */
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(hc)
#define novalue void
#else
#define novalue int
#endif

#define msgh_request_port	msgh_local_port
#define MACH_MSGH_BITS_REQUEST(bits)	MACH_MSGH_BITS_LOCAL(bits)
#define msgh_reply_port		msgh_remote_port
#define MACH_MSGH_BITS_REPLY(bits)	MACH_MSGH_BITS_REMOTE(bits)

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <mach/default_pager_types.h>

/* Routine default_pager_object_create */
mig_internal novalue _Xdefault_pager_object_create
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t object_sizeType;
		vm_size_t object_size;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t memory_objectType;
		memory_object_t memory_object;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t default_pager_object_create
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t default_pager, memory_object_t *memory_object, vm_size_t object_size);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t object_sizeCheck = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t memory_objectType = {
		/* msgt_name = */		20,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->object_sizeType != * (int *) &object_sizeCheck)
#else	UseStaticMsgType
	if ((In0P->object_sizeType.msgt_inline != TRUE) ||
	    (In0P->object_sizeType.msgt_longform != FALSE) ||
	    (In0P->object_sizeType.msgt_name != 2) ||
	    (In0P->object_sizeType.msgt_number != 1) ||
	    (In0P->object_sizeType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = default_pager_object_create(In0P->Head.msgh_request_port, &OutP->memory_object, In0P->object_size);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->memory_objectType = memory_objectType;
#else	UseStaticMsgType
	OutP->memory_objectType.msgt_name = 20;
	OutP->memory_objectType.msgt_size = 32;
	OutP->memory_objectType.msgt_number = 1;
	OutP->memory_objectType.msgt_inline = TRUE;
	OutP->memory_objectType.msgt_longform = FALSE;
	OutP->memory_objectType.msgt_deallocate = FALSE;
	OutP->memory_objectType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine default_pager_info */
mig_internal novalue _Xdefault_pager_info
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t infoType;
		default_pager_info_t info;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t default_pager_info
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t default_pager, default_pager_info_t *info);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t infoType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		3,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = default_pager_info(In0P->Head.msgh_request_port, &OutP->info);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 48;

#if	UseStaticMsgType
	OutP->infoType = infoType;
#else	UseStaticMsgType
	OutP->infoType.msgt_name = 2;
	OutP->infoType.msgt_size = 32;
	OutP->infoType.msgt_number = 3;
	OutP->infoType.msgt_inline = TRUE;
	OutP->infoType.msgt_longform = FALSE;
	OutP->infoType.msgt_deallocate = FALSE;
	OutP->infoType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine default_pager_objects */
mig_internal novalue _Xdefault_pager_objects
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t objectsCntType;
		mach_msg_type_number_t objectsCnt;
		mach_msg_type_t portsCntType;
		mach_msg_type_number_t portsCnt;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_long_t objectsType;
		default_pager_object_t objects[256];
		mach_msg_type_long_t portsType;
		mach_port_t ports[512];
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t default_pager_objects
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t default_pager, default_pager_object_array_t *objects, mach_msg_type_number_t *objectsCnt, mach_port_array_t *ports, mach_msg_type_number_t *portsCnt);
#else
		();
#endif

	unsigned int msgh_size;
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t objectsCntCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t portsCntCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t objectsType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	2,
		/* msgtl_size = */	32,
		/* msgtl_number = */	512,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t portsType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	17,
		/* msgtl_size = */	32,
		/* msgtl_number = */	512,
	};
#endif	UseStaticMsgType

	mach_msg_type_number_t objectsCnt;
	mach_port_t ports[512];
	mach_msg_type_number_t portsCnt;

	default_pager_object_t *objectsP;
	mach_port_t *portsP;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->objectsCntType != * (int *) &objectsCntCheck)
#else	UseStaticMsgType
	if ((In0P->objectsCntType.msgt_inline != TRUE) ||
	    (In0P->objectsCntType.msgt_longform != FALSE) ||
	    (In0P->objectsCntType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->objectsCntType.msgt_number != 1) ||
	    (In0P->objectsCntType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->portsCntType != * (int *) &portsCntCheck)
#else	UseStaticMsgType
	if ((In0P->portsCntType.msgt_inline != TRUE) ||
	    (In0P->portsCntType.msgt_longform != FALSE) ||
	    (In0P->portsCntType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->portsCntType.msgt_number != 1) ||
	    (In0P->portsCntType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	objectsP = OutP->objects;
	objectsCnt = 256;
	if (In0P->objectsCnt < objectsCnt)
		objectsCnt = In0P->objectsCnt;

	portsP = ports;
	portsCnt = 512;
	if (In0P->portsCnt < portsCnt)
		portsCnt = In0P->portsCnt;

	OutP->RetCode = default_pager_objects(In0P->Head.msgh_request_port, &objectsP, &objectsCnt, &portsP, &portsCnt);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;

#if	UseStaticMsgType
	OutP->objectsType = objectsType;
#else	UseStaticMsgType
	OutP->objectsType.msgtl_name = 2;
	OutP->objectsType.msgtl_size = 32;
	OutP->objectsType.msgtl_header.msgt_name = 0;
	OutP->objectsType.msgtl_header.msgt_size = 0;
	OutP->objectsType.msgtl_header.msgt_number = 0;
	OutP->objectsType.msgtl_header.msgt_inline = TRUE;
	OutP->objectsType.msgtl_header.msgt_longform = TRUE;
	OutP->objectsType.msgtl_header.msgt_deallocate = FALSE;
	OutP->objectsType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType
	if (objectsP != OutP->objects) {
		OutP->objectsType.msgtl_header.msgt_inline = FALSE;
		OutP->objectsType.msgtl_header.msgt_deallocate = TRUE;
		*((default_pager_object_t **)OutP->objects) = objectsP;
	}

	OutP->objectsType.msgtl_number = 2 * objectsCnt;
	msgh_size_delta = (OutP->objectsType.msgtl_header.msgt_inline) ? 8 * objectsCnt : sizeof(default_pager_object_t *);
	msgh_size = 56 + msgh_size_delta;
	OutP = (Reply *) ((char *) OutP + msgh_size_delta - 2048);

#if	UseStaticMsgType
	OutP->portsType = portsType;
#else	UseStaticMsgType
	OutP->portsType.msgtl_name = 17;
	OutP->portsType.msgtl_size = 32;
	OutP->portsType.msgtl_header.msgt_name = 0;
	OutP->portsType.msgtl_header.msgt_size = 0;
	OutP->portsType.msgtl_header.msgt_number = 0;
	OutP->portsType.msgtl_header.msgt_inline = TRUE;
	OutP->portsType.msgtl_header.msgt_longform = TRUE;
	OutP->portsType.msgtl_header.msgt_deallocate = FALSE;
	OutP->portsType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType

	if (portsP != ports) {
		OutP->portsType.msgtl_header.msgt_inline = FALSE;
		OutP->portsType.msgtl_header.msgt_deallocate = TRUE;
		*((mach_port_t **)OutP->ports) = portsP;
	}
	else {
		bcopy((char *) ports, (char *) OutP->ports, 4 * portsCnt);
	}

	OutP->portsType.msgtl_number = portsCnt;
	msgh_size += (OutP->portsType.msgtl_header.msgt_inline) ? 4 * portsCnt : sizeof(mach_port_t *);

	OutP = (Reply *) OutHeadP;
	OutP->Head.msgh_size = msgh_size;
}

/* Routine default_pager_object_pages */
mig_internal novalue _Xdefault_pager_object_pages
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t memory_objectType;
		mach_port_t memory_object;
		mach_msg_type_t pagesCntType;
		mach_msg_type_number_t pagesCnt;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_long_t pagesType;
		default_pager_page_t pages[512];
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t default_pager_object_pages
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t default_pager, mach_port_t memory_object, default_pager_page_array_t *pages, mach_msg_type_number_t *pagesCnt);
#else
		();
#endif

	boolean_t msgh_simple;
#if	UseStaticMsgType
	static mach_msg_type_t memory_objectCheck = {
		/* msgt_name = */		17,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t pagesCntCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t pagesType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	2,
		/* msgtl_size = */	32,
		/* msgtl_number = */	512,
	};
#endif	UseStaticMsgType

	mach_msg_type_number_t pagesCnt;

	default_pager_page_t *pagesP;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->memory_objectType != * (int *) &memory_objectCheck)
#else	UseStaticMsgType
	if ((In0P->memory_objectType.msgt_inline != TRUE) ||
	    (In0P->memory_objectType.msgt_longform != FALSE) ||
	    (In0P->memory_objectType.msgt_name != 17) ||
	    (In0P->memory_objectType.msgt_number != 1) ||
	    (In0P->memory_objectType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->pagesCntType != * (int *) &pagesCntCheck)
#else	UseStaticMsgType
	if ((In0P->pagesCntType.msgt_inline != TRUE) ||
	    (In0P->pagesCntType.msgt_longform != FALSE) ||
	    (In0P->pagesCntType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->pagesCntType.msgt_number != 1) ||
	    (In0P->pagesCntType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	pagesP = OutP->pages;
	pagesCnt = 512;
	if (In0P->pagesCnt < pagesCnt)
		pagesCnt = In0P->pagesCnt;

	OutP->RetCode = default_pager_object_pages(In0P->Head.msgh_request_port, In0P->memory_object, &pagesP, &pagesCnt);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	msgh_simple = TRUE;

#if	UseStaticMsgType
	OutP->pagesType = pagesType;
#else	UseStaticMsgType
	OutP->pagesType.msgtl_name = 2;
	OutP->pagesType.msgtl_size = 32;
	OutP->pagesType.msgtl_header.msgt_name = 0;
	OutP->pagesType.msgtl_header.msgt_size = 0;
	OutP->pagesType.msgtl_header.msgt_number = 0;
	OutP->pagesType.msgtl_header.msgt_inline = TRUE;
	OutP->pagesType.msgtl_header.msgt_longform = TRUE;
	OutP->pagesType.msgtl_header.msgt_deallocate = FALSE;
	OutP->pagesType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType
	if (pagesP != OutP->pages) {
		OutP->pagesType.msgtl_header.msgt_inline = FALSE;
		OutP->pagesType.msgtl_header.msgt_deallocate = TRUE;
		*((default_pager_page_t **)OutP->pages) = pagesP;
		msgh_simple = FALSE;
	}

	OutP->pagesType.msgtl_number = pagesCnt;
	OutP->Head.msgh_size = 44 + ((OutP->pagesType.msgtl_header.msgt_inline) ? 4 * pagesCnt : sizeof(default_pager_page_t *));

	if (!msgh_simple)
		OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
}

/* Routine default_pager_paging_file */
mig_internal novalue _Xdefault_pager_paging_file
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_long_t filenameType;
		default_pager_filename_t filename;
		mach_msg_type_t addType;
		boolean_t add;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t default_pager_paging_file
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t default_pager, default_pager_filename_t filename, boolean_t add);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t addCheck = {
		/* msgt_name = */		0,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 300) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if ((In0P->filenameType.msgtl_header.msgt_inline != TRUE) ||
	    (In0P->filenameType.msgtl_header.msgt_longform != TRUE) ||
	    (In0P->filenameType.msgtl_name != 12) ||
	    (In0P->filenameType.msgtl_number != 1) ||
	    (In0P->filenameType.msgtl_size != 2048))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->addType != * (int *) &addCheck)
#else	UseStaticMsgType
	if ((In0P->addType.msgt_inline != TRUE) ||
	    (In0P->addType.msgt_longform != FALSE) ||
	    (In0P->addType.msgt_name != 0) ||
	    (In0P->addType.msgt_number != 1) ||
	    (In0P->addType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = default_pager_paging_file(In0P->Head.msgh_request_port, In0P->filename, In0P->add);
}

static mig_routine_t default_pager_server_routines[] = {
		_Xdefault_pager_object_create,
		_Xdefault_pager_info,
		_Xdefault_pager_objects,
		_Xdefault_pager_object_pages,
		_Xdefault_pager_paging_file,
};

mig_external boolean_t default_pager_server
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	register mach_msg_header_t *InP =  InHeadP;
	register mig_reply_header_t *OutP = (mig_reply_header_t *) OutHeadP;

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	register mig_routine_t routine;

	OutP->Head.msgh_bits = MACH_MSGH_BITS(MACH_MSGH_BITS_REPLY(InP->msgh_bits), 0);
	OutP->Head.msgh_size = sizeof *OutP;
	OutP->Head.msgh_remote_port = InP->msgh_reply_port;
	OutP->Head.msgh_local_port = MACH_PORT_NULL;
	OutP->Head.msgh_seqno = 0;
	OutP->Head.msgh_id = InP->msgh_id + 100;

#if	UseStaticMsgType
	OutP->RetCodeType = RetCodeType;
#else	UseStaticMsgType
	OutP->RetCodeType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->RetCodeType.msgt_size = 32;
	OutP->RetCodeType.msgt_number = 1;
	OutP->RetCodeType.msgt_inline = TRUE;
	OutP->RetCodeType.msgt_longform = FALSE;
	OutP->RetCodeType.msgt_deallocate = FALSE;
	OutP->RetCodeType.msgt_unused = 0;
#endif	UseStaticMsgType

	if ((InP->msgh_id > 2279) || (InP->msgh_id < 2275) ||
	    ((routine = default_pager_server_routines[InP->msgh_id - 2275]) == 0)) {
		OutP->RetCode = MIG_BAD_ID;
		return FALSE;
	}
	(*routine) (InP, &OutP->Head);
	return TRUE;
}

mig_external mig_routine_t default_pager_server_routine
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP)
#else
	(InHeadP)
	mach_msg_header_t *InHeadP;
#endif
{
	register int msgh_id;

	msgh_id = InHeadP->msgh_id - 2275;

	if ((msgh_id > 4) || (msgh_id < 0))
		return 0;

	return default_pager_server_routines[msgh_id];
}

