#include "mach_user_kernel.h"
#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/notify.h>
#include <mach/mach_types.h>
#include <mach/mig_errors.h>
#include <mach/msg_type.h>
#ifndef	KERNEL
#include <strings.h>
#endif	KERNEL
/* LINTLIBRARY */

extern mach_port_t mig_get_reply_port();
extern void mig_dealloc_reply_port();

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

#define msgh_request_port	msgh_remote_port
#define msgh_reply_port		msgh_local_port


/* Routine task_set_emulation */
mig_external kern_return_t r_task_set_emulation
#if	(defined(__STDC__) || defined(c_plusplus))
(
	ipc_port_t target_port,
	vm_address_t routine_entry_pt,
	int routine_number
)
#else
	(target_port, routine_entry_pt, routine_number)
	ipc_port_t target_port;
	vm_address_t routine_entry_pt;
	int routine_number;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t routine_entry_ptType;
		vm_address_t routine_entry_pt;
		mach_msg_type_t routine_numberType;
		int routine_number;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;

#if	UseStaticMsgType
	static mach_msg_type_t routine_entry_ptType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t routine_numberType = {
		/* msgt_name = */		2,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->routine_entry_ptType = routine_entry_ptType;
#else	UseStaticMsgType
	InP->routine_entry_ptType.msgt_name = 2;
	InP->routine_entry_ptType.msgt_size = 32;
	InP->routine_entry_ptType.msgt_number = 1;
	InP->routine_entry_ptType.msgt_inline = TRUE;
	InP->routine_entry_ptType.msgt_longform = FALSE;
	InP->routine_entry_ptType.msgt_deallocate = FALSE;
	InP->routine_entry_ptType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->routine_entry_pt = routine_entry_pt;

#if	UseStaticMsgType
	InP->routine_numberType = routine_numberType;
#else	UseStaticMsgType
	InP->routine_numberType.msgt_name = 2;
	InP->routine_numberType.msgt_size = 32;
	InP->routine_numberType.msgt_number = 1;
	InP->routine_numberType.msgt_inline = TRUE;
	InP->routine_numberType.msgt_longform = FALSE;
	InP->routine_numberType.msgt_deallocate = FALSE;
	InP->routine_numberType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->routine_number = routine_number;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(19, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = (mach_port_t) target_port;
	InP->Head.msgh_reply_port = MACH_PORT_NULL;
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 2070;

	msg_result = mach_msg_rpc_from_kernel(&InP->Head, sizeof(Request), sizeof(Reply));
	if (msg_result != MACH_MSG_SUCCESS) {
		return msg_result;
	}

	if (OutP->Head.msgh_id != 2170) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	if ((OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX) ||
	    (OutP->Head.msgh_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	return OutP->RetCode;
}
