/* 
 * Mach Operating System
 * Copyright (c) 1992 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon 
 * the rights to redistribute these changes.
 */
/*
 * HISTORY
 * 12-Nov-92  Johannes Helander (jvh) at Helsinki University of Technology
 *	ANSI C fixes.
 * 	Added RSYSCALL macro. (syscall with return).
 *
 * $Log:	second_SYS.h,v $
 * Revision 2.1  92/04/21  17:19:09  rwd
 * BSDSS
 * 
 *
 */

/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	@(#)SYS.h	5.4 (Berkeley) 6/27/88
 */

/* WARNING: The following assumes that the parent server, under which
 * this server will run as a user process, has the same system call numbers
 * as the UNIX version under which we are compiling.  This may or may not
 * true, but it is the best we can do without further knowledge.
 */
#include </usr/include/sys/syscall.h>

#include <machine/asm.h>

#ifdef __STDC__

#define	SYSCALL(x)	ENTRY(second_ ## x); movl	$SYS_ ## x, %eax; SVC; jb LCL(second_cerror)

#define	RSYSCALL(x)	ENTRY(second_ ## x); movl	$SYS_ ## x, %eax; SVC; jb LCL(second_cerror); ret

#define	PSEUDO(x,y)	ENTRY(second_ ## x); movl	$SYS_ ## y, %eax; SVC

#else /* __STDC__ */

#define	SYSCALL(x)	ENTRY(second_/**/x); movl	$SYS_/**/x, %eax; SVC; jb LCL(second_cerror)

#define	RSYSCALL(x)	ENTRY(second_/**/x); movl	$SYS_/**/x, %eax; SVC; jb LCL(second_cerror); ret

#define	PSEUDO(x,y)	ENTRY(second_/**/x); movl	$SYS_/**/y, %eax; SVC

#endif /* __STDC__ */

#define	CALL(x,y)	calls $x, EXT(y)

	.globl	LCL(second_cerror)
