/* 
 * Copyright (c) 1992 Helsinki University of Technology
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * HELSINKI UNIVERSITY OF TECHNOLOGY ALLOWS FREE USE OF THIS SOFTWARE IN
 * ITS "AS IS" CONDITION. HELSINKI UNIVERSITY OF TECHNOLOGY DISCLAIMS ANY
 * LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE
 * USE OF THIS SOFTWARE.
 */
/*
 * HISTORY
 * 29-Apr-92  Tero Kivinen (kivinen) at Helsinki University of Technology
 *	Created.
 *
 * $Log$
 */
/*
 *  Author:	Tero Mononen (ASM)
 *		Tero Kivinen (C)
 *
 *  Network/host byte order conversion routines. Asm for mips and 
 *  generic c routines. Gcc generates equivalent code (same number
 *  of instructions on different order) with the handwriten asm.
 */

#if 0

#include <mach/mips/asm.h>

htons:
ntohs:
        sll     v0, a0, 8               /* v0 = 3210            */
        srl     v1, a0, 8               /* v1 = 0432            */
        andi    v1, v1, 0xff            /* v1 = 0002            */
        or      v0, v0, v1              /* v0 = 3212            */
        jr      ra                      /* ra = return          */
        andi    v0, v0, 0xffff          /* v0 = 0012            */

ntohl:
htohl:
        sll     v0, a0, 24              /* v0 = 4000            */
        srl     v1, a0, 24              /* v1 = 0001            */
        or      v0, v0, v1              /* v0 = 4001 (ready)    */

        srl     t0, a0, 8               /* t0 = 0123            */
        andi    v1, t0, 0xff            /* v1 = 0003            */
        sll     v1, v1, 16              /* v1 = 0300            */
        andi    t1, t0, 0xff00          /* t1 = 0020            */
        or      v1, v1, t1              /* v1 = 0320 (ready)    */

        jr      ra                      /* return               */
        or      v0, v0, v1              /* v0 = 4321            */
 
#else
unsigned short htons(unsigned short a)
{
        return ((a & 0xff) << 8) | ((a>>8) & 0xff); 
}
unsigned short ntohs(unsigned short a) { return htons(a); }

unsigned long htonl(unsigned long a)
{
        return (a << 24) | ((a & 0xff00) << 8) | ((a>>8) & 0xff00) | (a>>24);
}
unsigned long ntohl(unsigned long a) { return htonl(a); }
#endif
