/*
 *  This is the description of the images information that
 *  follows the BSD label on a pc532 disk (first 1k block).
 *
 *  Phil Nelson, Oct 23, 1991
 *
 *
 *  These structures are expected to reside on the first 1K bytes
 *  of a disk.  Their order and structures as follows:
 *
 *  -------------------
 *  | nothing         |
 *  -------------------
 *  | BSD disk_label  |
 *  -------------------
 *  | pc532 boot_info |
 *  -------------------
 *  
 */

/* Constants for the header block.  */
#define	IMAGE_MAGIC 0x6ef2b7d5L

#ifndef MAXIMAGES
#define MAXIMAGES 8
#endif

/* This is the header block. */

struct imageinfo {
	long  ii_magic;		    /* The magic number. */
	short ii_boot_partition;    /* The partition that holds the image. */
	short ii_boot_count;	    /* The number of boot entries. (>=1) */
	short ii_boot_used;	    /* The number of boot entries used. */
	short ii_boot_default;      /* The default boot image. */
	struct {
	    long  boot_address;	    /* The byte address of the boot image.
				       This address is relative to start of
				       the boot partition. */
	    long  boot_size;	    /* The size of the boot image in zones. */
	    long  boot_load_adr;    /* Where to load the image, real memory. */
	    long  boot_run_adr;	    /* The jump address to start the image. */
	    char  boot_name[16];    /* A title for the image. */
	} ii_images[MAXIMAGES];
};

