/* Extract text or data segment from a.out file.
 *
 * Bruce Culbertson
 * 3 Jan 89
 */



#include <fcntl.h>
#include <stdio.h>
#include "../include/magic.h"
#include "../include/conv.h"

#ifdef MSDOS
#  include "../include/a_out.h"
#else
#  include "../include/a.out.h"
#endif

#ifdef EXTRACTT				/* use -D option when compiling */
#  define PROGNAME "EXTRACTT"
#  define POS(x) TEXTPOS(x)
#  define SIZE(x) ((x).a_text)
#else
#  define PROGNAME "EXTRACTD"
#  define POS(x) DATAPOS(x)
#  define SIZE(x) ((x).a_data)
#endif
#define BUFSIZE 0x1000

main (argc, argv)
int argc;
char **argv;
{
  int in, out;
  long size, pos;

  if (argc != 3) error ("Usage: %s <input file> <output file>", PROGNAME);
  if (-1 == (in = open (argv[1], O_RDONLY
#ifdef MSDOS
    | O_BINARY
#endif
    ))) error ("Can not open %s", argv[1]);
  if (-1 == (out = open (argv[2], O_WRONLY | O_CREAT
#ifdef MSDOS
    | O_BINARY
#endif
    , 0666))) error ("Can not open %s", argv[2]);
  get_header (in, &size, &pos);
  copy (in, out, size, pos);
  close (in);
  close (out);
}

get_header (in, size, pos)
int in;
long *size, *pos;
{
  struct exec exec;

  if (sizeof (struct exec) != read (in, &exec, sizeof (struct exec)))
    error ("Can not read input file");
  CM2L(exec.a_magic);
  CM2L(exec.a_text);
  CM2L(exec.a_data);
  if (exec.a_magic != EXEC_MAGIC && exec.a_magic != RELOC_MAGIC)
    error ("Input file is not executable or relocatable file");
  *size = SIZE(exec);
  *pos = POS(exec);
}

copy (in, out, size, pos)
int in, out;
long size, pos;
{
  static char buf [BUFSIZE];
  int len;

  lseek (in, pos, 0);
  while (len = (size > BUFSIZE)? BUFSIZE: size) {
    if (len != read (in, buf, len))
      error ("Can not read input file");
    write (out, buf, len);
    size -= len;
  }
}

error (s, a, b, c, d, e)
char *s;
int a, b, c, d, e;
{
  fprintf (stderr, s, a, b, c, d, e);
  fputc ('\n', stderr);
  exit (-1);
}
