/* Program to build hashinit.h.  Expands mneumonics like MOVi to MOVB, MOVW,
 * and MOVD, and inserts proper fields into opcodes.  Saves time and, more
 * importantly, reduces risk of error.
 */
#include <stdio.h>

#define U32 unsigned long

char *i_to[] =     {"B",  "W",  "",   "D",
                    NULL};
char *f_to[] =     {"L",  "F",
                    NULL};
char *c_to[] =     {"EQ", "NE", "CS", "CC",
                    "HI", "LS", "GT", "LE",
                    "FS", "FC", "LO", "HS",
                    "LT", "GE", "R",  NULL};

struct ins {
  char from;
  char **to;
} insert[] =
{
  {'i', i_to},
  {'f', f_to},
  {'c', c_to},
};
#define INSERTSZ (sizeof (insert) / sizeof (struct ins))
int depth = 0, offset[3];
char typ[100], handler[100];

main()
{
  char inline [100], mneumonic[100], inst_str[100];
  U32 val;

  while (NULL != gets (inline)) {
    offset [0] = offset [1] = offset [2] = -1;
    if (3 < sscanf (inline, "%s %s %s %s %d %d %d", 
    mneumonic, typ, inst_str, handler,
    &offset[0], &offset[1], &offset[2])) {
      if (1 == sscanf (inst_str, "%lx", &val))
        expand (mneumonic, val);
      else print (mneumonic, inst_str);
    } else puts (inline);
  }
}

expand (mneumonic, val)
U32 val;
char *mneumonic;
{
  char new_mneumonic [100], *p, *q, *r, *s, **t, inst_str [20];
  struct ins *i;

  if (depth > 3) {
    fprintf (stderr, "Depth too great, something is wrong\n");
    exit (-1);
  }
  for (p = mneumonic; *p; ++p)
    for (i = insert; i < insert + INSERTSZ; ++i)
      if (*p == i->from) {
        for (t = i->to; *t != NULL; ++t) {
          if (**t != '\0') {
            for (q = mneumonic, r = new_mneumonic; q < p;)
              *r++ = *q++;
            for (s = *t; *s;)
              *r++ = *s++;
            for (++q; *q;)
              *r++ = *q++;
            *r = '\0';
            if (offset [depth] == -1) {
              fprintf (stderr,
                "mk_init error: missing offset for %s\n", mneumonic);
              exit (-1);
            }
            expand (new_mneumonic, val | (t - i->to) << offset [depth++]);
            --depth;
          }
        }
        return;
      }
  sprintf (inst_str, "0x%lx", val);
  print (mneumonic, inst_str);
}

print (mneumonic, inst_str)
char *mneumonic, *inst_str;
{
  int i;

  printf ("  {\"%s\",", mneumonic);
  for (i = 0; i < 10 - strlen (mneumonic); ++i)
    putchar (' ');
  printf ("%s,", typ);
  for (i = 0; i < 10 - strlen (typ); ++i)
    putchar (' ');
  printf ("NULL,   ");
  printf ("%s,", inst_str);
  for (i = 0; i < 10 - strlen (inst_str); ++i)
    putchar (' ');
  printf ("%s},\n", handler);
}
