/*
    Author: Maarten van Gelder, Groningen, Nederland
    E-mail: M.J.van.Gelder@kvi.nl
   Purpose: Generates Adobe Illustrator file(s) from Origami directives
            See ORITOAI.DOC for full documentation
     First version dd.19850515   OriDraw program in Turbo Pascal
     Copied           19931127   from OriDraw and adapted to 'standard' Pascal
     Converted to C   19950220
*/

#define last_revision "19990331"
#define this_unit "OriToAi"
#define prog_version "prog"
#define mytracelevel 1

#include "orilglbl.h"
#include "oriladil.h"
#include "orilxail.h"


FUNCTION void InitializeOriToAi(int *argc,char *argv[])
{
   InitString(ori_program_name,this_unit,20);
   InitString(ori_program_date,last_revision,20);
   InitializeOriLGlbl(argc,argv);
   InitializeOriLAdil(argc,argv);
   TRACE CheckMgSystem(this_unit,"InitializeOriToAi",true,mytracelevel,NULL);
   ProgramHeader(stdout);
   StringCopy(dumpfilename,20,"oritoai_.dmp",0);
}                                      /* InitializeOriToAi */


FUNCTION void StartFiles(void)
{
   TRACE CheckMgSystem(this_unit,"StartFiles",true,mytracelevel,NULL);
   if (! PathExist(globaldisk.filename)) StringCat(globaldisk.filename,-1,".ori",0);
   if (! PathExist(globaldisk.filename)) AbortBecause("File %s absent",globaldisk.filename);
   printf("Open file: %s\n",globaldisk.filename);
   ResetDefaults(true);
   firstdiagram=true;
   globaldisk.disk=fopen(globaldisk.filename,"r");
   if (! StartGlobalDataFileOk())  exit(1);
   PsOpenFile(globaldisk.filename);
   CopyStatus(&globalstatus,&status);
}                                      /* StartFiles */


FUNCTION void StopOriToAi(void)
{
   TRACE CheckMgSystem(this_unit,"StopOriToAi",true,mytracelevel,NULL);
   NextDiagram(&globaldisk,false);
   fclose(globaldisk.disk);
   printf("\n");
   ShowStatistics();
   switch (paper) {
      case a4:    printf("%10s","A4");    break;
      case a5:    printf("%10s","A5");    break;
   }
   printf(" paper\n");
   if (saturation<0.5) {
      printf("%10s Print in black and white\n"," ");
   } else {
      printf("%10s Print in color (saturation=%3.2f)\n"," ",saturation);
   }
   PsCloseFile();
   if (dumpatend) DumpStatus();
   if (! testmode) DeleteMacroFiles();
   ProgramTrailer(stdout);
}                                      /* StopOriToAi */


FUNCTION int /* OriToAi */ main(int argc,char *argv[])
{
   InitializeOriToAi(&argc,argv);
   ScanProgramParameters(argc,argv);
   StartFiles();
   InterpretCommands(&globaldisk);
   StopOriToAi();
   return 0;
}
